/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.EntityUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.item.behavior.ItemBehavior;
import xyz.xenondevs.nova.world.player.EventlessHandSwingingKt;
import xyz.xenondevs.nova.world.player.WrappedPlayerInteractEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/Extinguishing;", "Lxyz/xenondevs/nova/world/item/behavior/ItemBehavior;", "<init>", "()V", "handleInteract", "", "player", "Lorg/bukkit/entity/Player;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "action", "Lorg/bukkit/event/block/Action;", "wrappedEvent", "Lxyz/xenondevs/nova/world/player/WrappedPlayerInteractEvent;", "displayCampfireExtinguishParticles", "loc", "Lorg/bukkit/Location;", "type", "Lnet/minecraft/core/particles/ParticleType;", "nova"})
@SourceDebugExtension(value={"SMAP\nExtinguishing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extinguishing.kt\nxyz/xenondevs/nova/world/item/behavior/Extinguishing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n774#2:89\n865#2,2:90\n*S KotlinDebug\n*F\n+ 1 Extinguishing.kt\nxyz/xenondevs/nova/world/item/behavior/Extinguishing\n*L\n66#1:89\n66#1:90,2\n*E\n"})
public final class Extinguishing
implements ItemBehavior {
    @NotNull
    public static final Extinguishing INSTANCE = new Extinguishing();

    private Extinguishing() {
    }

    @Override
    public void handleInteract(@NotNull Player player, @NotNull ItemStack itemStack, @NotNull Action action, @NotNull WrappedPlayerInteractEvent wrappedEvent) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)((Object)wrappedEvent), (String)"wrappedEvent");
        if (wrappedEvent.getActionPerformed()) {
            return;
        }
        PlayerInteractEvent event = wrappedEvent.getEvent();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Block block = event.getClickedBlock();
            Intrinsics.checkNotNull((Object)block);
            Block block2 = block;
            BlockState state = NMSUtilsKt.getNmsState(block2);
            if (Intrinsics.areEqual((Object)state.getBlock(), (Object)Blocks.CAMPFIRE) && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                event.setCancelled(true);
                ServerPlayer serverPlayer = NMSUtilsKt.getServerPlayer(player);
                World world = block2.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
                ServerLevel level = NMSUtilsKt.getServerLevel(world);
                BlockPos pos = BlockPosKt.getPos(block2).getNmsPos();
                CampfireBlock.dowse((Entity)((Entity)NMSUtilsKt.getServerPlayer(player)), (LevelAccessor)((LevelAccessor)level), (BlockPos)pos, (BlockState)state);
                Location location = block2.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                SimpleParticleType simpleParticleType = (Boolean)state.getValue((Property)CampfireBlock.SIGNAL_FIRE) != false ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE;
                Intrinsics.checkNotNull((Object)simpleParticleType);
                this.displayCampfireExtinguishParticles(location, (ParticleType)simpleParticleType);
                BlockState newState = (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, newState, 11);
                level.levelEvent(null, 1009, pos, 0);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)((Entity)serverPlayer), (BlockState)newState));
                EquipmentSlot equipmentSlot = event.getHand();
                Intrinsics.checkNotNull((Object)equipmentSlot);
                EquipmentSlot hand = equipmentSlot;
                EntityUtilsKt.damageItemInHand$default((LivingEntity)player, hand, 0, 2, null);
                SchedulerUtilsKt.runTaskLater(1L, (Function0<Unit>)((Function0)() -> Extinguishing.handleInteract$lambda$0(player, hand)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void displayCampfireExtinguishParticles(Location loc, ParticleType<?> type) {
        void $this$filterTo$iv$iv;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getLocation().getWorld(), (Object)loc.getWorld()) && it.getLocation().distance(loc) <= 100.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List players = (List)destination$iv$iv;
        int n = 20;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            NMSUtilsKt.sendTo((Packet)ParticleBuilderKt.particle(type, arg_0 -> Extinguishing.displayCampfireExtinguishParticles$lambda$1$0(loc, arg_0)), players);
            SimpleParticleType simpleParticleType = ParticleTypes.SMOKE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SMOKE");
            NMSUtilsKt.sendTo((Packet)ParticleBuilderKt.particle((ParticleType)simpleParticleType, arg_0 -> Extinguishing.displayCampfireExtinguishParticles$lambda$1$1(loc, arg_0)), players);
        }
    }

    private static final Unit handleInteract$lambda$0(Player $player, EquipmentSlot $hand) {
        EventlessHandSwingingKt.swingHandEventless($player, $hand);
        return Unit.INSTANCE;
    }

    private static final Unit displayCampfireExtinguishParticles$lambda$1$0(Location $loc, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        Location location = $loc.clone().add(0.5 + Random.Default.nextDouble(-0.33, 0.33), 0.5 + Random.Default.nextDouble(-0.33, 0.33), 0.5 + Random.Default.nextDouble(-0.33, 0.33));
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        $this$particle.location(location);
        $this$particle.offsetY(0.07f);
        return Unit.INSTANCE;
    }

    private static final Unit displayCampfireExtinguishParticles$lambda$1$1(Location $loc, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        Location location = $loc.clone().add(0.5 + Random.Default.nextDouble(-0.25, 0.25), 0.5 + Random.Default.nextDouble(-0.25, 0.25), 0.5 + Random.Default.nextDouble(-0.25, 0.25));
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        $this$particle.location(location);
        $this$particle.offsetY(0.005f);
        return Unit.INSTANCE;
    }
}

