/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.behavior;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.event.entity.EntityEquipmentChangedEvent;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.key.Key;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.PlayerMapManager;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.world.item.behavior.ItemBehavior;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/NoHandAnimationWhileHolding;", "Lxyz/xenondevs/nova/world/item/behavior/ItemBehavior;", "<init>", "()V", "updateTasks", "", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/scheduler/BukkitTask;", "handleEquip", "", "player", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "slot", "Lorg/bukkit/inventory/EquipmentSlot;", "equipped", "", "event", "Lio/papermc/paper/event/entity/EntityEquipmentChangedEvent;", "modifyClientSideStack", "server", "client", "nova"})
public final class NoHandAnimationWhileHolding
implements ItemBehavior {
    @NotNull
    public static final NoHandAnimationWhileHolding INSTANCE = new NoHandAnimationWhileHolding();
    @NotNull
    private static final Map<Player, BukkitTask> updateTasks = PlayerMapManager.INSTANCE.create();

    private NoHandAnimationWhileHolding() {
    }

    @Override
    public void handleEquip(@NotNull Player player, @NotNull ItemStack itemStack, @NotNull EquipmentSlot slot, boolean equipped, @NotNull EntityEquipmentChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!slot.isHand()) {
            return;
        }
        float strengthScale = NMSUtilsKt.getServerPlayer(player).getAttackStrengthScale(1.0f);
        int pullUpTicks = (int)Math.ceil(1.0f / RangesKt.coerceAtMost((float)(strengthScale * strengthScale * strengthScale), (float)0.4f));
        long totalAnimationTime = 3L + (long)pullUpTicks;
        BukkitTask bukkitTask = updateTasks.remove(player);
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        if (equipped) {
            updateTasks.put(player, SchedulerUtilsKt.runTaskLater(totalAnimationTime, (Function0<Unit>)((Function0)() -> NoHandAnimationWhileHolding.handleEquip$lambda$0(player))));
        } else {
            player.updateInventory();
        }
    }

    @Override
    @NotNull
    public ItemStack modifyClientSideStack(@Nullable Player player, @NotNull ItemStack server, @NotNull ItemStack client) {
        Player player2;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Player player3 = player;
        if ((player3 != null ? player3.getGameMode() : null) == GameMode.CREATIVE) {
            return client;
        }
        Player player4 = player;
        if (Intrinsics.areEqual((Object)(player4 != null && (player4 = player4.getInventory()) != null ? player4.getItemInMainHand() : null), (Object)server) || Intrinsics.areEqual((Object)((player2 = player) != null && (player2 = player2.getInventory()) != null ? player2.getItemInOffHand() : null), (Object)server)) {
            Key key = (Key)client.getData(DataComponentTypes.ITEM_MODEL);
            if (key == null) {
                return client;
            }
            Key itemModel = key;
            client.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)itemModel.namespace(), (String)(itemModel.value() + "_no_hand_animation")));
        }
        return client;
    }

    private static final Unit handleEquip$lambda$0(Player $player) {
        $player.updateInventory();
        return Unit.INSTANCE;
    }
}

