/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.enchantment;

import io.papermc.paper.registry.TypedKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.nova.registry.LazyRegistryElementBuilder;
import xyz.xenondevs.nova.registry.RegistryEventManagerKt;
import xyz.xenondevs.nova.util.component.adventure.ComponentUtilsKt;
import xyz.xenondevs.nova.world.item.enchantment.CustomEnchantmentLogic;
import xyz.xenondevs.nova.world.item.enchantment.UnknownEnchantments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\n\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0010J)\u0010\u001d\u001a\u00020\u001a2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001e\u0012\b\b\b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010\f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0012J\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0012J\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0012J\u001a\u0010%\u001a\u00020\u001a2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000fJ\u001a\u0010'\u001a\u00020\u001a2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000fJ\u001a\u0010\u0011\u001a\u00020\u001a2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\u000fJ+\u0010(\u001a\u00020\u001a2\u001e\u0010)\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020+0*\"\b\u0012\u0004\u0012\u00020\u00020+\u00a2\u0006\u0002\u0010,J+\u0010-\u001a\u00020\u001a2\u001e\u0010)\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020+0*\"\b\u0012\u0004\u0012\u00020\u00020+\u00a2\u0006\u0002\u0010,J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0014J\u0013\u00101\u001a\b\u0012\u0004\u0012\u00020\u000202H\u0010\u00a2\u0006\u0002\b3R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lxyz/xenondevs/nova/world/item/enchantment/EnchantmentBuilder;", "Lxyz/xenondevs/nova/registry/LazyRegistryElementBuilder;", "Lorg/bukkit/enchantments/Enchantment;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "id", "Lnet/kyori/adventure/key/Key;", "<init>", "(Lnet/kyori/adventure/key/Key;)V", "name", "Lnet/kyori/adventure/text/Component;", "maxLevel", "", "rarity", "anvilCost", "tableLeveRequirement", "Lkotlin/Function1;", "Lkotlin/ranges/IntRange;", "compatibility", "", "primaryItem", "Lorg/bukkit/inventory/ItemStack;", "supportedItem", "isTableDiscoverable", "isTreasure", "isTradeable", "isCurse", "", "localizedName", "", "tableLevelRequirement", "Lkotlin/ParameterName;", "level", "weight", "tableDiscoverable", "treasure", "tradeable", "curse", "enchantsPrimary", "canEnchant", "enchants", "compatibleWith", "enchantments", "", "Lio/papermc/paper/registry/TypedKey;", "([Lio/papermc/paper/registry/TypedKey;)V", "incompatibleWith", "build", "lookup", "Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;", "register", "Lxyz/xenondevs/commons/provider/Provider;", "register$nova", "nova"})
@SourceDebugExtension(value={"SMAP\nEnchantmentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantmentBuilder.kt\nxyz/xenondevs/nova/world/item/enchantment/EnchantmentBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,268:1\n1#2:269\n11896#3,3:270\n11896#3,3:273\n*S KotlinDebug\n*F\n+ 1 EnchantmentBuilder.kt\nxyz/xenondevs/nova/world/item/enchantment/EnchantmentBuilder\n*L\n208#1:270,3\n219#1:273,3\n*E\n"})
public final class EnchantmentBuilder
extends LazyRegistryElementBuilder<org.bukkit.enchantments.Enchantment, Enchantment> {
    @NotNull
    private Component name;
    private int maxLevel;
    private int rarity;
    private int anvilCost;
    @NotNull
    private Function1<? super Integer, IntRange> tableLeveRequirement;
    @NotNull
    private Function1<? super Enchantment, Boolean> compatibility;
    @NotNull
    private Function1<? super ItemStack, Boolean> primaryItem;
    @NotNull
    private Function1<? super ItemStack, Boolean> supportedItem;
    private boolean isTableDiscoverable;
    private boolean isTreasure;
    private boolean isTradeable;
    private boolean isCurse;

    public EnchantmentBuilder(@NotNull Key id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResourceKey resourceKey = Registries.ENCHANTMENT;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"ENCHANTMENT");
        super(resourceKey, 1.INSTANCE, id);
        TranslatableComponent translatableComponent = Component.translatable((String)("enchantment." + id.namespace() + "." + id.value()));
        Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"translatable(...)");
        this.name = (Component)translatableComponent;
        this.maxLevel = 1;
        this.rarity = 10;
        this.anvilCost = 4;
        this.tableLeveRequirement = EnchantmentBuilder::tableLeveRequirement$lambda$0;
        this.compatibility = EnchantmentBuilder::compatibility$lambda$0;
        this.primaryItem = EnchantmentBuilder::primaryItem$lambda$0;
        this.supportedItem = EnchantmentBuilder::supportedItem$lambda$0;
    }

    public final void name(@NotNull Component name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    public final void localizedName(@NotNull String localizedName) {
        Intrinsics.checkNotNullParameter((Object)localizedName, (String)"localizedName");
        TranslatableComponent translatableComponent = Component.translatable((String)localizedName);
        Intrinsics.checkNotNullExpressionValue((Object)translatableComponent, (String)"translatable(...)");
        this.name = (Component)translatableComponent;
    }

    public final void maxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public final void anvilCost(int anvilCost) {
        this.anvilCost = anvilCost;
    }

    public final void tableLevelRequirement(@NotNull IntRange tableLeveRequirement) {
        Intrinsics.checkNotNullParameter((Object)tableLeveRequirement, (String)"tableLeveRequirement");
        this.tableLeveRequirement = arg_0 -> EnchantmentBuilder.tableLevelRequirement$lambda$0(tableLeveRequirement, arg_0);
    }

    public final void tableLevelRequirement(@NotNull Function1<? super Integer, IntRange> tableLeveRequirement) {
        Intrinsics.checkNotNullParameter(tableLeveRequirement, (String)"tableLeveRequirement");
        this.tableLeveRequirement = tableLeveRequirement;
    }

    public final void rarity(int weight) {
        if (!(1 <= weight ? weight < 1025 : false)) {
            boolean bl = false;
            String string = "Rarity must be between 1 and 1024";
            throw new IllegalArgumentException(string.toString());
        }
        this.rarity = weight;
    }

    public final void tableDiscoverable(boolean tableDiscoverable) {
        this.isTableDiscoverable = tableDiscoverable;
    }

    public final void treasure(boolean treasure) {
        this.isTreasure = treasure;
    }

    public final void tradeable(boolean tradeable) {
        this.isTradeable = tradeable;
    }

    public final void curse(boolean curse) {
        this.isCurse = curse;
    }

    public final void enchantsPrimary(@NotNull Function1<? super ItemStack, Boolean> canEnchant) {
        Intrinsics.checkNotNullParameter(canEnchant, (String)"canEnchant");
        this.primaryItem = canEnchant;
    }

    public final void enchants(@NotNull Function1<? super ItemStack, Boolean> canEnchant) {
        Intrinsics.checkNotNullParameter(canEnchant, (String)"canEnchant");
        this.supportedItem = canEnchant;
    }

    public final void compatibility(@NotNull Function1<? super org.bukkit.enchantments.Enchantment, Boolean> compatibility) {
        Intrinsics.checkNotNullParameter(compatibility, (String)"compatibility");
        this.compatibility = arg_0 -> EnchantmentBuilder.compatibility$lambda$1(compatibility, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    public final void compatibleWith(TypedKey<org.bukkit.enchantments.Enchantment> ... enchantments) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(enchantments, (String)"enchantments");
        TypedKey<org.bukkit.enchantments.Enchantment>[] typedKeyArray = enchantments;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv;
            void var9_8 = item$iv = $this$mapTo$iv[j];
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.key());
        }
        HashSet keySet = (HashSet)destination$iv;
        this.compatibility = arg_0 -> EnchantmentBuilder.compatibleWith$lambda$1(keySet, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    public final void incompatibleWith(TypedKey<org.bukkit.enchantments.Enchantment> ... enchantments) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(enchantments, (String)"enchantments");
        TypedKey<org.bukkit.enchantments.Enchantment>[] typedKeyArray = enchantments;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv;
            void var9_8 = item$iv = $this$mapTo$iv[j];
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.key());
        }
        HashSet keySet = (HashSet)destination$iv;
        this.compatibility = arg_0 -> EnchantmentBuilder.incompatibleWith$lambda$1(keySet, arg_0);
    }

    @Override
    @NotNull
    protected Enchantment build(@NotNull RegistryOps.RegistryInfoLookup lookup2) {
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        if (this.isCurse && this.maxLevel > 1) {
            throw new IllegalArgumentException("Curse enchantments cannot have multiple levels");
        }
        Enchantment enchantment = new Enchantment(ComponentUtilsKt.toNMSComponent(this.name), new Enchantment.EnchantmentDefinition((HolderSet)HolderSet.direct((Holder[])new Holder[0]), Optional.empty(), this.rarity, this.maxLevel, new Enchantment.Cost(0, 0), new Enchantment.Cost(0, 0), this.anvilCost, CollectionsKt.emptyList()), (HolderSet)HolderSet.direct((Holder[])new Holder[0]), DataComponentMap.EMPTY);
        ((Map)CustomEnchantmentLogic.customEnchantments).put(enchantment, new CustomEnchantmentLogic(this.primaryItem, this.supportedItem, this.tableLeveRequirement, this.compatibility));
        return enchantment;
    }

    @Override
    @NotNull
    public Provider<org.bukkit.enchantments.Enchantment> register$nova() {
        if (this.isTableDiscoverable) {
            TagKey tagKey = EnchantmentTags.IN_ENCHANTING_TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"IN_ENCHANTING_TABLE");
            RegistryEventManagerKt.plusAssign(tagKey, this.getId());
        }
        if (this.isCurse) {
            TagKey tagKey = EnchantmentTags.CURSE;
            Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"CURSE");
            RegistryEventManagerKt.plusAssign(tagKey, this.getId());
        }
        if (this.isTradeable) {
            TagKey tagKey = EnchantmentTags.TRADEABLE;
            Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"TRADEABLE");
            RegistryEventManagerKt.plusAssign(tagKey, this.getId());
        }
        if (this.isTreasure) {
            TagKey tagKey = EnchantmentTags.TREASURE;
            Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"TREASURE");
            RegistryEventManagerKt.plusAssign(tagKey, this.getId());
        }
        UnknownEnchantments.INSTANCE.rememberEnchantmentId(this.getId());
        return super.register$nova();
    }

    private static final IntRange tableLeveRequirement$lambda$0(int it) {
        int min = 1 + it * 10;
        return new IntRange(min, min + 5);
    }

    private static final boolean compatibility$lambda$0(Enchantment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean primaryItem$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final boolean supportedItem$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final IntRange tableLevelRequirement$lambda$0(IntRange $tableLeveRequirement, int it) {
        return $tableLeveRequirement;
    }

    private static final boolean compatibility$lambda$1(Function1 $compatibility, Enchantment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        org.bukkit.enchantments.Enchantment enchantment = CraftEnchantment.minecraftToBukkit((Enchantment)it);
        Intrinsics.checkNotNullExpressionValue((Object)enchantment, (String)"minecraftToBukkit(...)");
        return (Boolean)$compatibility.invoke((Object)enchantment);
    }

    private static final boolean compatibleWith$lambda$1(HashSet $keySet, Enchantment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $keySet.contains(CraftEnchantment.minecraftToBukkit((Enchantment)it).key());
    }

    private static final boolean incompatibleWith$lambda$1(HashSet $keySet, Enchantment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$keySet.contains(CraftEnchantment.minecraftToBukkit((Enchantment)it).key());
    }
}

