/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.gson.JsonArraysKt;
import xyz.xenondevs.commons.gson.JsonElementsKt;
import xyz.xenondevs.commons.gson.JsonObjectsKt;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.addon.Addon;
import xyz.xenondevs.nova.addon.AddonBootstrapper;
import xyz.xenondevs.nova.registry.NovaRegistries;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.serialization.json.serializer.RecipeDeserializer;
import xyz.xenondevs.nova.util.data.UpdatableFile;
import xyz.xenondevs.nova.world.item.recipe.RecipeType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0002J.\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0002J/\u0010\f\u001a\u0004\u0018\u0001H\u0007\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lxyz/xenondevs/nova/world/item/recipe/RecipesLoader;", "", "<init>", "()V", "extractAndLoadRecipes", "", "loadRecipes", "T", "folder", "", "deserializer", "Lxyz/xenondevs/nova/serialization/json/serializer/RecipeDeserializer;", "loadRecipe", "file", "Ljava/io/File;", "(Ljava/io/File;Lxyz/xenondevs/nova/serialization/json/serializer/RecipeDeserializer;)Ljava/lang/Object;", "nova"})
@SourceDebugExtension(value={"SMAP\nRecipesLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipesLoader.kt\nxyz/xenondevs/nova/world/item/recipe/RecipesLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1374#2:83\n1460#2,5:84\n1374#2:89\n1460#2,2:90\n1462#2,3:97\n1869#2,2:100\n1878#2,3:102\n1152#3:92\n1321#3:93\n1322#3:95\n1153#3:96\n1#4:94\n*S KotlinDebug\n*F\n+ 1 RecipesLoader.kt\nxyz/xenondevs/nova/world/item/recipe/RecipesLoader\n*L\n28#1:83\n28#1:84,5\n37#1:89\n37#1:90,2\n37#1:97,3\n64#1:100,2\n74#1:102,3\n41#1:92\n41#1:93\n41#1:95\n41#1:96\n41#1:94\n*E\n"})
public final class RecipesLoader {
    @NotNull
    public static final RecipesLoader INSTANCE = new RecipesLoader();

    private RecipesLoader() {
    }

    @NotNull
    public final List<Object> extractAndLoadRecipes() {
        UpdatableFile.INSTANCE.extractIdNamedFromAllAddons$nova("recipes");
        return this.loadRecipes();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> loadRecipes() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = (Iterable)NovaRegistries.RECIPE_TYPE;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RecipeType it = (RecipeType)element$iv$iv;
            boolean bl = false;
            RecipeDeserializer deserializer = it.getDeserializer();
            Iterable list$iv$iv = deserializer != null ? INSTANCE.loadRecipes(it.getDirName(), it.getDeserializer()) : CollectionsKt.emptyList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> loadRecipes(String folder, RecipeDeserializer<T> deserializer) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = AddonBootstrapper.getAddons();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv;
            Addon addon = (Addon)element$iv$iv;
            boolean bl = false;
            Path recipesDirectory = addon.getDataFolder().resolve("recipes/" + folder);
            Intrinsics.checkNotNull((Object)recipesDirectory);
            Sequence sequence = SequencesKt.filter((Sequence)PathsKt.walk((Path)recipesDirectory, (PathWalkOption[])new PathWalkOption[0]), RecipesLoader::loadRecipes$lambda$1$0);
            Collection destination$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                T it$iv;
                Object element$iv$iv2;
                Object element$iv = element$iv$iv2 = iterator.next();
                boolean bl2 = false;
                Path it = (Path)element$iv;
                boolean bl3 = false;
                File file = it.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                if (INSTANCE.loadRecipe(file, deserializer) == null) continue;
                boolean bl4 = false;
                destination$iv.add(it$iv);
            }
            Iterable list$iv$iv = destination$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final <T> T loadRecipe(File file, RecipeDeserializer<T> deserializer) {
        List list;
        boolean failSilently = false;
        Object element = JsonElementsKt.parseJson((File)file);
        if (element instanceof JsonArray) {
            list = JsonArraysKt.getAllJsonObjects((JsonArray)((JsonArray)element));
        } else if (element instanceof JsonObject) {
            if (JsonObjectsKt.hasArray((JsonObject)((JsonObject)element), (String)"recipes")) {
                Boolean bl = JsonObjectsKt.getBooleanOrNull((JsonObject)((JsonObject)element), (String)"failSilently");
                failSilently = bl != null ? bl : false;
                JsonArray jsonArray = ((JsonObject)element).getAsJsonArray("recipes");
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                list = JsonArraysKt.getAllJsonObjects((JsonArray)jsonArray);
            } else {
                Boolean bl = JsonObjectsKt.getBooleanOrNull((JsonObject)((JsonObject)element), (String)"failSilently");
                failSilently = bl != null ? bl : false;
                list = CollectionsKt.listOf((Object)element);
            }
        } else {
            list = null;
        }
        List fallbacks = list;
        element = fallbacks;
        if (!(element == null || element.isEmpty())) {
            ArrayList exceptions = new ArrayList();
            Iterable $this$forEach$iv = fallbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject obj = (JsonObject)element$iv;
                boolean bl = false;
                try {
                    return deserializer.deserialize(obj, file);
                }
                catch (Exception e) {
                    ((Collection)exceptions).add(e);
                }
            }
            if (!failSilently) {
                Iterable $this$forEachIndexed$iv = exceptions;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Exception e = (Exception)item$iv;
                    int i2 = n;
                    boolean bl = false;
                    NovaBootstrapperKt.getLOGGER().error("Could not load recipe in file " + file + " (recipe fallback " + i2 + ")", (Throwable)e);
                }
            }
        } else {
            NovaBootstrapperKt.getLOGGER().error("Invalid recipe file " + file + ": Recipe is neither a json object nor an array of json objects");
        }
        return null;
    }

    private static final boolean loadRecipes$lambda$1$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && ResourcePath.Companion.isValidPath(PathsKt.getName((Path)it));
    }
}

