/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.tool;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.component.Tool;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.behavior.Breakable;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.format.WorldDataManager;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.item.tool.VanillaToolCategories;
import xyz.xenondevs.nova.world.item.tool.VanillaToolCategory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/world/item/tool/ToolCategory;", "", "id", "Lnet/kyori/adventure/key/Key;", "<init>", "(Lnet/kyori/adventure/key/Key;)V", "getId", "()Lnet/kyori/adventure/key/Key;", "toString", "", "Companion", "nova"})
public class ToolCategory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key id;

    public ToolCategory(@NotNull Key id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
    }

    @NotNull
    public final Key getId() {
        return this.id;
    }

    @NotNull
    public String toString() {
        return this.id.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\tJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lxyz/xenondevs/nova/world/item/tool/ToolCategory$Companion;", "", "<init>", "()V", "hasCorrectToolCategory", "", "block", "Lorg/bukkit/block/Block;", "tool", "Lorg/bukkit/inventory/ItemStack;", "ofItem", "", "Lxyz/xenondevs/nova/world/item/tool/ToolCategory;", "item", "ofBlock", "nova"})
    @SourceDebugExtension(value={"SMAP\nToolCategory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolCategory.kt\nxyz/xenondevs/nova/world/item/tool/ToolCategory$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 NovaBlock.kt\nxyz/xenondevs/nova/world/block/NovaBlock\n*L\n1#1,120:1\n1761#2,3:121\n107#3:124\n*S KotlinDebug\n*F\n+ 1 ToolCategory.kt\nxyz/xenondevs/nova/world/item/tool/ToolCategory$Companion\n*L\n34#1:121,3\n88#1:124\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasCorrectToolCategory(@NotNull Block block, @Nullable ItemStack tool) {
            ToolCategory it;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Set<ToolCategory> itemToolCategories = this.ofItem(tool);
            Set<ToolCategory> blockToolCategories = this.ofBlock(block);
            if (((Collection)itemToolCategories).isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            Iterable $this$any$iv = itemToolCategories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (ToolCategory)element$iv;
                boolean bl2 = false;
            } while (!blockToolCategories.contains(it));
            return true;
        }

        @NotNull
        public final Set<ToolCategory> ofItem(@Nullable ItemStack item) {
            List rules;
            Set<ToolCategory> novaCategory;
            if (item == null) {
                return SetsKt.emptySet();
            }
            Object object = ItemUtilsKt.getNovaItem(item);
            Set<ToolCategory> set = object != null && (object = (xyz.xenondevs.nova.world.item.behavior.Tool)((NovaItem)object).getBehaviorOrNull(Reflection.getOrCreateKotlinClass(xyz.xenondevs.nova.world.item.behavior.Tool.class))) != null ? ((xyz.xenondevs.nova.world.item.behavior.Tool)object).getCategories() : (novaCategory = null);
            if (novaCategory != null) {
                return novaCategory;
            }
            HashSet categories = new HashSet();
            Tool tool = (Tool)NMSUtilsKt.unwrap(item).get(DataComponents.TOOL);
            List list = rules = tool != null ? tool.rules() : null;
            if (rules != null) {
                for (Tool.Rule rule : rules) {
                    VanillaToolCategory vanillaToolCategory;
                    Object object2;
                    HolderSet.Named named;
                    if (!rule.correctForDrops().orElse(false).booleanValue() || (named = (object2 = rule.blocks()) instanceof HolderSet.Named ? (HolderSet.Named)object2 : null) == null || (named = named.key()) == null) continue;
                    HolderSet.Named tagKey = named;
                    Collection collection = categories;
                    object2 = tagKey;
                    if (Intrinsics.areEqual((Object)object2, (Object)BlockTags.MINEABLE_WITH_AXE)) {
                        vanillaToolCategory = VanillaToolCategories.INSTANCE.getAXE();
                    } else if (Intrinsics.areEqual((Object)object2, (Object)BlockTags.MINEABLE_WITH_HOE)) {
                        vanillaToolCategory = VanillaToolCategories.INSTANCE.getHOE();
                    } else if (Intrinsics.areEqual((Object)object2, (Object)BlockTags.MINEABLE_WITH_PICKAXE)) {
                        vanillaToolCategory = VanillaToolCategories.INSTANCE.getPICKAXE();
                    } else if (Intrinsics.areEqual((Object)object2, (Object)BlockTags.MINEABLE_WITH_SHOVEL)) {
                        vanillaToolCategory = VanillaToolCategories.INSTANCE.getSHOVEL();
                    } else {
                        if (!Intrinsics.areEqual((Object)object2, (Object)BlockTags.LEAVES) && !Intrinsics.areEqual((Object)object2, (Object)BlockTags.WOOL)) continue;
                        vanillaToolCategory = VanillaToolCategories.INSTANCE.getSHEARS();
                    }
                    object2 = vanillaToolCategory;
                    collection.add(object2);
                }
            }
            Material material = item.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            Material type = material;
            if (Tag.ITEMS_SHOVELS.isTagged((Keyed)type)) {
                ((Collection)categories).add(VanillaToolCategories.INSTANCE.getSHOVEL());
            }
            if (Tag.ITEMS_PICKAXES.isTagged((Keyed)type)) {
                ((Collection)categories).add(VanillaToolCategories.INSTANCE.getPICKAXE());
            }
            if (Tag.ITEMS_AXES.isTagged((Keyed)type)) {
                ((Collection)categories).add(VanillaToolCategories.INSTANCE.getAXE());
            }
            if (Tag.ITEMS_HOES.isTagged((Keyed)type)) {
                ((Collection)categories).add(VanillaToolCategories.INSTANCE.getHOE());
            }
            if (Tag.ITEMS_SWORDS.isTagged((Keyed)type)) {
                ((Collection)categories).add(VanillaToolCategories.INSTANCE.getSWORD());
            }
            if (type == Material.SHEARS) {
                ((Collection)categories).add(VanillaToolCategories.INSTANCE.getSHEARS());
            }
            return categories;
        }

        @NotNull
        public final Set<ToolCategory> ofBlock(@NotNull Block block) {
            NovaBlock novaBlock;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            NovaBlockState novaBlockState = WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(block));
            NovaBlock novaBlock2 = novaBlock = novaBlockState != null ? novaBlockState.getBlock() : null;
            if (novaBlock != null) {
                NovaBlock this_$iv = novaBlock;
                boolean $i$f$getBehaviorOrNull = false;
                Breakable breakable = (Breakable)this_$iv.getBehaviorOrNull(Reflection.getOrCreateKotlinClass(Breakable.class));
                Object object = breakable;
                if (object == null || (object = object.getToolCategories()) == null) {
                    object = SetsKt.emptySet();
                }
                return object;
            }
            Material material = block.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            Material type = material;
            HashSet<VanillaToolCategory> categories = new HashSet<VanillaToolCategory>();
            if (Tag.MINEABLE_SHOVEL.isTagged((Keyed)type)) {
                categories.add(VanillaToolCategories.INSTANCE.getSHOVEL());
            }
            if (Tag.MINEABLE_PICKAXE.isTagged((Keyed)type)) {
                categories.add(VanillaToolCategories.INSTANCE.getPICKAXE());
            }
            if (Tag.MINEABLE_AXE.isTagged((Keyed)type)) {
                categories.add(VanillaToolCategories.INSTANCE.getAXE());
            }
            if (Tag.MINEABLE_HOE.isTagged((Keyed)type)) {
                categories.add(VanillaToolCategories.INSTANCE.getHOE());
            }
            if (type == Material.COBWEB || type == Material.BAMBOO_SAPLING || type == Material.BAMBOO) {
                categories.add(VanillaToolCategories.INSTANCE.getSWORD());
            }
            if (Tag.LEAVES.isTagged((Keyed)type) || Tag.WOOL.isTagged((Keyed)type) || type == Material.COBWEB) {
                categories.add(VanillaToolCategories.INSTANCE.getSHEARS());
            }
            return categories;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

