/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.loot;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.world.loot.LootItem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxyz/xenondevs/nova/world/loot/LootTable;", "", "items", "", "Lxyz/xenondevs/nova/world/loot/LootItem;", "whitelist", "Lorg/bukkit/NamespacedKey;", "blacklist", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "isAllowed", "", "key", "getRandomItems", "Lorg/bukkit/inventory/ItemStack;", "nova"})
@SourceDebugExtension(value={"SMAP\nLootTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LootTable.kt\nxyz/xenondevs/nova/world/loot/LootTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class LootTable {
    @NotNull
    private final List<LootItem> items;
    @NotNull
    private final List<NamespacedKey> whitelist;
    @NotNull
    private final List<NamespacedKey> blacklist;

    public LootTable(@NotNull List<LootItem> items, @NotNull List<NamespacedKey> whitelist, @NotNull List<NamespacedKey> blacklist) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(whitelist, (String)"whitelist");
        Intrinsics.checkNotNullParameter(blacklist, (String)"blacklist");
        this.items = items;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
    }

    public final boolean isAllowed(@NotNull NamespacedKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!((Collection)this.blacklist).isEmpty()) {
            return !this.blacklist.contains(key);
        }
        return this.whitelist.isEmpty() || this.whitelist.contains(key);
    }

    @NotNull
    public final List<ItemStack> getRandomItems() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.items), LootTable::getRandomItems$lambda$0), LootTable::getRandomItems$lambda$1));
    }

    private static final boolean getRandomItems$lambda$0(LootItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Math.random() * (double)100 <= it.getChance();
    }

    private static final ItemStack getRandomItems$lambda$1(LootItem it) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemStack $this$getRandomItems_u24lambda_u241_u240 = itemStack = it.getItem().clone();
        boolean bl = false;
        $this$getRandomItems_u24lambda_u241_u240.setAmount(RangesKt.random((IntRange)it.getAmount(), (Random)((Random)Random.Default)));
        return itemStack;
    }
}

