/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.impl;

import java.util.Arrays;
import java.util.Objects;
import me.srrapero720.chloride.ChlorideConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(modid="chloride", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class Overlay {
    private static final FPSDisplayBuilder DISPLAY = new FPSDisplayBuilder();
    private static final Component MSG_FPS = Component.translatable((String)"chloride.interface.fps");
    private static final Component MSG_MIN = Component.translatable((String)"chloride.interface.fps.min");
    private static final Component MSG_AVG = Component.translatable((String)"chloride.interface.fps.avg");
    private static final Component MSG_GPU = Component.translatable((String)"chloride.interface.fps.gpu");
    private static final Component MSG_MEM = Component.translatable((String)"chloride.interface.fps.mem");
    private static int fps = -1;
    private static int minFPS = -1;
    private static int avgFPS = -1;
    private static int gpuPercent = -1;
    private static int memUsage = -1;
    private static final int[] avgCount = new int[24];
    private static boolean avgFilled = false;
    private static int avgIndex = 0;

    public static void pushAvgFps(int value) {
        if (avgIndex == avgCount.length) {
            avgIndex = 0;
            avgFilled = true;
        }
        if (!avgFilled) {
            Arrays.fill(avgCount, avgIndex, avgCount.length, value);
        }
        Overlay.avgCount[Overlay.avgIndex++] = value;
    }

    public static int calculateAverage() {
        int times = 0;
        for (int i : avgCount) {
            times += i;
        }
        return times / avgCount.length;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        fps = mc.getFps();
        memUsage = (int)(Overlay.ramUsed() * 100L / Runtime.getRuntime().maxMemory());
        gpuPercent = Math.min((int)mc.getGpuUtilization(), 100);
        avgFPS = Overlay.calculateAverage();
        Overlay.renderFPSChar(mc, event.getGuiGraphics(), mc.font, Minecraft.getInstance().getWindow().getGuiScale());
    }

    private static void renderFPSChar(Minecraft mc, GuiGraphics graphics, Font font, double scale) {
        if (Minecraft.getInstance().getDebugOverlay().showDebugScreen() || Minecraft.getInstance().getDebugOverlay().showProfilerChart()) {
            return;
        }
        FPS mode = ChlorideConfig.fpsDisplayMode;
        FPSDetails systemMode = ChlorideConfig.fpsDisplaySystemMode;
        if (mode.off() && systemMode.off()) {
            return;
        }
        DISPLAY.release();
        switch (mode.ordinal()) {
            case 1: {
                DISPLAY.append(Overlay.colorByLow(fps)).add(Overlay.fix(fps)).add(" ").add(MSG_FPS.getString()).add(ChatFormatting.RESET);
                break;
            }
            case 2: {
                DISPLAY.append(Overlay.colorByLow(fps)).add(Overlay.fix(fps)).add(ChatFormatting.RESET);
                DISPLAY.append(Overlay.colorByLow(avgFPS)).add(MSG_AVG).add(" ").add(Overlay.fix(avgFPS)).add(ChatFormatting.RESET);
            }
        }
        if (!DISPLAY.isEmpty()) {
            DISPLAY.split();
        }
        switch (systemMode.ordinal()) {
            case 2: {
                DISPLAY.append(Overlay.colorByPercent(gpuPercent)).add(MSG_GPU).add(" ").add(Overlay.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case 3: {
                DISPLAY.append(Overlay.colorByPercent(memUsage)).add(MSG_MEM).add(" ").add(Overlay.fix(memUsage)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case 1: {
                DISPLAY.append(Overlay.colorByPercent(gpuPercent)).add(MSG_GPU).add(" ").add(Overlay.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                DISPLAY.append(Overlay.colorByPercent(memUsage)).add(MSG_MEM).add(" ").add(Overlay.fix(memUsage)).add("%").add(ChatFormatting.RESET);
            }
        }
        if (DISPLAY.isEmpty()) {
            DISPLAY.add("FATAL ERROR");
        }
        float marginX = scale > 0.0 ? (float)ChlorideConfig.fpsDisplayMargin / (float)scale : (float)ChlorideConfig.fpsDisplayMargin;
        float marginY = scale > 0.0 ? (float)ChlorideConfig.fpsDisplayVMargin / (float)scale : (float)ChlorideConfig.fpsDisplayVMargin;
        String displayString = DISPLAY.toString();
        float maxPosX = graphics.guiWidth() - font.width(displayString);
        int n = graphics.guiHeight();
        Objects.requireNonNull(font);
        float maxPosY = n - 9;
        float posX = switch (ChlorideConfig.fpsDisplayAlign.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> marginX;
            case 1 -> maxPosX / 2.0f;
            case 2 -> maxPosX - marginX;
        };
        float posY = switch (ChlorideConfig.fpsDisplayVAlign.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> marginY;
            case 1 -> maxPosY / 2.0f;
            case 2 -> maxPosY - marginY;
        };
        graphics.pose().pushPose();
        if (ChlorideConfig.fpsDisplayShadow) {
            int n2 = (int)posX - 2;
            int n3 = (int)posY - 2;
            int n4 = (int)posX + font.width(displayString) + 2;
            Objects.requireNonNull(font);
            graphics.fill(n2, n3, n4, (int)(posY + 9.0f) + 1, -1873784752);
            graphics.flush();
        }
        graphics.drawString(font, displayString, posX, posY, -1, true);
        DISPLAY.release();
        graphics.pose().popPose();
    }

    private static String fix(int value) {
        return value == -1 ? "--" : "" + value;
    }

    public static ChatFormatting colorByLow(int usage) {
        return usage < 9 ? ChatFormatting.DARK_RED : (usage < 16 ? ChatFormatting.RED : (usage < 30 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static ChatFormatting colorByPercent(int usage) {
        return usage >= 100 ? ChatFormatting.DARK_RED : (usage >= 90 ? ChatFormatting.RED : (usage >= 75 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static long ramUsed() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long bytesToMB(long input) {
        return input / 1024L / 1024L;
    }

    public static enum FPS {
        OFF,
        SIMPLE,
        ADVANCED;


        public boolean off() {
            return this == OFF;
        }
    }

    public static enum FPSDetails {
        OFF,
        ALL,
        GPU_ONLY,
        RAM_ONLY;


        public boolean ram() {
            return this == RAM_ONLY || this == ALL;
        }

        public boolean gpu() {
            return this == GPU_ONLY || this == ALL;
        }

        public boolean off() {
            return this == OFF;
        }
    }

    private static class FPSDisplayBuilder {
        private StringBuilder builder = new StringBuilder();
        private boolean split = false;
        private boolean divisor = false;

        private FPSDisplayBuilder() {
        }

        public FPSDisplayBuilder append(String param) {
            if (this.split) {
                this.builder.append(" - ");
            }
            if (this.divisor) {
                this.builder.append(" | ");
            }
            this.builder.append(param);
            this.split = false;
            this.divisor = true;
            return this;
        }

        public FPSDisplayBuilder append(ChatFormatting formatting) {
            return this.append(formatting.toString());
        }

        public FPSDisplayBuilder add(int param) {
            this.builder.append(param);
            return this;
        }

        public FPSDisplayBuilder add(String param) {
            this.builder.append(param);
            return this;
        }

        public FPSDisplayBuilder add(Component component) {
            return this.add(component.getString());
        }

        public FPSDisplayBuilder add(ChatFormatting formatting) {
            return this.add(formatting.toString());
        }

        public void split() {
            this.split = true;
            this.divisor = false;
        }

        public boolean isEmpty() {
            return this.builder.isEmpty();
        }

        public void release() {
            this.builder = new StringBuilder();
            this.split = false;
            this.divisor = false;
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    public static enum FPSAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum FPSVAlign {
        TOP,
        CENTER,
        BOTTOM;

    }
}

