/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.mixins.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import me.srrapero720.chloride.Chloride;
import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.api.IRenderableEntity;
import me.srrapero720.chloride.impl.EntityCulling;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class EntityDistanceCullingMixin {

    @Mixin(value={BlockEntityType.class})
    public static abstract class TileEntityTypeMixin
    implements IRenderableEntity {
        @Unique
        private static final Marker e$IT = MarkerManager.getMarker((String)"BlockEntityCulling");
        @Unique
        private boolean chloride$checked = false;
        @Unique
        private boolean chloride$whitelisted = false;

        @Override
        public boolean chloride$whitelisted() {
            if (this.chloride$checked) {
                return this.chloride$whitelisted;
            }
            ResourceLocation resource = BlockEntityType.getKey((BlockEntityType)((BlockEntityType)this));
            if (resource == null) {
                Chloride.LOGGER.warn(e$IT, "BlockEntity key for '{}' is null, not whitelisting a broken mod block", (Object)this.getClass().getName());
                return false;
            }
            this.chloride$whitelisted = EntityCulling.isWhitelisted(resource, ChlorideConfig.tileEntityWhitelist);
            this.chloride$checked = true;
            Chloride.LOGGER.debug(e$IT, "Computed BlockEntity whitelist for {}", (Object)resource.toString());
            return this.chloride$whitelisted;
        }
    }

    @Mixin(value={BlockEntityRenderDispatcher.class})
    public static class TileDispatcherMixin {
        @Shadow
        public Camera camera;

        @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
        public <E extends BlockEntity> void render(E tile, float val, PoseStack matrix, MultiBufferSource bufferSource, CallbackInfo ci) {
            if (!ChlorideConfig.tileEntityDistanceCulling) {
                return;
            }
            boolean isWhitelisted = ((IRenderableEntity)tile.getType()).chloride$whitelisted();
            if (!isWhitelisted && !EntityCulling.isEntityInRange(tile, this.camera.getPosition(), ChlorideConfig.tileEntityCullingDistanceY, ChlorideConfig.tileEntityCullingDistanceX)) {
                ci.cancel();
            }
        }
    }

    @Mixin(value={EntityType.class})
    public static abstract class EntityTypeMixin
    implements IRenderableEntity {
        @Unique
        private static final Marker e$IT = MarkerManager.getMarker((String)"EntityCulling");
        @Unique
        private boolean chloride$checked = false;
        @Unique
        private boolean chloride$whitelisted = false;

        @Shadow
        public abstract MobCategory getCategory();

        @Override
        @Unique
        public boolean chloride$whitelisted() {
            if (this.chloride$checked) {
                return this.chloride$whitelisted;
            }
            ResourceLocation resource = this.embPlus$resourceLocation();
            if (resource == null) {
                Chloride.LOGGER.warn(e$IT, "Entity Key '{}' is null, not whitelisting a broken mod entity", (Object)this.getClass().getName());
                return false;
            }
            this.chloride$whitelisted = EntityCulling.isWhitelisted(resource, this.getCategory() == MobCategory.MONSTER ? ChlorideConfig.monsterWhitelist : ChlorideConfig.entityWhitelist);
            this.chloride$checked = true;
            Chloride.LOGGER.debug(e$IT, "Computed Entity whitelist for {}", (Object)resource.toString());
            return this.chloride$whitelisted;
        }

        @Unique
        public ResourceLocation embPlus$resourceLocation() {
            return BuiltInRegistries.ENTITY_TYPE.getKey(this.embPlus$cast());
        }

        @Unique
        private EntityType<?> embPlus$cast() {
            return (EntityType)this;
        }
    }

    @Mixin(value={EntityRenderDispatcher.class})
    public static class EntityDispatcherMixin {
        @Inject(at={@At(value="HEAD")}, method={"shouldRender"}, cancellable=true)
        public <E extends Entity> void inject$shouldRender(E entity, Frustum clippingHelper, double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
            int distX;
            int distY;
            MobCategory category = entity.getType().getCategory();
            if (category == MobCategory.MONSTER) {
                if (!ChlorideConfig.monsterDistanceCulling) {
                    return;
                }
                distY = ChlorideConfig.monsterCullingDistanceY;
                distX = ChlorideConfig.monsterCullingDistanceX;
            } else {
                if (!ChlorideConfig.entityDistanceCulling) {
                    return;
                }
                distY = ChlorideConfig.entityCullingDistanceY;
                distX = ChlorideConfig.entityCullingDistanceX;
            }
            boolean isWhitelisted = ((IRenderableEntity)entity.getType()).chloride$whitelisted();
            if (!isWhitelisted && !EntityCulling.isEntityInRange(entity, x, y, z, distY, distX)) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

