/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import net.mcreator.elementallovesong.ElementallovesongMod;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="elementallovesong", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BadOmenProcedure {
    private static final int DETECT_RADIUS = 100;
    private static final int SPAWN_OFFSET = 10;
    private static final int SPAWN_DELAY = 40;
    private static final int COOLDOWN_AFTER_CLEAR = 7200;
    private static final int CHECK_INTERVAL = 80;
    private static final int SPAWN_RETRY_MAX = 3;
    private static final int LEVEL0_COUNT = 3;
    private static final int LEVEL1_COUNT = 7;
    private static final int LEVEL2_COUNT = 8;
    private static final int LEVEL3_COUNT = 11;
    private static final int LEVEL4_COUNT = 13;
    private static final int LEVEL5PLUS_COUNT = 13;
    private static final Map<UUID, Set<UUID>> playerActiveMobs = new ConcurrentHashMap<UUID, Set<UUID>>();
    private static final Map<UUID, Long> playerCooldownStart = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Integer> playerCurrentAmplifier = new ConcurrentHashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        UUID playerId = player.m_20148_();
        playerActiveMobs.remove(playerId);
        playerCooldownStart.remove(playerId);
        playerCurrentAmplifier.remove(playerId);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            UUID playerId = player.m_20148_();
            if (!((Set)playerActiveMobs.getOrDefault(playerId, new CopyOnWriteArraySet())).isEmpty() && serverLevel.m_46467_() % 80L == 0L) {
                BadOmenProcedure.checkAndCleanMobs(serverLevel, playerId);
            }
            BadOmenProcedure.execute(event, (LevelAccessor)serverLevel, player.m_20185_(), player.m_20186_(), player.m_20189_(), (Entity)player);
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        BadOmenProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable TickEvent.PlayerTickEvent event, LevelAccessor world, double x, double y, double z, Entity entity) {
        Set activeMobs;
        if (entity == null || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (!player.m_6084_() || !serverLevel.m_8795_(p -> true).contains(player)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        UUID playerId = player.m_20148_();
        long currentTick = serverLevel.m_46467_();
        if (!livingEntity.m_21023_(MobEffects.f_19594_)) {
            BadOmenProcedure.resetPlayerState(playerId);
            return;
        }
        int currentAmplifier = livingEntity.m_21124_(MobEffects.f_19594_).m_19564_();
        if (playerCurrentAmplifier.getOrDefault(playerId, -1) != currentAmplifier) {
            BadOmenProcedure.resetPlayerState(playerId);
            playerCurrentAmplifier.put(playerId, currentAmplifier);
        }
        if (!(activeMobs = (Set)playerActiveMobs.getOrDefault(playerId, new CopyOnWriteArraySet())).isEmpty()) {
            return;
        }
        Long cooldownStart = playerCooldownStart.getOrDefault(playerId, 0L);
        if (currentTick - cooldownStart < 7200L) {
            return;
        }
        if (currentTick % 20L != 0L) {
            return;
        }
        Vec3 centerPos = new Vec3(x, y, z);
        int nearbyCount = BadOmenProcedure.countNearbyIllagers(serverLevel, centerPos);
        if (nearbyCount >= 5) {
            return;
        }
        UUID playerIdCopy = playerId;
        Vec3 centerPosCopy = centerPos;
        int amplifierCopy = currentAmplifier;
        ElementallovesongMod.queueServerWork(40, () -> {
            Player cachedPlayer = serverLevel.m_46003_(playerIdCopy);
            if (!(cachedPlayer != null && cachedPlayer.m_6084_() && cachedPlayer.m_21023_(MobEffects.f_19594_) && cachedPlayer.m_21124_(MobEffects.f_19594_).m_19564_() == amplifierCopy && ((Set)playerActiveMobs.getOrDefault(playerIdCopy, new CopyOnWriteArraySet())).isEmpty() && serverLevel.m_46467_() - playerCooldownStart.getOrDefault(playerIdCopy, 0L) >= 7200L)) {
                return;
            }
            RandomSource random = RandomSource.m_216327_();
            CopyOnWriteArraySet<UUID> newMobs = new CopyOnWriteArraySet<UUID>();
            boolean spawnSuccess = false;
            switch (amplifierCopy) {
                case 0: {
                    spawnSuccess = BadOmenProcedure.spawnWithRetry(serverLevel, centerPosCopy, random, newMobs, 3, 0);
                    break;
                }
                case 1: {
                    spawnSuccess = BadOmenProcedure.spawnWithRetry(serverLevel, centerPosCopy, random, newMobs, 7, 1);
                    break;
                }
                case 2: {
                    spawnSuccess = BadOmenProcedure.spawnWithRetry(serverLevel, centerPosCopy, random, newMobs, 8, 2);
                    break;
                }
                case 3: {
                    spawnSuccess = BadOmenProcedure.spawnWithRetry(serverLevel, centerPosCopy, random, newMobs, 11, 3);
                    break;
                }
                case 4: {
                    spawnSuccess = BadOmenProcedure.spawnWithRetry(serverLevel, centerPosCopy, random, newMobs, 13, 4);
                    break;
                }
                default: {
                    spawnSuccess = BadOmenProcedure.spawnWithRetry(serverLevel, centerPosCopy, random, newMobs, 13, 5);
                }
            }
            if (spawnSuccess && newMobs.size() == BadOmenProcedure.getTargetCount(amplifierCopy) && ((Set)playerActiveMobs.getOrDefault(playerIdCopy, new CopyOnWriteArraySet())).isEmpty()) {
                playerActiveMobs.put(playerIdCopy, newMobs);
                playerCooldownStart.remove(playerIdCopy);
            }
        });
    }

    private static boolean spawnWithRetry(ServerLevel level, Vec3 centerPos, RandomSource random, Set<UUID> mobSet, int targetCount, int levelType) {
        int spawned = 0;
        int retry = 0;
        while (spawned < targetCount && retry < 3 * targetCount) {
            boolean success = false;
            switch (levelType) {
                case 0: {
                    success = BadOmenProcedure.spawnLevel0Single(level, centerPos, random, mobSet);
                    break;
                }
                case 1: {
                    success = BadOmenProcedure.spawnLevel1Single(level, centerPos, random, mobSet);
                    break;
                }
                case 2: {
                    success = BadOmenProcedure.spawnLevel2Single(level, centerPos, random, mobSet);
                    break;
                }
                case 3: {
                    success = BadOmenProcedure.spawnLevel3Single(level, centerPos, random, mobSet);
                    break;
                }
                case 4: {
                    success = BadOmenProcedure.spawnLevel4Single(level, centerPos, random, mobSet);
                    break;
                }
                case 5: {
                    success = BadOmenProcedure.spawnLevel5PlusSingle(level, centerPos, random, mobSet);
                }
            }
            if (success) {
                ++spawned;
                continue;
            }
            ++retry;
        }
        return spawned == targetCount;
    }

    private static boolean spawnLevel0Single(ServerLevel level, Vec3 centerPos, RandomSource random, Set<UUID> mobSet) {
        int currentSize = mobSet.size();
        if (currentSize < 2) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20513_, centerPos, random, 4.0f, mobSet);
        }
        return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20493_, centerPos, random, 9.0f, mobSet);
    }

    private static boolean spawnLevel1Single(ServerLevel level, Vec3 centerPos, RandomSource random, Set<UUID> mobSet) {
        int currentSize = mobSet.size();
        if (currentSize < 3) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20513_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 6) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20493_, centerPos, random, 4.0f, mobSet);
        }
        return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20459_, centerPos, random, 6.0f, mobSet);
    }

    private static boolean spawnLevel2Single(ServerLevel level, Vec3 centerPos, RandomSource random, Set<UUID> mobSet) {
        int currentSize = mobSet.size();
        if (currentSize < 3) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20513_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 6) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20493_, centerPos, random, 4.0f, mobSet);
        }
        return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20459_, centerPos, random, 4.0f, mobSet);
    }

    private static boolean spawnLevel3Single(ServerLevel level, Vec3 centerPos, RandomSource random, Set<UUID> mobSet) {
        int currentSize = mobSet.size();
        if (currentSize < 3) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20459_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 6) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20493_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 7) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20568_, centerPos, random, 9.0f, mobSet);
        }
        if (currentSize < 8) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20495_, centerPos, random, 9.0f, mobSet);
        }
        return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20513_, centerPos, random, 4.0f, mobSet);
    }

    private static boolean spawnLevel4Single(ServerLevel level, Vec3 centerPos, RandomSource random, Set<UUID> mobSet) {
        int currentSize = mobSet.size();
        if (currentSize < 2) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20568_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 5) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20513_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 8) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20493_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 11) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20459_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 12) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20518_, centerPos, random, 9.0f, mobSet);
        }
        return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20495_, centerPos, random, 9.0f, mobSet);
    }

    private static boolean spawnLevel5PlusSingle(ServerLevel level, Vec3 centerPos, RandomSource random, Set<UUID> mobSet) {
        int currentSize = mobSet.size();
        if (currentSize < 3) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20568_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 6) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20513_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 9) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20459_, centerPos, random, 4.0f, mobSet);
        }
        if (currentSize < 11) {
            return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20518_, centerPos, random, 4.0f, mobSet);
        }
        return BadOmenProcedure.spawnAndRecord(level, EntityType.f_20495_, centerPos, random, 4.0f, mobSet);
    }

    private static void checkAndCleanMobs(ServerLevel serverLevel, UUID playerId) {
        Set activeMobs = playerActiveMobs.getOrDefault(playerId, new CopyOnWriteArraySet());
        if (activeMobs.isEmpty()) {
            return;
        }
        boolean allDead = true;
        Iterator iterator = activeMobs.iterator();
        while (iterator.hasNext()) {
            UUID mobId = (UUID)iterator.next();
            Entity mob = serverLevel.m_8791_(mobId);
            if (mob != null && mob.m_6084_()) {
                allDead = false;
                continue;
            }
            iterator.remove();
        }
        if (allDead) {
            playerActiveMobs.remove(playerId);
            playerCooldownStart.put(playerId, serverLevel.m_46467_());
        } else {
            playerActiveMobs.put(playerId, activeMobs);
        }
    }

    private static int getTargetCount(int amplifier) {
        return switch (amplifier) {
            case 0 -> 3;
            case 1 -> 7;
            case 2 -> 8;
            case 3 -> 11;
            case 4 -> 13;
            default -> 13;
        };
    }

    private static int countNearbyIllagers(ServerLevel serverLevel, Vec3 centerPos) {
        AABB aabb = AABB.m_165882_((Vec3)centerPos, (double)100.0, (double)100.0, (double)100.0);
        int count = 0;
        count += serverLevel.m_6443_(Pillager.class, aabb, e -> true).size();
        count += serverLevel.m_6443_(Illusioner.class, aabb, e -> true).size();
        count += serverLevel.m_6443_(Evoker.class, aabb, e -> true).size();
        count += serverLevel.m_6443_(Vindicator.class, aabb, e -> true).size();
        count += serverLevel.m_6443_(Ravager.class, aabb, e -> true).size();
        return count += serverLevel.m_6443_(Witch.class, aabb, e -> true).size();
    }

    private static boolean isValidSpawnPosition(ServerLevel level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        if (level.m_46859_(below) && !level.m_8055_(below).m_280296_()) {
            return false;
        }
        if (!level.m_46859_(pos)) {
            return false;
        }
        return level.m_7146_(pos) <= 9;
    }

    private static <T extends Entity> boolean spawnAndRecord(ServerLevel level, EntityType<T> type, Vec3 centerPos, RandomSource random, float yRot, Set<UUID> mobSet) {
        double spawnZ;
        double spawnX = centerPos.f_82479_ + (double)Mth.m_216271_((RandomSource)random, (int)-20, (int)21);
        BlockPos spawnPos = BlockPos.m_274561_((double)spawnX, (double)centerPos.f_82480_, (double)(spawnZ = centerPos.f_82481_ + (double)Mth.m_216271_((RandomSource)random, (int)-20, (int)21)));
        if (!(BadOmenProcedure.isValidSpawnPosition(level, spawnPos) || BadOmenProcedure.isValidSpawnPosition(level, spawnPos = spawnPos.m_6630_(2)) || BadOmenProcedure.isValidSpawnPosition(level, spawnPos = spawnPos.m_6625_(3)))) {
            return false;
        }
        Entity entity = type.m_262496_(level, spawnPos, MobSpawnType.MOB_SUMMONED);
        if (entity != null) {
            entity.m_146922_(yRot);
            entity.m_5618_(yRot);
            entity.m_5616_(yRot);
            mobSet.add(entity.m_20148_());
            return true;
        }
        return false;
    }

    private static void resetPlayerState(UUID playerId) {
        playerActiveMobs.remove(playerId);
        playerCurrentAmplifier.remove(playerId);
        playerCooldownStart.remove(playerId);
    }
}

