/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class BxcnxProcedure {
    private static final long TICK_6MIN = TimeUnit.MINUTES.toSeconds(6L) * 20L;
    private static final long TICK_9MIN = TimeUnit.MINUTES.toSeconds(9L) * 20L;
    private static final long TICK_10MIN = TimeUnit.MINUTES.toSeconds(10L) * 20L;
    private static final String NBT_STAY_TIME = "desert_dehydration_time";
    private static final String NBT_LAST_STAGE = "desert_dehydration_stage";
    private static final String NBT_IS_DIZZY = "desert_dehydration_dizzy";
    private static final String WATER_BOTTLE_ID = "minecraft:water_bottle";
    private static final String DESERT_BIOME_ID = "minecraft:desert";
    private static final TextColor RED_COLOR = TextColor.m_131266_((int)0xFF0000);
    private static final Random RANDOM = new Random();
    private static final float BASE_ATTACK_DAMAGE = 1.0f;
    private static final float BASE_MINING_SPEED = 1.0f;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_5776_() || !player.m_6084_()) {
            return;
        }
        CompoundTag playerNBT = player.getPersistentData();
        boolean isInDesert = BxcnxProcedure.isPlayerInBiome(player, DESERT_BIOME_ID);
        long currentStayTime = playerNBT.m_128454_(NBT_STAY_TIME);
        if (!isInDesert) {
            BxcnxProcedure.resetDehydrationEffects(player);
            return;
        }
        playerNBT.m_128356_(NBT_STAY_TIME, ++currentStayTime);
        int currentStage = BxcnxProcedure.getDehydrationStage(currentStayTime);
        int lastStage = playerNBT.m_128451_(NBT_LAST_STAGE);
        if (currentStage > lastStage) {
            BxcnxProcedure.sendDehydrationWarning(player);
            playerNBT.m_128405_(NBT_LAST_STAGE, currentStage);
        }
        BxcnxProcedure.applyDehydrationEffects(player, currentStage);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.m_9236_();
        if (level.m_5776_() || !player.m_6084_()) {
            return;
        }
        CompoundTag playerNBT = player.getPersistentData();
        int currentStage = playerNBT.m_128451_(NBT_LAST_STAGE);
        if (currentStage == 0) {
            return;
        }
        float damageReduceRatio = BxcnxProcedure.getDamageReduceRatio(currentStage, BxcnxProcedure.hasAnyArmor(player));
        float baseDamage = event.getAmount() / (1.0f - damageReduceRatio);
        float finalDamage = Mth.m_14036_((float)(baseDamage * (1.0f - damageReduceRatio)), (float)0.1f, (float)baseDamage);
        event.setAmount(finalDamage);
    }

    @SubscribeEvent
    public static void onPlayerUseItem(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_5776_() || !player.m_6084_()) {
            return;
        }
        ItemStack heldStack = player.m_21205_();
        CompoundTag playerNBT = player.getPersistentData();
        int currentStage = playerNBT.m_128451_(NBT_LAST_STAGE);
        if (currentStage > 0 && BxcnxProcedure.isItemMatch(heldStack, WATER_BOTTLE_ID) && player.m_6117_() && player.m_21212_() == 0) {
            BxcnxProcedure.resetDehydrationState(player);
            player.m_213846_((Component)Component.m_237113_((String)"\u8131\u6c34\u72b6\u6001\u5df2\u7f13\u89e3\uff01").m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)65280))));
            heldStack.m_41774_(1);
            player.m_150109_().m_36054_(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:glass_bottle"))));
        }
    }

    private static void applyDehydrationEffects(Player player, int stage) {
        if (stage == 0) {
            BxcnxProcedure.resetDehydrationEffects(player);
            return;
        }
        CompoundTag playerNBT = player.getPersistentData();
        boolean hasArmor = BxcnxProcedure.hasAnyArmor(player);
        ItemStack mainHand = player.m_21205_();
        float miningSpeedReduceRatio = BxcnxProcedure.getMiningSpeedReduceRatio(stage, hasArmor);
        float finalMiningSpeed = Mth.m_14036_((float)(1.0f * (1.0f - miningSpeedReduceRatio)), (float)0.1f, (float)1.0f);
        player.m_21051_(Attributes.f_22283_).m_22100_((double)(finalMiningSpeed * 4.0f));
        if (playerNBT.m_128454_("dizzy_tick") % 20L == 0L) {
            boolean isDizzy = stage >= 1;
            playerNBT.m_128379_(NBT_IS_DIZZY, isDizzy);
            playerNBT.m_128356_("dizzy_tick", playerNBT.m_128454_("dizzy_tick") + 1L);
        }
        if (playerNBT.m_128471_(NBT_IS_DIZZY)) {
            BxcnxProcedure.applyDizzyMovement(player, stage, hasArmor);
            if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ == player) {
                Minecraft.m_91087_().f_91063_.m_109113_(mainHand);
            }
        }
    }

    private static float getDamageReduceRatio(int stage, boolean hasArmor) {
        float ratio = switch (stage) {
            case 1 -> 0.1f;
            case 2 -> 0.3f;
            case 3 -> 0.5f;
            default -> 0.0f;
        };
        return hasArmor ? ratio * 2.0f : ratio;
    }

    private static float getMiningSpeedReduceRatio(int stage, boolean hasArmor) {
        float ratio = switch (stage) {
            case 1 -> 0.2f;
            case 2 -> 0.4f;
            case 3 -> 0.6f;
            default -> 0.0f;
        };
        return hasArmor ? ratio * 2.0f : ratio;
    }

    private static void applyDizzyMovement(Player player, int stage, boolean hasArmor) {
        float dizzyStrength = switch (stage) {
            case 1 -> 0.05f;
            case 2 -> 0.1f;
            case 3 -> 0.15f;
            default -> 0.0f;
        };
        dizzyStrength = hasArmor ? dizzyStrength * 2.0f : dizzyStrength;
        double offsetX = (RANDOM.nextDouble() - 0.5) * (double)dizzyStrength;
        double offsetZ = (RANDOM.nextDouble() - 0.5) * (double)dizzyStrength;
        player.m_6034_(player.m_20185_() + offsetX, player.m_20186_(), player.m_20189_() + offsetZ);
    }

    private static void resetDehydrationEffects(Player player) {
        CompoundTag playerNBT = player.getPersistentData();
        player.m_21051_(Attributes.f_22283_).m_22100_(4.0);
        playerNBT.m_128379_(NBT_IS_DIZZY, false);
        playerNBT.m_128405_(NBT_LAST_STAGE, 0);
    }

    private static void resetDehydrationState(Player player) {
        CompoundTag playerNBT = player.getPersistentData();
        playerNBT.m_128356_(NBT_STAY_TIME, 0L);
        BxcnxProcedure.resetDehydrationEffects(player);
    }

    private static boolean isPlayerInBiome(Player player, String targetBiomeId) {
        Level level = player.m_9236_();
        Holder biomeHolder = level.m_204166_(player.m_20183_());
        ResourceLocation biomeLoc = biomeHolder.m_203543_().map(resourceKey -> resourceKey.m_135782_()).orElse(null);
        return biomeLoc != null && biomeLoc.toString().equals(targetBiomeId);
    }

    private static boolean isItemMatch(ItemStack stack, String targetItemId) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation itemLoc = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return itemLoc != null && itemLoc.toString().equals(targetItemId);
    }

    private static boolean hasAnyArmor(Player player) {
        return !player.m_6844_(EquipmentSlot.HEAD).m_41619_() || !player.m_6844_(EquipmentSlot.CHEST).m_41619_() || !player.m_6844_(EquipmentSlot.LEGS).m_41619_() || !player.m_6844_(EquipmentSlot.FEET).m_41619_();
    }

    private static int getDehydrationStage(long stayTime) {
        long total1 = TICK_6MIN;
        long total2 = TICK_6MIN + TICK_9MIN;
        long total3 = TICK_6MIN + TICK_9MIN + TICK_10MIN;
        if (stayTime >= total3) {
            return 3;
        }
        if (stayTime >= total2) {
            return 2;
        }
        if (stayTime >= total1) {
            return 1;
        }
        return 0;
    }

    private static void sendDehydrationWarning(Player player) {
        String playerLang = "en_us";
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().m_91102_() != null) {
            playerLang = Minecraft.m_91087_().m_91102_().m_264236_();
        }
        String warningText = playerLang.equalsIgnoreCase("zh_cn") || playerLang.equalsIgnoreCase("zh") ? "\u4f60\u8d76\u7d27\u559d\u6c34\uff0c\u8981\u4e0d\u5c31\u8131\u6c34\u4e86\uff01" : "You need to drink water quickly, otherwise you will dehydrate!";
        player.m_213846_((Component)Component.m_237113_((String)warningText).m_130938_(s -> s.m_131148_(RED_COLOR)));
    }
}

