/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class CjmvbProcedure {
    private static final double BASE_ENCHANT_CHANCE = 0.67;
    private static final double CURSE_ENCHANT_CHANCE = 0.05;
    private static final int MIN_LEVEL = 1;
    private static final int MAX_LEVEL = 5;
    private static final EquipmentSlot[] EQUIP_SLOTS = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        CjmvbProcedure.execute((LevelAccessor)event.getLevel(), event.getEntity());
    }

    public static void execute(LevelAccessor world, Entity entity) {
        LivingEntity livingEntity;
        block9: {
            block8: {
                if (entity == null) {
                    return;
                }
                if (!(entity instanceof LivingEntity)) break block8;
                livingEntity = (LivingEntity)entity;
                if (!world.m_5776_()) break block9;
            }
            return;
        }
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (!livingEntity.m_21023_(MobEffects.f_19596_)) {
            return;
        }
        int speedLevel = livingEntity.m_21124_(MobEffects.f_19596_).m_19564_() + 1;
        if (speedLevel <= 3) {
            return;
        }
        for (EquipmentSlot slot : EQUIP_SLOTS) {
            List<Enchantment> validEnchants;
            ItemStack equip = mob.m_6844_(slot);
            if (equip.m_41619_()) continue;
            double finalChance = 0.67 * (double)CjmvbProcedure.getEquipmentRarityFactor(equip);
            RandomSource random = mob.m_217043_();
            if (!(random.m_188500_() <= finalChance) || (validEnchants = CjmvbProcedure.getValidEnchants(equip, random)).isEmpty()) continue;
            Enchantment selectedEnchant = validEnchants.get(random.m_188503_(validEnchants.size()));
            int enchantLevel = CjmvbProcedure.getRandomEnchantLevel(selectedEnchant, equip, random);
            CjmvbProcedure.addEnchantToStack(equip, selectedEnchant, enchantLevel);
        }
    }

    private static float getEquipmentRarityFactor(ItemStack stack) {
        String itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
        if (itemId.contains("wooden") || itemId.contains("leather")) {
            return 0.8f;
        }
        if (itemId.contains("iron") || itemId.contains("chainmail")) {
            return 1.0f;
        }
        if (itemId.contains("gold") || itemId.contains("diamond")) {
            return 1.2f;
        }
        if (itemId.contains("netherite")) {
            return 1.5f;
        }
        return 1.0f;
    }

    private static List<Enchantment> getValidEnchants(ItemStack stack, RandomSource random) {
        ArrayList<Enchantment> valid = new ArrayList<Enchantment>();
        for (Enchantment enchant : ForgeRegistries.ENCHANTMENTS.getValues()) {
            if (!enchant.canApplyAtEnchantingTable(stack)) continue;
            if (enchant.m_6589_()) {
                if (!(random.m_188500_() <= 0.05)) continue;
                valid.add(enchant);
                continue;
            }
            valid.add(enchant);
        }
        return valid;
    }

    private static int getRandomEnchantLevel(Enchantment enchant, ItemStack stack, RandomSource random) {
        int maxPossibleLevel = enchant.m_6586_();
        int levelCap = Math.min(5, maxPossibleLevel);
        int baseLevel = random.m_188503_(levelCap - 1 + 1) + 1;
        String itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
        if ((itemId.contains("gold") || itemId.contains("diamond") || itemId.contains("netherite")) && random.m_188500_() <= 0.3) {
            baseLevel = Math.min(baseLevel + 1, maxPossibleLevel);
        }
        return baseLevel;
    }

    private static void addEnchantToStack(ItemStack stack, Enchantment enchant, int level) {
        Map existingEnchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (existingEnchants.containsKey(enchant)) {
            level = Math.max((Integer)existingEnchants.get(enchant), level);
        }
        existingEnchants.put(enchant, level);
        EnchantmentHelper.m_44865_((Map)existingEnchants, (ItemStack)stack);
    }
}

