/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mcreator.elementallovesong.init.ElementallovesongModEnchantments;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber
public class CmProcedure {
    private static final Random RANDOM = new Random();
    private static final Logger LOGGER = LoggerFactory.getLogger(CmProcedure.class);
    private static final int MAX_CHAIN_BLOCKS = 64;
    private static final List<BlockTypeToolPair> TOOL_BLOCK_PAIRS = List.of(new BlockTypeToolPair(Blocks.f_50069_, "pickaxe"), new BlockTypeToolPair(Blocks.f_49997_, "pickaxe"), new BlockTypeToolPair(Blocks.f_49996_, "pickaxe"), new BlockTypeToolPair(Blocks.f_49999_, "axe"), new BlockTypeToolPair(Blocks.f_50000_, "axe"), new BlockTypeToolPair(Blocks.f_50050_, "shears"), new BlockTypeToolPair(Blocks.f_50051_, "shears"), new BlockTypeToolPair(Blocks.f_50493_, "shovel"), new BlockTypeToolPair(Blocks.f_50440_, "shovel"));

    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        BlockPos brokenPos = event.getPos();
        LevelAccessor world = event.getLevel();
        if (world.m_5776_() || player.m_7500_() || !player.m_6084_()) {
            return;
        }
        CmProcedure.execute(world, brokenPos.m_123341_(), brokenPos.m_123342_(), brokenPos.m_123343_(), (Entity)player);
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        ItemStack usedTool;
        LOGGER.info("\u8fde\u9501\u91c7\u77ff\u89e6\u53d1 - \u5750\u6807: ({}, {}, {})", new Object[]{x, y, z});
        if (entity == null || world == null || !(world instanceof ServerLevel)) {
            LOGGER.warn("\u65e0\u6548\u53c2\u6570\uff1a\u4e16\u754c / \u5b9e\u4f53\u4e3a\u7a7a\u6216\u975e\u670d\u52a1\u7aef");
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (!(entity instanceof Player)) {
            LOGGER.warn("\u89e6\u53d1\u5b9e\u4f53\u975e\u73a9\u5bb6\uff0c\u7ec8\u6b62\u6267\u884c");
            return;
        }
        Player player = (Player)entity;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        int chainLevel = CmProcedure.getChainMiningLevel(mainHand, offHand);
        if (chainLevel <= 0) {
            LOGGER.info("\u5de5\u5177\u65e0\u8fde\u9501\u91c7\u77ff\u9644\u9b54\uff0c\u7ec8\u6b62\u6267\u884c");
            return;
        }
        BlockPos centerPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockState originalState = world.m_8055_(centerPos);
        if (originalState.m_60713_(Blocks.f_50016_) || originalState.m_60713_(Blocks.f_50752_) || !CmProcedure.isChainableBlock(originalState, mainHand)) {
            LOGGER.info("\u539f\u59cb\u65b9\u5757\u4e0d\u53ef\u8fde\u9501\uff0c\u7ec8\u6b62\u6267\u884c");
            return;
        }
        List<BlockPos> blocksToBreak = CmProcedure.collectChainableBlocks(world, centerPos, originalState, chainLevel);
        if (blocksToBreak.isEmpty()) {
            CmProcedure.sendPlayerMessage(player, "\u672a\u627e\u5230\u53ef\u8fde\u9501\u7684\u65b9\u5757\uff01", "No chainable blocks found!");
            return;
        }
        ItemStack itemStack = usedTool = mainHand.m_41619_() ? offHand : mainHand;
        if (usedTool.m_41619_() || usedTool.m_41773_() + 1 >= usedTool.m_41776_()) {
            CmProcedure.sendPlayerMessage(player, "\u5de5\u5177\u8010\u4e45\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8fde\u9501\u91c7\u77ff\uff01", "Not enough tool durability for chain mining!");
            return;
        }
        CmProcedure.breakCollectedBlocks(serverWorld, player, blocksToBreak, originalState, usedTool);
        CmProcedure.sendPlayerMessageWithCount(player, "\u8fde\u9501\u91c7\u77ff\u6210\u529f\uff01\u5171\u7834\u574f % d \u4e2a\u65b9\u5757", "Chain mining successful! Broke % d blocks", blocksToBreak.size());
    }

    private static void sendPlayerMessage(Player player, String chineseText, String englishText) {
        String playerLang = "en_us";
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().m_91102_() != null) {
            playerLang = Minecraft.m_91087_().m_91102_().m_264236_();
        }
        String finalText = playerLang.equalsIgnoreCase("zh_cn") || playerLang.equalsIgnoreCase("zh") ? chineseText : englishText;
        TextColor color = finalText.contains("\u672a\u627e\u5230") || finalText.contains("\u4e0d\u8db3") ? TextColor.m_131266_((int)0xFFFF00) : TextColor.m_131266_((int)65280);
        player.m_213846_((Component)Component.m_237113_((String)finalText).m_130938_(style -> style.m_131148_(color)));
    }

    private static void sendPlayerMessageWithCount(Player player, String chinesePattern, String englishPattern, int count) {
        String playerLang = "en_us";
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().m_91102_() != null) {
            playerLang = Minecraft.m_91087_().m_91102_().m_264236_();
        }
        String finalText = playerLang.equalsIgnoreCase("zh_cn") || playerLang.equalsIgnoreCase("zh") ? String.format(chinesePattern, count) : String.format(englishPattern, count);
        player.m_213846_((Component)Component.m_237113_((String)finalText).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)65280))));
    }

    private static int getChainMiningLevel(ItemStack mainHand, ItemStack offHand) {
        if (ElementallovesongModEnchantments.CHAIN_MINING.get() == null) {
            return 0;
        }
        int mainLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.CHAIN_MINING.get()), (ItemStack)mainHand);
        int offLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.CHAIN_MINING.get()), (ItemStack)offHand);
        return Math.max(mainLevel, offLevel);
    }

    private static boolean isChainableBlock(BlockState state, ItemStack tool) {
        if (tool.m_41619_()) {
            return false;
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (blockId == null) {
            return false;
        }
        String toolType = CmProcedure.getToolTypeFromItem(tool);
        if (toolType.isEmpty()) {
            return false;
        }
        for (BlockTypeToolPair pair : TOOL_BLOCK_PAIRS) {
            if (!blockId.m_135815_().contains(pair.blockIdPart) || !toolType.equals(pair.requiredToolType)) continue;
            return true;
        }
        return false;
    }

    private static String getToolTypeFromItem(ItemStack tool) {
        if (tool.m_41720_() instanceof TieredItem) {
            String itemId = ForgeRegistries.ITEMS.getKey((Object)tool.m_41720_()).m_135815_();
            if (itemId.contains("pickaxe")) {
                return "pickaxe";
            }
            if (itemId.contains("axe")) {
                return "axe";
            }
            if (itemId.contains("shovel")) {
                return "shovel";
            }
        } else if (tool.m_41720_() instanceof ShearsItem) {
            return "shears";
        }
        return "";
    }

    private static List<BlockPos> collectChainableBlocks(LevelAccessor world, BlockPos center, BlockState originalState, int chainLevel) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        int radius = chainLevel;
        int maxY = world.m_151558_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int targetY = center.m_123342_() + dy;
                    if (targetY < 0 || targetY >= maxY || dx * dx + dy * dy + dz * dz > radius * radius) continue;
                    mutablePos.m_122178_(center.m_123341_() + dx, targetY, center.m_123343_() + dz);
                    BlockState targetState = world.m_8055_((BlockPos)mutablePos);
                    if (targetState.m_60734_() != originalState.m_60734_() || blocks.contains(mutablePos)) continue;
                    blocks.add(mutablePos.m_7949_());
                    if (blocks.size() < 64) continue;
                    return blocks;
                }
            }
        }
        return blocks;
    }

    private static void breakCollectedBlocks(ServerLevel world, Player player, List<BlockPos> blocks, BlockState originalState, ItemStack tool) {
        UseOnContext toolContext = new UseOnContext(player, player.m_21205_() == tool ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)((Vec3i)blocks.get(0))), Direction.UP, blocks.get(0), false));
        for (BlockPos pos : blocks) {
            BlockState currentState = world.m_8055_(pos);
            if (currentState.m_60734_() != originalState.m_60734_()) continue;
            Block.m_49881_((BlockState)currentState, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)tool);
            int xp = CmProcedure.calculateBlockExperience(currentState, tool);
            if (xp > 0) {
                originalState.m_60734_().m_49805_(world, pos, xp);
            }
            world.m_5594_(null, pos, originalState.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f + (RANDOM.nextFloat() - 0.5f) * 0.2f);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        if (!player.m_7500_()) {
            tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_21205_() == tool ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
        }
    }

    private static int calculateBlockExperience(BlockState state, ItemStack tool) {
        Block block = state.m_60734_();
        int baseXp = 0;
        baseXp = block == Blocks.f_49997_ || block == Blocks.f_152469_ ? 2 + RANDOM.nextInt(4) : (block == Blocks.f_49995_ || block == Blocks.f_152467_ ? 2 + RANDOM.nextInt(4) : (block == Blocks.f_49996_ || block == Blocks.f_152468_ ? 0 : 0));
        int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
        if (fortuneLevel > 0 && baseXp > 0) {
            baseXp *= 1 + RANDOM.nextInt(fortuneLevel + 1);
        }
        return baseXp;
    }

    private static class BlockTypeToolPair {
        final String blockIdPart;
        final String requiredToolType;

        BlockTypeToolPair(Block block, String requiredToolType) {
            ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
            this.blockIdPart = blockId != null ? blockId.m_135815_() : "";
            this.requiredToolType = requiredToolType;
        }
    }
}

