/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.elementallovesong.init.ElementallovesongModEnchantments;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="elementallovesong")
public class ExplodinProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplodinProcedure.class);
    private static final Map<String, Long> cooldownMap = new HashMap<String, Long>();
    private static final long COOLDOWN = 3000L;

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        LivingEntity blocker = event.getEntity();
        if (!(blocker instanceof Player)) {
            LOGGER.debug("\u672a\u89e6\u53d1\uff1a\u683c\u6321\u8005\u4e0d\u662f\u73a9\u5bb6");
            return;
        }
        Player player = (Player)blocker;
        ItemStack blockingShield = ExplodinProcedure.getBlockingShield(player);
        if (blockingShield.m_41619_() || !(blockingShield.m_41720_() instanceof ShieldItem)) {
            LOGGER.debug("\u672a\u89e6\u53d1\uff1a\u672a\u6301\u6709\u76fe\u724c");
            return;
        }
        int enchantLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.EXPLODING_SHIELD.get()), (ItemStack)blockingShield);
        if (enchantLevel <= 0) {
            LOGGER.debug("\u672a\u89e6\u53d1\uff1a\u76fe\u724c\u65e0\u9644\u9b54\uff08\u7b49\u7ea7\uff1a{}\uff09", (Object)enchantLevel);
            return;
        }
        DamageSource source = event.getDamageSource();
        if (ExplodinProcedure.isRemoteDamage(source)) {
            LOGGER.debug("\u672a\u89e6\u53d1\uff1a\u8fdc\u7a0b\u4f24\u5bb3\uff08\u7c7b\u578b\uff1a{}\uff09", (Object)source.m_19385_());
            return;
        }
        String playerUUID = player.m_20148_().toString();
        long currentTime = System.currentTimeMillis();
        if (cooldownMap.containsKey(playerUUID) && currentTime - cooldownMap.get(playerUUID) < 3000L) {
            LOGGER.debug("\u672a\u89e6\u53d1\uff1a\u51b7\u5374\u4e2d");
            return;
        }
        if (!player.m_7500_() && blockingShield.m_41773_() == 0) {
            LOGGER.debug("\u672a\u89e6\u53d1\uff1a\u76fe\u724c\u672a\u53d7\u635f\uff08\u8010\u4e45\uff1a{}\uff09", (Object)blockingShield.m_41773_());
            return;
        }
        ExplodinProcedure.triggerExplosion(player.m_9236_(), player, enchantLevel);
        cooldownMap.put(playerUUID, currentTime);
        LOGGER.debug("\u7206\u70b8\u89e6\u53d1\uff1a\u7b49\u7ea7{}", (Object)enchantLevel);
    }

    private static ItemStack getBlockingShield(Player player) {
        ItemStack offHand = player.m_21206_();
        if (offHand.m_41720_() instanceof ShieldItem) {
            return offHand;
        }
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() instanceof ShieldItem) {
            return mainHand;
        }
        return ItemStack.f_41583_;
    }

    private static boolean isRemoteDamage(DamageSource source) {
        String damageType = source.m_19385_();
        return source.m_7640_() instanceof Projectile || damageType.contains("arrow") || damageType.contains("fireball") || damageType.contains("snowball") || damageType.contains("magic") || damageType.contains("explosion");
    }

    private static void triggerExplosion(Level world, Player player, int enchantLevel) {
        if (world.m_5776_()) {
            return;
        }
        float radius = Math.min((float)enchantLevel * 2.0f, 8.0f);
        double x = player.m_20185_() + player.m_20154_().f_82479_ * 0.5;
        double y = player.m_20186_() + (double)player.m_20192_() - 0.3;
        double z = player.m_20189_() + player.m_20154_().f_82481_ * 0.5;
        world.m_254849_(null, x, y, z, radius, Level.ExplosionInteraction.MOB);
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 2.0f, 1.0f);
    }
}

