/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class FndxProcedure {
    private static final long TICK_6MIN = TimeUnit.MINUTES.toSeconds(6L) * 20L;
    private static final long TICK_9MIN = TimeUnit.MINUTES.toSeconds(9L) * 20L;
    private static final long TICK_10MIN = TimeUnit.MINUTES.toSeconds(10L) * 20L;
    private static final List<String> SNOW_BIOME_IDS = List.of("minecraft:snowy_plains", "minecraft:snowy_taiga", "minecraft:snowy_mountains", "minecraft:frozen_ocean", "minecraft:frozen_river");
    private static final String NBT_STAY_TIME = "snow_cold_stay_time";
    private static final String NBT_LAST_STAGE = "snow_cold_stage";
    private static final String NBT_LAST_HURT_TICK = "snow_cold_last_hurt";
    private static final TextColor RED_COLOR = TextColor.m_131266_((int)0xFF0000);
    private static final int HURT_INTERVAL = 200;
    private static final float BASE_MOVE_SPEED = 0.1f;
    private static final float BASE_ATTACK_DAMAGE = 1.0f;
    private static final float BASE_MINING_SPEED = 1.0f;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_5776_() || !player.m_6084_()) {
            return;
        }
        if (FndxProcedure.isFullLeatherArmor(player)) {
            FndxProcedure.resetColdEffects(player);
            return;
        }
        CompoundTag playerNBT = player.getPersistentData();
        boolean isInSnowBiome = FndxProcedure.isPlayerInSnowBiome(player, level);
        long currentStayTime = playerNBT.m_128454_(NBT_STAY_TIME);
        if (!isInSnowBiome) {
            FndxProcedure.resetColdEffects(player);
            return;
        }
        playerNBT.m_128356_(NBT_STAY_TIME, ++currentStayTime);
        int currentStage = FndxProcedure.getColdStage(currentStayTime);
        int lastStage = playerNBT.m_128451_(NBT_LAST_STAGE);
        if (currentStage > lastStage) {
            FndxProcedure.sendColdWarning(player);
            playerNBT.m_128405_(NBT_LAST_STAGE, currentStage);
        }
        boolean isNonLeatherArmor = FndxProcedure.hasNonLeatherArmor(player);
        FndxProcedure.applyColdEffects(player, level, currentStage, isNonLeatherArmor);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.m_9236_();
        if (level.m_5776_() || !player.m_6084_()) {
            return;
        }
        if (FndxProcedure.isFullLeatherArmor(player)) {
            return;
        }
        CompoundTag playerNBT = player.getPersistentData();
        int currentStage = playerNBT.m_128451_(NBT_LAST_STAGE);
        if (currentStage == 0) {
            return;
        }
        float damageReduceRatio = FndxProcedure.getDamageReduceRatio(currentStage, FndxProcedure.hasNonLeatherArmor(player));
        float baseDamage = event.getAmount() / (1.0f - damageReduceRatio);
        float finalDamage = Mth.m_14036_((float)(baseDamage * (1.0f - damageReduceRatio)), (float)0.1f, (float)baseDamage);
        event.setAmount(finalDamage);
    }

    private static void applyColdEffects(Player player, Level level, int stage, boolean isNonLeatherArmor) {
        if (stage == 0) {
            FndxProcedure.resetColdEffects(player);
            return;
        }
        CompoundTag playerNBT = player.getPersistentData();
        float effectMultiplier = isNonLeatherArmor ? 2.0f : 1.0f;
        float moveSpeedReduceRatio = FndxProcedure.getMoveSpeedRatio(stage) * effectMultiplier;
        float finalMoveSpeed = Mth.m_14036_((float)(0.1f * (1.0f - moveSpeedReduceRatio)), (float)0.005f, (float)0.1f);
        player.m_21051_(Attributes.f_22279_).m_22100_((double)finalMoveSpeed);
        float miningSpeedReduceRatio = FndxProcedure.getMiningSpeedRatio(stage) * effectMultiplier;
        float finalMiningSpeed = Mth.m_14036_((float)(1.0f * (1.0f - miningSpeedReduceRatio)), (float)0.1f, (float)1.0f);
        player.m_21051_(Attributes.f_22283_).m_22100_((double)(finalMiningSpeed * 4.0f));
        long currentGameTick = level.m_46467_();
        long lastHurtTick = playerNBT.m_128454_(NBT_LAST_HURT_TICK);
        if (currentGameTick - lastHurtTick >= 200L) {
            float coldDamage = FndxProcedure.getColdDamage(stage) * effectMultiplier;
            player.m_6469_(level.m_269111_().m_269264_(), coldDamage);
            playerNBT.m_128356_(NBT_LAST_HURT_TICK, currentGameTick);
        }
    }

    private static int getColdStage(long stayTimeInTicks) {
        long stage1Trigger = TICK_6MIN;
        long stage2Trigger = TICK_6MIN + TICK_9MIN;
        long stage3Trigger = TICK_6MIN + TICK_9MIN + TICK_10MIN;
        if (stayTimeInTicks >= stage3Trigger) {
            return 3;
        }
        if (stayTimeInTicks >= stage2Trigger) {
            return 2;
        }
        if (stayTimeInTicks >= stage1Trigger) {
            return 1;
        }
        return 0;
    }

    private static float getMoveSpeedRatio(int stage) {
        return switch (stage) {
            case 1 -> 0.2f;
            case 2 -> 0.4f;
            case 3 -> 0.6f;
            default -> 0.0f;
        };
    }

    private static float getDamageReduceRatio(int stage, boolean isNonLeather) {
        float baseRatio = switch (stage) {
            case 1 -> 0.1f;
            case 2 -> 0.3f;
            case 3 -> 0.5f;
            default -> 0.0f;
        };
        return isNonLeather ? baseRatio * 2.0f : baseRatio;
    }

    private static float getMiningSpeedRatio(int stage) {
        return switch (stage) {
            case 1 -> 0.2f;
            case 2 -> 0.4f;
            case 3 -> 0.6f;
            default -> 0.0f;
        };
    }

    private static float getColdDamage(int stage) {
        return switch (stage) {
            case 1 -> 1.0f;
            case 2 -> 2.0f;
            case 3 -> 3.0f;
            default -> 0.0f;
        };
    }

    private static boolean isPlayerInSnowBiome(Player player, Level level) {
        Holder biomeHolder = level.m_204166_(player.m_20183_());
        ResourceLocation biomeId = biomeHolder.m_203543_().map(biomeKey -> biomeKey.m_135782_()).orElse(null);
        return biomeId != null && SNOW_BIOME_IDS.contains(biomeId.toString());
    }

    private static boolean isFullLeatherArmor(Player player) {
        return FndxProcedure.isLeatherEquipment(player.m_6844_(EquipmentSlot.HEAD)) && FndxProcedure.isLeatherEquipment(player.m_6844_(EquipmentSlot.CHEST)) && FndxProcedure.isLeatherEquipment(player.m_6844_(EquipmentSlot.LEGS)) && FndxProcedure.isLeatherEquipment(player.m_6844_(EquipmentSlot.FEET));
    }

    private static boolean hasNonLeatherArmor(Player player) {
        if (FndxProcedure.isFullLeatherArmor(player)) {
            return false;
        }
        return !FndxProcedure.isLeatherEquipment(player.m_6844_(EquipmentSlot.HEAD)) || !FndxProcedure.isLeatherEquipment(player.m_6844_(EquipmentSlot.CHEST)) || !FndxProcedure.isLeatherEquipment(player.m_6844_(EquipmentSlot.LEGS)) || !FndxProcedure.isLeatherEquipment(player.m_6844_(EquipmentSlot.FEET));
    }

    private static boolean isLeatherEquipment(ItemStack equipmentStack) {
        if (equipmentStack.m_41619_()) {
            return false;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)equipmentStack.m_41720_());
        return itemId != null && itemId.toString().startsWith("minecraft:leather_");
    }

    private static void resetColdEffects(Player player) {
        CompoundTag playerNBT = player.getPersistentData();
        player.m_21051_(Attributes.f_22279_).m_22100_((double)0.1f);
        player.m_21051_(Attributes.f_22283_).m_22100_(4.0);
        playerNBT.m_128405_(NBT_LAST_STAGE, 0);
    }

    private static void sendColdWarning(Player player) {
        String playerLanguage = "en_us";
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().m_91102_() != null) {
            playerLanguage = Minecraft.m_91087_().m_91102_().m_264236_();
        }
        String warningText = playerLanguage.equalsIgnoreCase("zh_cn") || playerLanguage.equalsIgnoreCase("zh") ? "\u8d76\u7d27\u7a7f\u8863\u670d\uff0c\u8981\u4e0d\u5c31\u51bb\u6b7b\u4e86\uff01" : "Put on clothes quickly, or you'll freeze to death!";
        player.m_213846_((Component)Component.m_237113_((String)warningText).m_130938_(style -> style.m_131148_(RED_COLOR)));
    }
}

