/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.elementallovesong.init.ElementallovesongModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GhProcedure {
    private static final double DETECTION_RANGE = 16.0;
    private static final TagKey<Item> ILLUSION_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("minecraft:illusions"));
    private static final int EXECUTE_INTERVAL = 20;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().m_5776_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && event.player.f_19797_ % 20 == 0) {
            try {
                GhProcedure.execute((Event)event, (LevelAccessor)event.player.m_9236_(), event.player.m_20185_(), event.player.m_20186_(), event.player.m_20189_(), (Entity)event.player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        GhProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        LivingEntity livingEntity;
        block6: {
            block5: {
                if (entity == null || !(entity instanceof LivingEntity)) break block5;
                livingEntity = (LivingEntity)entity;
                if (world != null) break block6;
            }
            return;
        }
        if (!entity.m_6084_() || entity.m_213877_()) {
            return;
        }
        if (GhProcedure.hasAnyIllusionArmor(livingEntity) || GhProcedure.hasIllusionItem(livingEntity)) {
            GhProcedure.clearIllusionerIllusions(world, x, y, z);
        }
    }

    private static boolean hasAnyIllusionArmor(LivingEntity entity) {
        if (ElementallovesongModItems.ILLUSION_ARMOR_HELMET == null || ElementallovesongModItems.ILLUSION_ARMOR_CHESTPLATE == null || ElementallovesongModItems.ILLUSION_ARMOR_LEGGINGS == null || ElementallovesongModItems.ILLUSION_ARMOR_BOOTS == null) {
            return false;
        }
        return GhProcedure.isEquipped(entity, EquipmentSlot.HEAD, (Item)ElementallovesongModItems.ILLUSION_ARMOR_HELMET.get()) || GhProcedure.isEquipped(entity, EquipmentSlot.CHEST, (Item)ElementallovesongModItems.ILLUSION_ARMOR_CHESTPLATE.get()) || GhProcedure.isEquipped(entity, EquipmentSlot.LEGS, (Item)ElementallovesongModItems.ILLUSION_ARMOR_LEGGINGS.get()) || GhProcedure.isEquipped(entity, EquipmentSlot.FEET, (Item)ElementallovesongModItems.ILLUSION_ARMOR_BOOTS.get());
    }

    private static boolean isEquipped(LivingEntity entity, EquipmentSlot slot, Item targetItem) {
        if (targetItem == null) {
            return false;
        }
        ItemStack stack = entity.m_6844_(slot);
        return !stack.m_41619_() && stack.m_41720_() == targetItem;
    }

    private static boolean hasIllusionItem(LivingEntity entity) {
        if (ILLUSION_TAG == null) {
            return false;
        }
        ItemStack mainHand = entity.m_21205_();
        ItemStack offHand = entity.m_21206_();
        return !mainHand.m_41619_() && mainHand.m_204117_(ILLUSION_TAG) || !offHand.m_41619_() && offHand.m_204117_(ILLUSION_TAG);
    }

    private static void clearIllusionerIllusions(LevelAccessor world, double x, double y, double z) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        try {
            double minX = Math.max(-3.0E7, x - 16.0);
            double minY = Math.max(0.0, y - 16.0);
            double minZ = Math.max(-3.0E7, z - 16.0);
            double maxX = Math.min(3.0E7, x + 16.0);
            double maxY = Math.min((double)world.m_151558_(), y + 16.0);
            double maxZ = Math.min(3.0E7, z + 16.0);
            List illusioners = serverLevel.m_45976_(Illusioner.class, new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            for (Illusioner illusion : illusioners) {
                if (illusion == null || !illusion.m_6084_() || illusion.m_213877_() || illusion.m_9236_() != serverLevel || !(Math.abs(illusion.m_21223_() - 0.5f) < 0.01f)) continue;
                illusion.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

