/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.elementallovesong.init.ElementallovesongModEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LightProcedure {
    private static final Map<UUID, Map<BlockPos, BlockState>> lightCache = new HashMap<UUID, Map<BlockPos, BlockState>>();
    private static final Map<UUID, Integer> durabilityTimer = new HashMap<UUID, Integer>();
    private static final int LIGHT_RANGE = 3;
    private static final int DURABILITY_INTERVAL = 800;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.m_6084_()) {
            Player player = event.player;
            Level world = player.m_9236_();
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            LightProcedure.execute(world, x, y, z, (Entity)player);
            LightProcedure.handleDurability((Entity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        UUID playerId = player.m_20148_();
        LightProcedure.restoreBlocks(player.m_9236_(), playerId);
        lightCache.remove(playerId);
        durabilityTimer.remove(playerId);
    }

    public static void execute(Level world, double x, double y, double z, Entity entity) {
        LightProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, Level world, double x, double y, double z, Entity entity) {
        if (entity == null || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        UUID entityId = entity.m_20148_();
        boolean hasEnchant = LightProcedure.hasMobileLightEnchant(living);
        LightProcedure.restoreBlocks(world, entityId);
        if (hasEnchant && !world.f_46443_) {
            int centerZ;
            int centerY;
            HashMap<BlockPos, BlockState> newLightPositions = new HashMap<BlockPos, BlockState>();
            int centerX = (int)Math.floor(x);
            BlockPos mainPos = new BlockPos(centerX, centerY = (int)Math.floor(y), centerZ = (int)Math.floor(z));
            if (world.m_46859_(mainPos)) {
                newLightPositions.put(mainPos, world.m_8055_(mainPos));
                world.m_7731_(mainPos, Blocks.f_152480_.m_49966_(), 3);
            }
            for (int dx = -3; dx <= 3; dx += 3) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -3; dz <= 3; dz += 3) {
                        BlockPos pos;
                        if (dx == 0 && dy == 0 && dz == 0 || !world.m_46859_(pos = new BlockPos(centerX + dx, centerY + dy, centerZ + dz))) continue;
                        newLightPositions.put(pos, world.m_8055_(pos));
                        world.m_7731_(pos, Blocks.f_152480_.m_49966_(), 3);
                    }
                }
            }
            lightCache.put(entityId, newLightPositions);
        } else {
            lightCache.remove(entityId);
        }
    }

    private static void restoreBlocks(Level world, UUID entityId) {
        if (lightCache.containsKey(entityId) && !world.f_46443_) {
            Map<BlockPos, BlockState> positions = lightCache.get(entityId);
            for (Map.Entry<BlockPos, BlockState> entry : positions.entrySet()) {
                BlockPos pos = entry.getKey();
                BlockState originalState = entry.getValue();
                if (world.m_8055_(pos).m_60734_() != Blocks.f_152480_) continue;
                world.m_7731_(pos, originalState, 3);
            }
        }
    }

    private static boolean hasMobileLightEnchant(LivingEntity entity) {
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.MOBILE_LIGHT_SOURCE.get()), (ItemStack)entity.m_21205_()) > 0) {
            return true;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.MOBILE_LIGHT_SOURCE.get()), (ItemStack)entity.m_21206_()) > 0) {
            return true;
        }
        for (ItemStack armor : entity.m_6168_()) {
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.MOBILE_LIGHT_SOURCE.get()), (ItemStack)armor) <= 0) continue;
            return true;
        }
        return false;
    }

    private static void handleDurability(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        UUID entityId = entity.m_20148_();
        durabilityTimer.putIfAbsent(entityId, 0);
        int currentTick = durabilityTimer.get(entityId) + 1;
        if (currentTick >= 800 && LightProcedure.hasMobileLightEnchant(living)) {
            LightProcedure.consumeDurability(living);
            durabilityTimer.put(entityId, 0);
        } else {
            durabilityTimer.put(entityId, currentTick);
        }
    }

    private static void consumeDurability(LivingEntity entity) {
        if (LightProcedure.tryConsumeDurability(entity.m_21205_())) {
            return;
        }
        if (LightProcedure.tryConsumeDurability(entity.m_21206_())) {
            return;
        }
        for (ItemStack armor : entity.m_6168_()) {
            if (!LightProcedure.tryConsumeDurability(armor)) continue;
            return;
        }
    }

    private static boolean tryConsumeDurability(ItemStack stack) {
        int damage;
        if (!stack.m_41619_() && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.MOBILE_LIGHT_SOURCE.get()), (ItemStack)stack) > 0 && (damage = stack.m_41773_()) < stack.m_41776_()) {
            stack.m_41721_(damage + 1);
            if (damage + 1 >= stack.m_41776_()) {
                stack.m_41764_(0);
            }
            return true;
        }
        return false;
    }
}

