/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.mcreator.elementallovesong.init.ElementallovesongModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ProvokevexsProcedure {
    private static final Map<UUID, List<Entity>> OWNER_TO_VEXES = new ConcurrentHashMap<UUID, List<Entity>>();
    private static final Map<UUID, Integer> COOLDOWN_TIMERS = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> IS_SPAWNING = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, UUID> VEX_TO_OWNER = new ConcurrentHashMap<UUID, UUID>();
    private static final Map<UUID, Integer> NON_PLAYER_DEATH_DELAY = new ConcurrentHashMap<UUID, Integer>();
    private static final int COOLDOWN_TICKS = 4800;
    private static final int MIN_VEX_COUNT = 10;
    private static final int MAX_VEX_COUNT = 20;
    private static final int SPAWN_RADIUS = 5;
    private static final int DELAY_AFTER_NON_PLAYER_DEATH = 100;

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity owner = event.getEntity();
        if (!owner.m_6084_() || owner.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)owner.m_9236_();
        UUID ownerId = owner.m_20148_();
        boolean hasBuff = owner.m_21023_((MobEffect)ElementallovesongModMobEffects.PROVOKE_VEX.get());
        ProvokevexsProcedure.updateNonPlayerDeathDelay(serverWorld);
        if (!hasBuff) {
            ProvokevexsProcedure.clearOwnerData(ownerId, serverWorld, false);
            return;
        }
        OWNER_TO_VEXES.putIfAbsent(ownerId, new ArrayList());
        IS_SPAWNING.putIfAbsent(ownerId, false);
        List<Entity> vexes = OWNER_TO_VEXES.get(ownerId);
        vexes.removeIf(vex -> !vex.m_6084_() || vex.m_9236_() != serverWorld || !(vex instanceof Mob));
        if (vexes.isEmpty() && COOLDOWN_TIMERS.getOrDefault(ownerId, 0) <= 0 && !IS_SPAWNING.get(ownerId).booleanValue()) {
            IS_SPAWNING.put(ownerId, true);
            ProvokevexsProcedure.spawnVexes(serverWorld, owner, ownerId);
            IS_SPAWNING.put(ownerId, false);
        }
        COOLDOWN_TIMERS.computeIfPresent(ownerId, (id, remaining) -> Math.max(0, remaining - 1));
    }

    private static void spawnVexes(ServerLevel world, LivingEntity owner, UUID ownerId) {
        RandomSource random = world.m_213780_();
        int spawnCount = 10 + random.m_188503_(11);
        List<Entity> vexes = OWNER_TO_VEXES.get(ownerId);
        vexes.forEach(vex -> VEX_TO_OWNER.remove(vex.m_20148_()));
        vexes.clear();
        for (int i = 0; i < spawnCount; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 2.0 * 5.0;
            double offsetY = random.m_188500_() * 3.0 - 1.0;
            double offsetZ = (random.m_188500_() - 0.5) * 2.0 * 5.0;
            BlockPos spawnPos = new BlockPos((int)Math.floor(owner.m_20185_() + offsetX), (int)Math.floor(owner.m_20186_() + offsetY), (int)Math.floor(owner.m_20189_() + offsetZ));
            Entity vex2 = EntityType.f_20491_.m_262496_(world, spawnPos, MobSpawnType.MOB_SUMMONED);
            if (!(vex2 instanceof Mob)) continue;
            Mob livingVex = (Mob)vex2;
            livingVex.m_146922_(random.m_188501_() * 360.0f);
            livingVex.m_6710_(owner);
            livingVex.m_21561_(true);
            livingVex.m_21530_();
            vexes.add((Entity)livingVex);
            VEX_TO_OWNER.put(livingVex.m_20148_(), ownerId);
        }
    }

    @SubscribeEvent
    public static void onVexDeath(LivingDeathEvent event) {
        LivingEntity deadVex = event.getEntity();
        if (deadVex.m_6095_() != EntityType.f_20491_ || deadVex.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)deadVex.m_9236_();
        UUID vexId = deadVex.m_20148_();
        UUID ownerId = VEX_TO_OWNER.get(vexId);
        if (ownerId == null || !OWNER_TO_VEXES.containsKey(ownerId)) {
            VEX_TO_OWNER.remove(vexId);
            return;
        }
        VEX_TO_OWNER.remove(vexId);
        List<Entity> ownerVexes = OWNER_TO_VEXES.get(ownerId);
        ownerVexes.remove(deadVex);
        boolean allVexesDead = ownerVexes.stream().noneMatch(vex -> vex.m_6084_() && vex instanceof Mob);
        if (allVexesDead) {
            ownerVexes.clear();
            COOLDOWN_TIMERS.put(ownerId, 4800);
        }
    }

    @SubscribeEvent
    public static void onNonPlayerDeath(LivingDeathEvent event) {
        LivingEntity deadEntity = event.getEntity();
        if (deadEntity instanceof Player || !deadEntity.m_21023_((MobEffect)ElementallovesongModMobEffects.PROVOKE_VEX.get()) || deadEntity.m_9236_().m_5776_()) {
            return;
        }
        UUID deadOwnerId = deadEntity.m_20148_();
        NON_PLAYER_DEATH_DELAY.put(deadOwnerId, 100);
    }

    private static void updateNonPlayerDeathDelay(ServerLevel world) {
        for (Map.Entry<UUID, Integer> entry : NON_PLAYER_DEATH_DELAY.entrySet()) {
            UUID deadOwnerId = entry.getKey();
            int remainingTicks = entry.getValue() - 1;
            if (remainingTicks <= 0) {
                ProvokevexsProcedure.clearOwnerData(deadOwnerId, world, true);
                NON_PLAYER_DEATH_DELAY.remove(deadOwnerId);
                continue;
            }
            NON_PLAYER_DEATH_DELAY.put(deadOwnerId, remainingTicks);
        }
    }

    private static void clearOwnerData(UUID ownerId, ServerLevel world, boolean forceKill) {
        if (OWNER_TO_VEXES.containsKey(ownerId)) {
            List<Entity> vexes = OWNER_TO_VEXES.get(ownerId);
            if (forceKill) {
                vexes.forEach(vex -> {
                    if (vex.m_6084_() && !vex.m_213877_() && vex.m_9236_() == world) {
                        vex.m_142687_(Entity.RemovalReason.KILLED);
                        VEX_TO_OWNER.remove(vex.m_20148_());
                    }
                });
            }
            vexes.clear();
            OWNER_TO_VEXES.remove(ownerId);
        }
        COOLDOWN_TIMERS.remove(ownerId);
        IS_SPAWNING.remove(ownerId);
        NON_PLAYER_DEATH_DELAY.remove(ownerId);
        VEX_TO_OWNER.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(ownerId));
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        ProvokevexsProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
    }
}

