/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import javax.annotation.Nullable;
import net.mcreator.elementallovesong.ElementallovesongMod;
import net.mcreator.elementallovesong.init.ElementallovesongModEnchantments;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SoaProcedure {
    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        DamageSource source;
        if (event != null && event.getEntity() != null && (source = event.getSource()).m_7640_() instanceof AbstractArrow && source.m_7639_() instanceof Player) {
            Player attacker = (Player)source.m_7639_();
            AbstractArrow originalArrow = (AbstractArrow)source.m_7640_();
            if (!originalArrow.m_20068_()) {
                SoaProcedure.execute((Event)event, attacker.m_9236_(), source, attacker, originalArrow);
            }
        }
    }

    public static void execute(Level world, DamageSource damagesource, Player attacker, AbstractArrow originalArrow) {
        SoaProcedure.execute(null, world, damagesource, attacker, originalArrow);
    }

    private static void execute(@Nullable Event event, Level world, DamageSource damagesource, Player attacker, AbstractArrow originalArrow) {
        if (attacker == null || originalArrow == null) {
            return;
        }
        int enchantLevel = SoaProcedure.getEnchantmentLevel(attacker);
        if (enchantLevel <= 0) {
            return;
        }
        int requiredArrows = enchantLevel * 5;
        if (SoaProcedure.countArrowsInInventory(attacker) < requiredArrows) {
            event.setCanceled(true);
            originalArrow.m_146870_();
            return;
        }
        SoaProcedure.consumeArrows(attacker, requiredArrows);
        originalArrow.m_20242_(true);
        SoaProcedure.handleMultipleArrows(world, attacker, enchantLevel, originalArrow);
    }

    private static int getEnchantmentLevel(Player player) {
        int mainHandLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.STRINGS_OF_ARROWS.get()), (ItemStack)player.m_21205_());
        int offHandLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.STRINGS_OF_ARROWS.get()), (ItemStack)player.m_21206_());
        return Math.max(mainHandLevel, offHandLevel);
    }

    private static int countArrowsInInventory(Player player) {
        int count = 0;
        NonNullList inventory = player.m_150109_().f_35974_;
        for (ItemStack stack : inventory) {
            if (stack.m_41720_() != Items.f_42412_) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private static void consumeArrows(Player player, int amount) {
        NonNullList inventory = player.m_150109_().f_35974_;
        int remaining = amount;
        for (int i = 0; i < inventory.size() && remaining > 0; ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.m_41720_() != Items.f_42412_) continue;
            int take = Math.min(stack.m_41613_(), remaining);
            stack.m_41774_(take);
            remaining -= take;
        }
    }

    private static void handleMultipleArrows(Level world, Player player, int enchantLevel, AbstractArrow originalArrow) {
        if (world.m_5776_()) {
            return;
        }
        int arrowCount = enchantLevel * 5;
        for (int i = 0; i < arrowCount; ++i) {
            float angleOffset = (float)((Math.random() * 6.0 - 3.0) * Math.PI / 180.0);
            ElementallovesongMod.queueServerWork(i * 2, () -> {
                if (player.m_6084_() && !world.m_5776_()) {
                    Arrow newArrow = new Arrow(EntityType.f_20548_, world);
                    newArrow.m_5602_((Entity)player);
                    newArrow.m_36781_(originalArrow.m_36789_());
                    newArrow.m_36735_(originalArrow.m_150123_());
                    newArrow.m_36767_(originalArrow.m_36796_());
                    newArrow.m_20242_(false);
                    newArrow.m_6034_(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
                    float lookX = (float)player.m_20154_().f_82479_;
                    float lookY = (float)player.m_20154_().f_82480_;
                    float lookZ = (float)player.m_20154_().f_82481_;
                    float offsetX = (float)((double)lookX * Math.cos(angleOffset) - (double)lookZ * Math.sin(angleOffset));
                    float offsetZ = (float)((double)lookX * Math.sin(angleOffset) + (double)lookZ * Math.cos(angleOffset));
                    newArrow.m_6686_((double)offsetX, (double)lookY, (double)offsetZ, 1.0f, 0.0f);
                    world.m_7967_((Entity)newArrow);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.4f + 1.2f));
                }
            });
        }
    }
}

