/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.elementallovesong.init.ElementallovesongModEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class SuicidProcedure {
    private static final Map<UUID, Integer> explosionTimer = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> enchantLevels = new HashMap<UUID, Integer>();
    private static final int EXPLOSION_DELAY = 20;

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            int enchantLevel;
            Player player = (Player)entity;
            if (entity.m_6084_() && (enchantLevel = SuicidProcedure.getEnchantmentLevel((LivingEntity)player)) > 0 && !explosionTimer.containsKey(player.m_20148_())) {
                explosionTimer.put(player.m_20148_(), 20);
                enchantLevels.put(player.m_20148_(), enchantLevel);
                SuicidProcedure.playCreeperSound(player.m_9236_(), player);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        HashMap<UUID, Integer> timerCopy = new HashMap<UUID, Integer>(explosionTimer);
        for (Map.Entry entry : timerCopy.entrySet()) {
            UUID playerUUID = (UUID)entry.getKey();
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerUUID);
            if (player == null || !player.m_6084_()) {
                explosionTimer.remove(playerUUID);
                enchantLevels.remove(playerUUID);
                continue;
            }
            Level world = player.m_9236_();
            int remainingTicks = (Integer)entry.getValue() - 1;
            if (remainingTicks <= 0) {
                SuicidProcedure.triggerExplosion(world, (Player)player, enchantLevels.get(playerUUID));
                explosionTimer.remove(playerUUID);
                enchantLevels.remove(playerUUID);
                continue;
            }
            explosionTimer.put(playerUUID, remainingTicks);
            if (remainingTicks > 5) continue;
            SuicidProcedure.playCreeperSound(world, (Player)player);
        }
    }

    private static void playCreeperSound(Level world, Player player) {
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_11837_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    private static void triggerExplosion(Level world, Player player, int level) {
        if (world.m_5776_()) {
            return;
        }
        float explosionRadius = Math.min((float)(3 + (level - 1) * 2), 10.0f);
        world.m_254849_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), explosionRadius, Level.ExplosionInteraction.NONE);
        Holder.Reference damageTypeHolder = world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268464_);
        DamageSource damageSource = new DamageSource((Holder)damageTypeHolder, (Entity)player);
        player.m_6469_(damageSource, 200.0f);
        if (player.m_6084_()) {
            player.m_6074_();
        }
    }

    private static int getEnchantmentLevel(LivingEntity entity) {
        int maxLevel = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack stack = entity.m_6844_(slot);
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.SUICIDE_BOMBING.get()), (ItemStack)stack);
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        return maxLevel;
    }
}

