/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import javax.annotation.Nullable;
import net.mcreator.elementallovesong.init.ElementallovesongModEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SummonFangProcedure {
    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            SummonFangProcedure.execute((Event)event, (LevelAccessor)target.m_9236_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), attacker);
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, LivingEntity attacker) {
        SummonFangProcedure.execute(null, world, x, y, z, attacker);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, LivingEntity attacker) {
        if (attacker == null) {
            return;
        }
        int enchantLevel = SummonFangProcedure.getEnchantmentLevel(attacker);
        if (enchantLevel <= 0) {
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            int fangCount = Mth.m_14045_((int)(5 + (enchantLevel - 1) * 2), (int)5, (int)12);
            float startAngle = attacker.m_146908_() - 30.0f;
            float angleStep = 60.0f / (float)(fangCount - 1);
            for (int i = 0; i < fangCount; ++i) {
                double spawnZ;
                float currentAngle = startAngle + (float)i * angleStep;
                float radians = (float)Math.toRadians(currentAngle);
                double offset = 0.3 + (double)i * 0.2 / (double)fangCount;
                double spawnX = x + Math.cos(radians) * offset;
                BlockPos spawnPos = BlockPos.m_274561_((double)spawnX, (double)y, (double)(spawnZ = z + Math.sin(radians) * offset));
                Entity fang = EntityType.f_20569_.m_262496_(serverLevel, spawnPos, MobSpawnType.MOB_SUMMONED);
                if (fang == null) continue;
                fang.m_146922_(currentAngle);
            }
        }
    }

    private static int getEnchantmentLevel(LivingEntity entity) {
        int mainLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.SUMMON_FANGS.get()), (ItemStack)entity.m_21205_());
        int offLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.SUMMON_FANGS.get()), (ItemStack)entity.m_21206_());
        return Math.max(mainLevel, offLevel);
    }
}

