/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class VProcedure {
    private static final List<Item> ENCHANTABLE_ITEMS = List.of(Items.f_42740_, Items.f_42409_);
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        if (level.m_5776_() || player == null || !player.m_6084_()) {
            return;
        }
        ItemStack heldStack = player.m_21205_();
        if (!ENCHANTABLE_ITEMS.contains(heldStack.m_41720_())) {
            return;
        }
        Block clickedBlock = level.m_8055_(event.getPos()).m_60734_();
        String blockId = ForgeRegistries.BLOCKS.getKey((Object)clickedBlock).m_135815_();
        if (!blockId.equals("enchanting_table")) {
            return;
        }
        VProcedure.applyEnchantToItem(heldStack, player);
    }

    private static void applyEnchantToItem(ItemStack stack, Player player) {
        Item item = stack.m_41720_();
        ArrayList<Enchantment> compatibleEnchants = new ArrayList<Enchantment>();
        for (Enchantment enchant : ForgeRegistries.ENCHANTMENTS) {
            if (enchant == null || !enchant.m_6081_(stack)) continue;
            Map existingEnchants = EnchantmentHelper.m_44831_((ItemStack)stack);
            boolean isConflict = false;
            for (Enchantment existing : existingEnchants.keySet()) {
                if (existing.m_44695_(enchant)) continue;
                isConflict = true;
                break;
            }
            if (isConflict) continue;
            String enchantId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant).m_135815_();
            if (item == Items.f_42409_ && enchantId.equals("binding_curse") || item == Items.f_42740_ && VProcedure.isWeaponEnchant(enchantId)) continue;
            compatibleEnchants.add(enchant);
        }
        if (compatibleEnchants.isEmpty()) {
            VProcedure.sendMessage(player, "\u8be5\u7269\u54c1\u6ca1\u6709\u53ef\u517c\u5bb9\u7684\u9644\u9b54\uff01");
            return;
        }
        Enchantment selectedEnchant = (Enchantment)compatibleEnchants.get(RANDOM.nextInt(compatibleEnchants.size()));
        int maxLevel = selectedEnchant.m_6586_();
        int enchantLevel = RANDOM.nextInt(maxLevel) + 1;
        EnchantmentHelper.m_44865_(Map.of(selectedEnchant, enchantLevel), (ItemStack)stack);
        String enchantName = ForgeRegistries.ENCHANTMENTS.getKey((Object)selectedEnchant).m_135815_();
        VProcedure.sendMessage(player, "\u6210\u529f\u4e3a\u300c" + item.m_7626_(stack).getString() + "\u300d\u9644\u9b54\uff1a" + VProcedure.formatEnchantName(enchantName) + enchantLevel + " \u7ea7 ");
    }

    private static boolean isWeaponEnchant(String enchantId) {
        List<String> weaponEnchantIds = List.of("sharpness", "smite", "bane_of_arthropods", "knockback", "fire_aspect", "looting");
        return weaponEnchantIds.contains(enchantId.toLowerCase());
    }

    private static String formatEnchantName(String enchantId) {
        switch (enchantId.toLowerCase()) {
            case "unbreaking": {
                return "\u8010\u4e45";
            }
            case "mending": {
                return "\u7ecf\u9a8c\u4fee\u8865";
            }
            case "binding_curse": {
                return "\u7ed1\u5b9a\u8bc5\u5492";
            }
            case "sharpness": {
                return "\u950b\u5229";
            }
            case "smite": {
                return "\u4ea1\u7075\u6740\u624b";
            }
            case "bane_of_arthropods": {
                return "\u8282\u80a2\u6740\u624b";
            }
            case "knockback": {
                return "\u51fb\u9000";
            }
            case "fire_aspect": {
                return "\u706b\u7130\u9644\u52a0";
            }
            case "looting": {
                return "\u63a0\u593a";
            }
        }
        return enchantId.replace("_", " ");
    }

    private static void sendMessage(Player player, String message) {
        player.m_213846_((Component)Component.m_237113_((String)("[\u9644\u9b54\u53f0]" + message)));
    }
}

