/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import java.util.List;
import java.util.UUID;
import net.mcreator.elementallovesong.init.ElementallovesongModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VdzProcedure {
    private static final UUID ATTACKED_ILLAGER_FLAG = UUID.fromString("8a8c7d8e-7b6a-4f5e-8d7c-6b5a4e3d2c1b");
    private static final String ILLAGER_BANNER_TAG = "BlockEntityTag";
    private static final String ILLAGER_BANNER_PATTERNS = "Patterns";
    private static final int TICK_INTERVAL = 20;
    private static final ResourceLocation OMINOUS_TAG_LOC = new ResourceLocation("minecraft:ominous");
    private static final TagKey<Item> OMINOUS_ITEM_TAG = ItemTags.create((ResourceLocation)OMINOUS_TAG_LOC);

    public static void execute(Entity entity) {
        if (entity == null) {
            return;
        }
        ItemStack illagerBanner = VdzProcedure.createIllagerCaptainBanner();
        try {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_150109_().f_35975_.set(3, (Object)illagerBanner);
                player.m_150109_().m_6596_();
            } else if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_8061_(EquipmentSlot.HEAD, illagerBanner);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ItemStack createIllagerCaptainBanner() {
        ItemStack banner = new ItemStack((ItemLike)Items.f_42660_);
        CompoundTag rootTag = new CompoundTag();
        CompoundTag blockEntityTag = new CompoundTag();
        ListTag patterns = new ListTag();
        CompoundTag pattern1 = new CompoundTag();
        pattern1.m_128359_("Pattern", "bo");
        pattern1.m_128405_("Color", 4);
        patterns.add((Object)pattern1);
        CompoundTag pattern2 = new CompoundTag();
        pattern2.m_128359_("Pattern", "mc");
        pattern2.m_128405_("Color", 4);
        patterns.add((Object)pattern2);
        CompoundTag pattern3 = new CompoundTag();
        pattern3.m_128359_("Pattern", "hh");
        pattern3.m_128405_("Color", 4);
        patterns.add((Object)pattern3);
        blockEntityTag.m_128365_(ILLAGER_BANNER_PATTERNS, (Tag)patterns);
        rootTag.m_128365_(ILLAGER_BANNER_TAG, (Tag)blockEntityTag);
        banner.m_41751_(rootTag);
        return banner;
    }

    private static boolean hasOminousEquipmentOrItem(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (ElementallovesongModItems.OMINOUS_ARMOR_BOOTS == null || ElementallovesongModItems.OMINOUS_ARMOR_HELMET == null || ElementallovesongModItems.OMINOUS_ARMOR_CHESTPLATE == null || ElementallovesongModItems.OMINOUS_ARMOR_LEGGINGS == null) {
            return false;
        }
        boolean hasOminousArmor = VdzProcedure.isArmorEquipped(livingEntity, EquipmentSlot.HEAD, (Item)ElementallovesongModItems.OMINOUS_ARMOR_HELMET.get()) || VdzProcedure.isArmorEquipped(livingEntity, EquipmentSlot.CHEST, (Item)ElementallovesongModItems.OMINOUS_ARMOR_CHESTPLATE.get()) || VdzProcedure.isArmorEquipped(livingEntity, EquipmentSlot.LEGS, (Item)ElementallovesongModItems.OMINOUS_ARMOR_LEGGINGS.get()) || VdzProcedure.isArmorEquipped(livingEntity, EquipmentSlot.FEET, (Item)ElementallovesongModItems.OMINOUS_ARMOR_BOOTS.get());
        boolean hasOminousItem = !livingEntity.m_21205_().m_41619_() && livingEntity.m_21205_().m_204117_(OMINOUS_ITEM_TAG) || !livingEntity.m_21206_().m_41619_() && livingEntity.m_21206_().m_204117_(OMINOUS_ITEM_TAG);
        return hasOminousArmor || hasOminousItem;
    }

    private static boolean isArmorEquipped(LivingEntity entity, EquipmentSlot slot, Item targetArmor) {
        if (targetArmor == null) {
            return false;
        }
        ItemStack armorStack = entity.m_6844_(slot);
        return !armorStack.m_41619_() && armorStack.m_41720_() == targetArmor;
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Player player;
        block5: {
            block4: {
                LivingEntity target = event.getEntity();
                Entity source = event.getSource().m_7639_();
                if (target == null || source == null || !(target instanceof Player)) break block4;
                player = (Player)target;
                if (VdzProcedure.isIllager(source) && player.m_6084_() && !player.m_213877_()) break block5;
            }
            return;
        }
        if (VdzProcedure.hasOminousEquipmentOrItem((Entity)player) && !player.getPersistentData().m_128471_(ATTACKED_ILLAGER_FLAG.toString())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingAttackEvent event) {
        Player player;
        LivingEntity target;
        block8: {
            block7: {
                Entity source = event.getSource().m_7639_();
                target = event.getEntity();
                if (!(source instanceof Player)) break block7;
                player = (Player)source;
                if (target != null && !target.m_9236_().f_46443_) break block8;
            }
            return;
        }
        if (VdzProcedure.hasOminousEquipmentOrItem((Entity)player)) {
            if (VdzProcedure.isIllager((Entity)target)) {
                player.getPersistentData().m_128379_(ATTACKED_ILLAGER_FLAG.toString(), true);
                VdzProcedure.alertIllagers(target.m_9236_(), (LivingEntity)player, target.m_20183_(), 16);
            } else if (!(target instanceof Player)) {
                VdzProcedure.alertIllagers(target.m_9236_(), target, target.m_20183_(), 16);
            }
        }
    }

    private static void alertIllagers(Level world, LivingEntity target, BlockPos pos, int range) {
        ServerLevel serverWorld;
        block4: {
            block3: {
                if (!(world instanceof ServerLevel)) break block3;
                serverWorld = (ServerLevel)world;
                if (target != null && target.m_6084_()) break block4;
            }
            return;
        }
        List illagers = serverWorld.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26883_((double)range), target, target.m_20191_().m_82400_((double)range));
        for (LivingEntity illager : illagers) {
            if (!VdzProcedure.isIllager((Entity)illager) || !(illager instanceof Mob)) continue;
            Mob mob = (Mob)illager;
            if (!illager.m_6084_() || illager.m_213877_()) continue;
            mob.m_6710_(target);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level world = player.m_9236_();
        if (event.phase != TickEvent.Phase.END || world.f_46443_ || player.f_19797_ % 20 != 0 || !VdzProcedure.hasOminousEquipmentOrItem((Entity)player) || !player.m_6084_() || player.m_213877_()) {
            return;
        }
        List golems = world.m_45971_(IronGolem.class, TargetingConditions.m_148352_().m_26883_(16.0), (LivingEntity)player, player.m_20191_().m_82400_(16.0));
        for (IronGolem golem : golems) {
            if (!golem.m_6084_() || golem.m_213877_() || golem.m_5448_() != null && golem.m_5448_().equals((Object)player)) continue;
            golem.m_6710_((LivingEntity)player);
        }
    }

    @SubscribeEvent
    public static void onVillagerInteract(PlayerInteractEvent.EntityInteract event) {
        Villager villager;
        Player player;
        block6: {
            block5: {
                Entity target = event.getTarget();
                player = event.getEntity();
                if (target == null || !(target instanceof Villager)) break block5;
                villager = (Villager)target;
                if (player != null && VdzProcedure.hasOminousEquipmentOrItem((Entity)player) && villager.m_6084_() && !villager.m_213877_()) break block6;
            }
            return;
        }
        event.setCanceled(true);
        if (villager.m_5448_() == null || !villager.m_5448_().equals((Object)player)) {
            villager.m_6710_((LivingEntity)player);
            if (villager.m_21051_(Attributes.f_22279_) != null) {
                villager.m_21051_(Attributes.f_22279_).m_22100_(0.35);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickReset(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player == null || event.player.m_213877_()) {
            return;
        }
        if (event.player.f_19797_ % 600 == 0) {
            event.player.getPersistentData().m_128379_(ATTACKED_ILLAGER_FLAG.toString(), false);
        }
    }

    private static boolean isIllager(Entity entity) {
        if (entity == null || entity.m_6095_() == null) {
            return false;
        }
        String entityType = entity.m_6095_().toString();
        return entityType.contains("pillager") || entityType.contains("vindicator") || entityType.contains("evoker") || entityType.contains("illusioner");
    }
}

