/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.elementallovesong.procedures;

import javax.annotation.Nullable;
import net.mcreator.elementallovesong.ElementallovesongMod;
import net.mcreator.elementallovesong.init.ElementallovesongModEnchantments;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ZglcProcedure {
    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            entity = source.m_7639_();
            if (entity instanceof Player) {
                Player attacker = (Player)entity;
                if (!arrow.m_20068_()) {
                    ZglcProcedure.execute((Event)event, attacker.m_9236_(), source, attacker, arrow);
                }
            }
        }
    }

    public static void execute(Level world, DamageSource damagesource, Player attacker, AbstractArrow originalArrow) {
        ZglcProcedure.execute(null, world, damagesource, attacker, originalArrow);
    }

    private static void execute(@Nullable Event event, Level world, DamageSource damagesource, Player attacker, AbstractArrow originalArrow) {
        if (attacker == null || originalArrow == null) {
            return;
        }
        int enchantLevel = ZglcProcedure.getEnchantmentLevel(attacker);
        if (enchantLevel <= 0) {
            return;
        }
        int requiredArrows = enchantLevel * 5;
        if (ZglcProcedure.countArrowsInInventory(attacker) < requiredArrows) {
            event.setCanceled(true);
            originalArrow.m_146870_();
            return;
        }
        ZglcProcedure.consumeArrows(attacker, requiredArrows);
        originalArrow.m_20242_(true);
        ZglcProcedure.spawnMultipleArrows(world, attacker, enchantLevel, originalArrow);
    }

    private static int getEnchantmentLevel(Player player) {
        int mainHandLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.ZHUGE_LIANGS_CROSSBOW.get()), (ItemStack)player.m_21205_());
        int offHandLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ElementallovesongModEnchantments.ZHUGE_LIANGS_CROSSBOW.get()), (ItemStack)player.m_21206_());
        return Math.max(mainHandLevel, offHandLevel);
    }

    private static int countArrowsInInventory(Player player) {
        int total = 0;
        NonNullList inventory = player.m_150109_().f_35974_;
        for (ItemStack stack : inventory) {
            if (stack.m_41720_() != Items.f_42412_) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    private static void consumeArrows(Player player, int amount) {
        NonNullList inventory = player.m_150109_().f_35974_;
        int remaining = amount;
        for (ItemStack stack : inventory) {
            if (remaining <= 0) break;
            if (stack.m_41720_() != Items.f_42412_) continue;
            int take = Math.min(stack.m_41613_(), remaining);
            stack.m_41774_(take);
            remaining -= take;
        }
    }

    private static void spawnMultipleArrows(Level world, Player shooter, int enchantLevel, AbstractArrow originalArrow) {
        if (world.m_5776_()) {
            return;
        }
        int arrowCount = enchantLevel * 5;
        for (int i = 0; i < arrowCount; ++i) {
            float angleOffset = (float)((Math.random() * 4.0 - 2.0) * Math.PI / 180.0);
            ElementallovesongMod.queueServerWork(i * 2, () -> {
                if (!shooter.m_6084_()) {
                    return;
                }
                Arrow newArrow = new Arrow(EntityType.f_20548_, world);
                newArrow.m_5602_((Entity)shooter);
                newArrow.m_36781_(originalArrow.m_36789_());
                newArrow.m_36735_(originalArrow.m_150123_());
                newArrow.m_36767_(originalArrow.m_36796_());
                newArrow.m_20242_(false);
                newArrow.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
                float lookX = (float)shooter.m_20154_().f_82479_;
                float lookY = (float)shooter.m_20154_().f_82480_;
                float lookZ = (float)shooter.m_20154_().f_82481_;
                float offsetX = (float)((double)lookX * Math.cos(angleOffset) - (double)lookZ * Math.sin(angleOffset));
                float offsetZ = (float)((double)lookX * Math.sin(angleOffset) + (double)lookZ * Math.cos(angleOffset));
                newArrow.m_6686_((double)offsetX, (double)lookY, (double)offsetZ, 1.0f, 0.0f);
                world.m_7967_((Entity)newArrow);
                world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.4f + 1.2f));
            });
        }
    }
}

