# Collects the player's item
data modify storage earm:item elytra merge from entity @s equipment.offhand
# Store the current item in the custom data of the new item
data modify storage earm:item elytra.components."minecraft:custom_data".armor_item set from entity @s equipment.offhand

# Creates storage
data modify storage earm:item elytra merge value {id:"minecraft:elytra",count:1,components:{"minecraft:equippable":{slot:"chest",swappable:true,asset_id:"minecraft:elytra"},"minecraft:custom_data":{chestplate:1},"minecraft:max_stack_size":1}}

# Applies the profile of the elytra item to the storage
execute as @e[tag=earm.entity_interaction] on vehicle run tag @s add earm.temp
data modify storage earm:item elytra.components."minecraft:profile" set from entity @e[tag=earm.temp,limit=1] Item.components."minecraft:profile"
tag @e[tag=earm.temp] remove earm.temp

# Modifies armor amounts based on armor
execute if items entity @s weapon.offhand leather_chestplate run data modify storage earm:item elytra.components."minecraft:attribute_modifiers" set value [{id:"armor",type:"armor",amount:3,operation:"add_value",slot:"chest"},{id:"block_interaction_range",type:"block_interaction_range",amount:-6,operation:"add_value",slot:"hand",display:{type:"hidden"}}]
execute if items entity @s weapon.offhand chainmail_chestplate run data modify storage earm:item elytra.components."minecraft:attribute_modifiers" set value [{id:"armor",type:"armor",amount:5,operation:"add_value",slot:"chest"},{id:"block_interaction_range",type:"block_interaction_range",amount:-6,operation:"add_value",slot:"hand",display:{type:"hidden"}}]
execute if items entity @s weapon.offhand golden_chestplate run data modify storage earm:item elytra.components."minecraft:attribute_modifiers" set value [{id:"armor",type:"armor",amount:5,operation:"add_value",slot:"chest"},{id:"block_interaction_range",type:"block_interaction_range",amount:-6,operation:"add_value",slot:"hand",display:{type:"hidden"}}]
execute if items entity @s weapon.offhand iron_chestplate run data modify storage earm:item elytra.components."minecraft:attribute_modifiers" set value [{id:"armor",type:"armor",amount:6,operation:"add_value",slot:"chest"},{id:"block_interaction_range",type:"block_interaction_range",amount:-6,operation:"add_value",slot:"hand",display:{type:"hidden"}}]
execute if items entity @s weapon.offhand diamond_chestplate run data modify storage earm:item elytra.components."minecraft:attribute_modifiers" set value [{id:"armor",type:"armor",amount:8,operation:"add_value",slot:"chest"},{id:"armor_1",type:"armor_toughness",amount:2,operation:"add_value",slot:"chest"},{id:"block_interaction_range",type:"block_interaction_range",amount:-6,operation:"add_value",slot:"hand",display:{type:"hidden"}}]
execute if items entity @s weapon.offhand netherite_chestplate run data modify storage earm:item elytra.components."minecraft:attribute_modifiers" set value [{id:"armor",type:"armor",amount:8,operation:"add_value",slot:"chest"},{id:"armor_1",type:"armor_toughness",amount:3,operation:"add_value",slot:"chest"},{id:"armor_2",type:"knockback_resistance",amount:0.1,operation:"add_value",slot:"chest"},{id:"block_interaction_range",type:"block_interaction_range",amount:-6,operation:"add_value",slot:"hand",display:{type:"hidden"}}]

# Applies custom name, assuming no current custom name
execute if items entity @s weapon.offhand leather_chestplate run data modify storage earm:item elytra.components."minecraft:custom_name" set value [{translate:"item.minecraft.leather_chestplate",italic:false},{text:" "},{translate:"item.minecraft.elytra",italic:false}]
execute if items entity @s weapon.offhand chainmail_chestplate run data modify storage earm:item elytra.components."minecraft:custom_name" set value [{translate:"item.minecraft.chainmail_chestplate",italic:false},{text:" "},{translate:"item.minecraft.elytra",italic:false}]
execute if items entity @s weapon.offhand golden_chestplate run data modify storage earm:item elytra.components."minecraft:custom_name" set value [{translate:"item.minecraft.golden_chestplate",italic:false},{text:" "},{translate:"item.minecraft.elytra",italic:false}]
execute if items entity @s weapon.offhand iron_chestplate run data modify storage earm:item elytra.components."minecraft:custom_name" set value [{translate:"item.minecraft.iron_chestplate",italic:false},{text:" "},{translate:"item.minecraft.elytra",italic:false}]
execute if items entity @s weapon.offhand diamond_chestplate run data modify storage earm:item elytra.components."minecraft:custom_name" set value [{translate:"item.minecraft.diamond_chestplate",italic:false},{text:" "},{translate:"item.minecraft.elytra",italic:false}]
execute if items entity @s weapon.offhand netherite_chestplate run data modify storage earm:item elytra.components."minecraft:custom_name" set value [{translate:"item.minecraft.netherite_chestplate",italic:false},{text:" "},{translate:"item.minecraft.elytra",italic:false}]

# Max durability
execute if items entity @s weapon.offhand leather_chestplate run data modify storage earm:item elytra.components."minecraft:max_damage" set value 80
execute if items entity @s weapon.offhand chainmail_chestplate run data modify storage earm:item elytra.components."minecraft:max_damage" set value 240
execute if items entity @s weapon.offhand golden_chestplate run data modify storage earm:item elytra.components."minecraft:max_damage" set value 112
execute if items entity @s weapon.offhand iron_chestplate run data modify storage earm:item elytra.components."minecraft:max_damage" set value 240
execute if items entity @s weapon.offhand diamond_chestplate run data modify storage earm:item elytra.components."minecraft:max_damage" set value 528
execute if items entity @s weapon.offhand netherite_chestplate run data modify storage earm:item elytra.components."minecraft:max_damage" set value 592

# Apply custom name if exists
execute if data entity @s equipment.offhand.components."minecraft:custom_name" run data modify storage earm:item elytra.components."minecraft:custom_name" set from entity @s equipment.offhand.components."minecraft:custom_name"

# Set Item Rarity
data modify storage earm:item elytra.components."minecraft:rarity" set value "epic"

# Creates the item
setblock 0 0 0 air
setblock 0 0 0 chest{Items:[{Slot:0,id:"minecraft:stone",count:1}]}
data modify block 0 0 0 Items[0] set from storage earm:item elytra
# Replace the player's item
item replace entity @s weapon.offhand from block 0 0 0 container.0
# Remove the chest
setblock 0 0 0 air

# Reset storage
data remove storage earm:item elytra

# Fanfare
execute at @s run playsound minecraft:block.anvil.use player @a ~ ~ ~ 1 2