/*
 * Decompiled with CFR 0.152.
 */
package dev.andante.noclip.api.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.andante.noclip.api.client.NoClipClient;
import dev.andante.noclip.api.client.config.NoClipConfig;
import dev.andante.noclip.api.client.keybinding.NoClipKeyBindings;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public interface NoClipClientCommand {
    public static final String CONFIG_RELOAD_KEY = "text.noclip.config_reload_successful";
    public static final SimpleCommandExceptionType CONFIG_SYNTAX_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.noclip.config_reload_syntax_error"));
    public static final SimpleCommandExceptionType TOGGLE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.noclip.not_toggle_error"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"noclip").executes(NoClipClientCommand::execute)).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").executes(NoClipClientCommand::executeConfig)).then(ClientCommandManager.literal((String)"reload").executes(NoClipClientCommand::executeConfigReload))));
    }

    public static int execute(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        if (!NoClipClient.getConfig().keyBehaviors.noClip.toggles()) {
            throw TOGGLE_EXCEPTION.create();
        }
        NoClipKeyBindings.ACTIVATE_NOCLIP.method_23481(true);
        return NoClipKeyBindings.ACTIVATE_NOCLIP.method_1434() ? 1 : 0;
    }

    public static int executeConfig(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_310 client = source.getClient();
        client.method_63588(() -> client.method_1507(NoClipConfig.createScreen(client.field_1755)));
        return 1;
    }

    public static int executeConfigReload(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        if (!AutoConfig.getConfigHolder(NoClipConfig.class).load()) {
            throw CONFIG_SYNTAX_EXCEPTION.create();
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)CONFIG_RELOAD_KEY).method_10862(NoClipClient.getTextStyle()));
        return 1;
    }
}

