/*
 * Decompiled with CFR 0.152.
 */
package dev.andante.noclip.api.client.config;

import dev.andante.noclip.api.client.NoClipClient;
import dev.andante.noclip.api.client.config.KeyBehavior;
import dev.andante.noclip.impl.client.keybinding.NoClipKeyBindingsImpl;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_124;
import net.minecraft.class_437;

@Config.Gui.Background(value="cloth-config2:transparent")
@Config(name="noclip")
@Environment(value=EnvType.CLIENT)
public class NoClipConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public Display display = new Display();
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public Flight flight = new Flight();
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public KeyBehaviors keyBehaviors = new KeyBehaviors();
    @Comment(value="Allow Noclip In")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public AllowIn allowIn = new AllowIn();

    public static ConfigHolder<NoClipConfig> initialize() {
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((server, manager) -> NoClipClient.CONFIG.load());
        ConfigHolder config = AutoConfig.register(NoClipConfig.class, JanksonConfigSerializer::new);
        config.registerSaveListener(NoClipKeyBindingsImpl::onConfigSave);
        return config;
    }

    public static class_437 createScreen(class_437 parent) {
        return (class_437)AutoConfig.getConfigScreen(NoClipConfig.class, (class_437)parent).get();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Display {
        @Comment(value="Whether or not the icon displayed at the top-right of the HUD is present")
        @ConfigEntry.Gui.Tooltip(count=2)
        public boolean hudIcon = false;
        @Comment(value="Whether or not to display speed updates on the action bar (above the hot bar)")
        @ConfigEntry.Gui.Tooltip(count=2)
        public boolean showSpeedUpdatesOnActionBar = true;
        @Comment(value="The color of text displayed by the mod")
        @ConfigEntry.ColorPicker
        @ConfigEntry.Gui.Excluded
        public int textColor = class_124.field_1080.method_532();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Flight {
        @Comment(value="Bedrock-like snappy flight movement")
        @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
        @ConfigEntry.Gui.Tooltip
        public SnappyFlight snappyFlight = new SnappyFlight();
        @Comment(value="The ability to scroll in non-spectator game modes to change your flight speed")
        @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
        @ConfigEntry.Gui.Tooltip(count=2)
        public SpeedScrolling speedScrolling = new SpeedScrolling();
        @Comment(value="Whether to enable flight when entering noclip mode")
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.Gui.Excluded
        public boolean enableFlightOnClip = true;
        @Comment(value="Whether the player is locked flying when in noclip mode")
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.Gui.Excluded
        public boolean flyingLocked = true;

        @Environment(value=EnvType.CLIENT)
        public static final class SnappyFlight {
            public boolean enabled = false;
            @Comment(value="Whether snappy flight is only active when the player is in noclip")
            @ConfigEntry.Gui.Tooltip(count=2)
            public boolean onlyInNoClip = true;
        }

        @Environment(value=EnvType.CLIENT)
        public static final class SpeedScrolling {
            @Comment(value="The maximum value the flight speed scroll can be set to")
            @ConfigEntry.Gui.Tooltip(count=2)
            @ConfigEntry.BoundedDiscrete(min=4L, max=0x7FFFFFFFFFFFFFFFL)
            public float maxSpeed = 4.0f;
            @Comment(value="Whether or not to reset the flight speed scroll when disabling noclip mode or coming out of flight, depending on the only in noclip option")
            @ConfigEntry.Gui.Tooltip(count=3)
            public boolean resetSpeedOnClipOrFlight = true;
            @Comment(value="Whether speed scrolling is only allowed when the player is in noclip")
            @ConfigEntry.Gui.Tooltip(count=2)
            public boolean onlyInNoClip = true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class KeyBehaviors {
        @Comment(value="The behavior of the key binding to noclip")
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public KeyBehavior noClip = KeyBehavior.TOGGLE;
        @Comment(value="The behavior of the key binding to activate flight speed scrolling")
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public KeyBehavior flightSpeedActivation = KeyBehavior.HOLD;
    }

    @Environment(value=EnvType.CLIENT)
    public static class AllowIn {
        public boolean survival = true;
        public boolean creative = true;
        public boolean adventure = true;
        public boolean spectator = true;
    }
}

