/*
 * Decompiled with CFR 0.152.
 */
package dev.andante.noclip.impl;

import dev.andante.noclip.api.NoClip;
import dev.andante.noclip.impl.ClippingEntity;
import dev.andante.noclip.impl.ClippingUpdatePacket;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public final class NoClipImpl
implements NoClip,
ModInitializer {
    public void onInitialize() {
        LOGGER.info("Initializing {}", (Object)"noclip");
        PayloadTypeRegistry.playC2S().register(ClippingUpdatePacket.ID, ClippingUpdatePacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ClippingUpdatePacket.ID, ClippingUpdatePacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ClippingUpdatePacket.ID, this::receiveUpdate);
        ServerPlayConnectionEvents.JOIN.register(this::onPlayerJoin);
        ServerPlayerEvents.COPY_FROM.register(this::copyFrom);
        ServerPlayerEvents.AFTER_RESPAWN.register(this::afterRespawn);
    }

    private void onPlayerJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        ClippingEntity clippingPlayer = ClippingEntity.cast((class_1657)handler.field_14140);
        ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new ClippingUpdatePacket(clippingPlayer.isClipping(), clippingPlayer.canClip()));
    }

    private void receiveUpdate(ClippingUpdatePacket packet, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        boolean clipping = packet.clipping();
        ClippingEntity clippingPlayer = ClippingEntity.cast((class_1657)player);
        clippingPlayer.setClipping(clipping);
        class_1934 mode = player.field_13974.method_14257();
        mode.method_8382(player.method_31549());
    }

    private void copyFrom(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        ClippingEntity clippingOldPlayer = ClippingEntity.cast((class_1657)oldPlayer);
        ClippingEntity clippingNewPlayer = ClippingEntity.cast((class_1657)newPlayer);
        clippingNewPlayer.setClipping(clippingOldPlayer.isClipping());
    }

    private void afterRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        ClippingEntity clippingNewPlayer = ClippingEntity.cast((class_1657)newPlayer);
        if (clippingNewPlayer.isClipping()) {
            ServerPlayNetworking.send((class_3222)newPlayer, (class_8710)new ClippingUpdatePacket(false, false));
            ServerPlayNetworking.send((class_3222)newPlayer, (class_8710)new ClippingUpdatePacket(true, true));
        }
    }
}

