/*
 * Decompiled with CFR 0.152.
 */
package dev.andante.noclip.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.authlib.GameProfile;
import dev.andante.noclip.impl.ClippingEntity;
import dev.andante.noclip.impl.PlayerAbilitiesAccess;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements ClippingEntity {
    @Shadow
    @Final
    private class_1656 field_7503;
    @Unique
    private boolean clipping;

    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Override
    @Unique
    public boolean canClip() {
        return Permissions.check((class_1297)this, (String)"noclip", (int)2);
    }

    @Override
    @Unique
    public boolean isClipping() {
        return this.clipping;
    }

    @Override
    @Unique
    public void setClipping(boolean clipping) {
        this.clipping = clipping;
        this.field_23807 = !clipping;
    }

    @Override
    @Unique
    public boolean isClippingInsideWall() {
        if (!this.isClipping()) {
            return false;
        }
        this.field_5960 = false;
        boolean insideWall = this.method_5757();
        this.field_5960 = true;
        return insideWall;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(class_1937 world, GameProfile profile, CallbackInfo ci) {
        class_1657 that = (class_1657)this;
        ((PlayerAbilitiesAccess)this.field_7503).setPlayer(that);
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/PlayerEntity;noClip:Z", shift=At.Shift.AFTER)})
    private void onTickAfterNoClip(CallbackInfo ci) {
        if (this.isClipping()) {
            this.field_5960 = true;
            this.method_24830(false);
            this.field_6017 = 0.0;
        }
    }

    @WrapMethod(method={"updatePose"})
    private void onUpdatePose(Operation<Void> original) {
        if (this.isClipping()) {
            this.method_18380(class_4050.field_18076);
            return;
        }
        original.call(new Object[0]);
    }

    @Inject(method={"getBlockBreakingSpeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isSubmergedIn(Lnet/minecraft/registry/tag/TagKey;)Z", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void onGetBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> cir, float speed) {
        if (this.isClipping()) {
            cir.setReturnValue((Object)Float.valueOf(speed));
        }
    }

    @WrapMethod(method={"collideWithEntity"})
    private void onCollideWithEntity(class_1297 entity, Operation<Void> original) {
        if (this.isClipping()) {
            return;
        }
        original.call(new Object[]{entity});
    }

    @WrapMethod(method={"onSwimmingStart"})
    private void onOnSwimmingStart(Operation<Void> original) {
        if (this.isClipping()) {
            return;
        }
        original.call(new Object[0]);
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    private void onWriteCustomDataToNbt(class_11372 view, CallbackInfo ci) {
        view.method_71472("noclip:clipping", this.isClipping());
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    private void onReadCustomDataFromNbt(class_11368 view, CallbackInfo ci) {
        this.setClipping(view.method_71433("noclip:clipping", false));
    }
}

