/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed;

import java.io.IOException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_2960;
import net.worldofwonders.unleashed.config.WondersUnleashedConfig;
import net.worldofwonders.unleashed.effect.Spotlight;
import net.worldofwonders.unleashed.feature.FeatureRegistry;
import net.worldofwonders.unleashed.feature.WondersUnleashedDebugScreenEntry;
import net.worldofwonders.unleashed.flashback.FlashbackSupport;
import net.worldofwonders.unleashed.iris.IrisSupport;
import net.worldofwonders.unleashed.network.PayloadRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WondersUnleashed
implements ClientModInitializer {
    public static final String MOD_IDENTIFIER = "wonders-unleashed";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wonders-unleashed");
    private static WondersUnleashed INSTANCE;
    private FeatureRegistry featureRegistry;
    private PayloadRegistry payloadRegistry;
    private FlashbackSupport flashbackSupport;
    private final WondersUnleashedConfig config = new WondersUnleashedConfig(FabricLoader.getInstance().getConfigDir().resolve("wonders-unleashed.json"));

    public static class_2960 modNameSpace(String value) {
        return class_2960.method_60655((String)MOD_IDENTIFIER, (String)value);
    }

    public void onInitializeClient() {
        WondersUnleashed.logger().info("Initializing {}...", (Object)MOD_IDENTIFIER);
        INSTANCE = this;
        this.featureRegistry = new FeatureRegistry();
        this.payloadRegistry = new PayloadRegistry();
        this.loadConfig();
        if (FabricLoader.getInstance().isModLoaded("flashback")) {
            this.flashbackSupport = new FlashbackSupport();
            WondersUnleashed.logger().info("Enabled Flashback support!");
        }
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            new IrisSupport();
            WondersUnleashed.logger().info("Enabled Iris support!");
        }
        class_11631.method_72763((class_2960)WondersUnleashed.modNameSpace("debug"), (class_11632)new WondersUnleashedDebugScreenEntry());
    }

    private void loadConfig() {
        WondersUnleashed.logger().info("Loading config...");
        try {
            this.config.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.featureRegistry.disable();
        this.payloadRegistry.unregisterReceivers();
        this.payloadRegistry.serverSupported(false);
        Spotlight.INSTANCES.clear();
    }

    public FeatureRegistry featureRegistry() {
        return this.featureRegistry;
    }

    public PayloadRegistry payloadRegistry() {
        return this.payloadRegistry;
    }

    public boolean flashbackSupported() {
        return this.flashbackSupport != null;
    }

    public FlashbackSupport flashbackSupport() {
        return this.flashbackSupport;
    }

    public static WondersUnleashed instance() {
        return INSTANCE;
    }

    public static Logger logger() {
        return LOGGER;
    }

    public WondersUnleashedConfig config() {
        return this.config;
    }
}

