/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.worldofwonders.unleashed.config.option.ConfigOption;
import net.worldofwonders.unleashed.config.option.ConfigOptionRegistry;

public record WondersUnleashedConfig(Path filePath) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public void init() throws IOException {
        if (Files.exists(this.filePath, new LinkOption[0])) {
            this.load();
        } else {
            this.save();
        }
    }

    private void load() throws IOException {
        JsonObject jsonObject = JsonParser.parseString((String)Files.readString(this.filePath)).getAsJsonObject();
        for (ConfigOption<?> option : ConfigOptionRegistry.options()) {
            option.read(jsonObject);
        }
    }

    public void save() throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (ConfigOption<?> option : ConfigOptionRegistry.options()) {
            option.write(jsonObject);
        }
        Files.writeString(this.filePath, (CharSequence)GSON.toJson((JsonElement)jsonObject), new OpenOption[0]);
    }

    public void saveOrThrow() {
        try {
            this.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

