/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.effect;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_10799;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4668;
import net.minecraft.class_9848;
import net.worldofwonders.unleashed.WondersUnleashed;
import net.worldofwonders.unleashed.data.GamePos;
import net.worldofwonders.unleashed.data.lerp.LerpedBoolean;
import net.worldofwonders.unleashed.data.lerp.LerpedColor;
import net.worldofwonders.unleashed.data.lerp.LerpedFloat;
import net.worldofwonders.unleashed.data.lerp.LerpedSpotlightAnimation;
import net.worldofwonders.unleashed.effect.SpotlightAnimation;
import net.worldofwonders.unleashed.effect.SpotlightRenderState;
import net.worldofwonders.unleashed.effect.SpotlightRenderer;
import net.worldofwonders.unleashed.network.server.effect.SpawnSpotlightPacketPayload;
import net.worldofwonders.unleashed.network.server.effect.SpotlightPropertyPacketPayload;
import net.worldofwonders.unleashed.util.ColorARGB;
import net.worldofwonders.unleashed.util.Easing;

public class Spotlight {
    public static final Map<Integer, Spotlight> INSTANCES = new ConcurrentHashMap<Integer, Spotlight>();
    public static final SpotlightRenderer RENDERER = new SpotlightRenderer();
    private static final class_2960 SHADER_RESOURCE_LOCATION = WondersUnleashed.modNameSpace("core/spotlight");
    public static final RenderPipeline SPOTLIGHT_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60127}).withLocation("pipeline/spotlight").withVertexShader(SHADER_RESOURCE_LOCATION).withFragmentShader(SHADER_RESOURCE_LOCATION).withDepthWrite(false).withCull(false).withBlend(BlendFunction.LIGHTNING).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27379).build());
    public static final class_1921 SPOTLIGHT_RENDER_TYPE = class_1921.method_24049((String)"spotlight_ray", (int)256, (boolean)true, (boolean)true, (RenderPipeline)SPOTLIGHT_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23610(class_4668.field_25643).method_23611(class_4668.field_21386).method_23608(class_4668.field_21384).method_23617(false));
    private final int id;
    private final GamePos position = new GamePos();
    private final SpotlightRenderState renderState = new SpotlightRenderState();
    private final float originWidth;
    private final LerpedBoolean active = new LerpedBoolean(false, 0L, false, 0L);
    private final LerpedColor color = new LerpedColor(class_9848.method_61324((int)255, (int)26, (int)20, (int)219), 0L, class_9848.method_61324((int)255, (int)228, (int)59, (int)68), 0L, Easing.SINE_IN_OUT);
    private final LerpedFloat intensity = new LerpedFloat(Float.valueOf(0.0f), 0L, Float.valueOf(0.0f), 0L, Easing.LINEAR);
    private final LerpedFloat reach = new LerpedFloat(Float.valueOf(0.0f), 0L, Float.valueOf(0.0f), 0L, Easing.LINEAR);
    private final LerpedFloat width = new LerpedFloat(Float.valueOf(0.0f), 0L, Float.valueOf(0.0f), 0L, Easing.LINEAR);
    private final LerpedFloat yaw = new LerpedFloat(Float.valueOf(0.0f), 0L, Float.valueOf(0.0f), 0L, Easing.LINEAR);
    private final LerpedFloat pitch = new LerpedFloat(Float.valueOf(0.0f), 0L, Float.valueOf(0.0f), 0L, Easing.LINEAR);
    private final LerpedSpotlightAnimation intensityAnimation = new LerpedSpotlightAnimation(SpotlightAnimation.DEFAULT, 0L, SpotlightAnimation.DEFAULT, 0L);

    public Spotlight(int id, double x, double y, double z, float originWidth) {
        this.id = id;
        this.position.x = x;
        this.position.y = y;
        this.position.z = z;
        this.originWidth = originWidth;
        INSTANCES.put(id, this);
        this.extractRenderState();
    }

    public int id() {
        return this.id;
    }

    public GamePos position() {
        return this.position;
    }

    public float originWidth() {
        return this.originWidth;
    }

    public boolean active() {
        return this.active.value(WondersUnleashed.instance().payloadRegistry().serverTime());
    }

    public void active(boolean startValue, long startTime, boolean targetValue, long targetTime) {
        this.active.set(startValue, startTime, targetValue, targetTime, null);
    }

    public int color() {
        return this.color.value(WondersUnleashed.instance().payloadRegistry().serverTime());
    }

    public void color(int startValue, long startTime, int targetValue, long targetTime, Easing easing) {
        this.color.set(startValue, startTime, targetValue, targetTime, easing);
    }

    public float intensity() {
        float f = this.intensityAnimation().factor();
        return this.intensity.value(WondersUnleashed.instance().payloadRegistry().serverTime()).floatValue() * f;
    }

    public void intensity(float startValue, long startTime, float targetValue, long targetTime, Easing easing) {
        this.intensity.set(Float.valueOf(startValue), startTime, Float.valueOf(targetValue), targetTime, easing);
    }

    public float reach() {
        return this.reach.value(WondersUnleashed.instance().payloadRegistry().serverTime()).floatValue();
    }

    public void reach(float startValue, long startTime, float targetValue, long targetTime, Easing easing) {
        this.reach.set(Float.valueOf(startValue), startTime, Float.valueOf(targetValue), targetTime, easing);
    }

    public float width() {
        return this.width.value(WondersUnleashed.instance().payloadRegistry().serverTime()).floatValue();
    }

    public void width(float startValue, long startTime, float targetValue, long targetTime, Easing easing) {
        this.width.set(Float.valueOf(startValue), startTime, Float.valueOf(targetValue), targetTime, easing);
    }

    public float yaw() {
        return this.yaw.value(WondersUnleashed.instance().payloadRegistry().serverTime()).floatValue();
    }

    public void yaw(float startValue, long startTime, float targetValue, long targetTime, Easing easing) {
        this.yaw.set(Float.valueOf(startValue), startTime, Float.valueOf(targetValue), targetTime, easing);
    }

    public float pitch() {
        return this.pitch.value(WondersUnleashed.instance().payloadRegistry().serverTime()).floatValue();
    }

    public void pitch(float startValue, long startTime, float targetValue, long targetTime, Easing easing) {
        this.pitch.set(Float.valueOf(startValue), startTime, Float.valueOf(targetValue), targetTime, easing);
    }

    public SpotlightAnimation intensityAnimation() {
        return this.intensityAnimation.value(WondersUnleashed.instance().payloadRegistry().serverTime());
    }

    public void intensityAnimation(SpotlightAnimation startValue, long startTime, SpotlightAnimation targetValue, long targetTime) {
        this.intensityAnimation.set(startValue, startTime, targetValue, targetTime, null);
    }

    public SpotlightRenderState extractRenderState() {
        this.renderState.posX = this.position.x;
        this.renderState.posY = this.position.y;
        this.renderState.posZ = this.position.z;
        this.renderState.active = this.active();
        this.renderState.yaw = this.yaw();
        this.renderState.pitch = this.pitch();
        this.renderState.reach = this.reach();
        this.renderState.width = this.width();
        this.renderState.originWidth = this.originWidth;
        this.renderState.color = this.color();
        this.renderState.intensity = class_3532.method_15363((float)this.intensity(), (float)0.0f, (float)1.0f);
        this.renderState.primaryColor = ColorARGB.withAlpha(this.renderState.color, Math.round(120.0f * this.renderState.intensity));
        this.renderState.secondaryColor = ColorARGB.withAlpha(this.renderState.color, 0);
        return this.renderState;
    }

    public SpawnSpotlightPacketPayload spawnPacket() {
        return new SpawnSpotlightPacketPayload(this);
    }

    public SpotlightPropertyPacketPayload propertyPacket() {
        HashSet properties = new HashSet();
        properties.add(new SpotlightPropertyPacketPayload.Property<Boolean>(0, this.active));
        properties.add(new SpotlightPropertyPacketPayload.Property<Integer>(1, this.color));
        properties.add(new SpotlightPropertyPacketPayload.Property<Float>(2, this.intensity));
        properties.add(new SpotlightPropertyPacketPayload.Property<Float>(3, this.reach));
        properties.add(new SpotlightPropertyPacketPayload.Property<Float>(4, this.width));
        properties.add(new SpotlightPropertyPacketPayload.Property<Float>(5, this.yaw));
        properties.add(new SpotlightPropertyPacketPayload.Property<Float>(6, this.pitch));
        properties.add(new SpotlightPropertyPacketPayload.Property<SpotlightAnimation>(7, this.intensityAnimation));
        return new SpotlightPropertyPacketPayload(this, properties);
    }

    static {
        WorldRenderEvents.AFTER_ENTITIES.register(event -> {
            class_4587 poseStack = event.matrices();
            class_4184 camera = event.gameRenderer().method_19418();
            class_11659 submitNodeCollector = event.commandQueue();
            SpotlightRenderer spotlightRenderer = RENDERER;
            spotlightRenderer.updateState(poseStack, camera);
            spotlightRenderer.collectRenderStates();
            submitNodeCollector.method_73483(poseStack, SPOTLIGHT_RENDER_TYPE, (class_11659.class_11660)spotlightRenderer);
        });
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((minecraft, clientLevel) -> INSTANCES.clear());
    }
}

