/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.effect;

public interface SpotlightPattern {
    public static final SpotlightPattern NONE = (startTime, currentTime, interval, offset) -> 1.0f;
    public static final SpotlightPattern ABS_SINE_WAVE_0 = (startTime, currentTime, interval, offset) -> {
        long timeElapsed = currentTime - startTime;
        double progress = (double)(timeElapsed % interval) / (double)interval;
        return (float)Math.pow(Math.sin(Math.PI * progress + (double)offset), 2.0);
    };
    public static final SpotlightPattern ABS_SINE_WAVE_02 = (startTime, currentTime, interval, offset) -> {
        long timeElapsed = currentTime - startTime;
        double progress = (double)(timeElapsed % interval) / (double)interval;
        return (float)(0.8 * Math.pow(Math.sin(Math.PI * progress + (double)offset), 2.0) + 0.2);
    };
    public static final SpotlightPattern ABS_SINE_WAVE_04 = (startTime, currentTime, interval, offset) -> {
        long timeElapsed = currentTime - startTime;
        double progress = (double)(timeElapsed % interval) / (double)interval;
        return (float)(0.6 * Math.pow(Math.sin(Math.PI * progress + (double)offset), 2.0) + 0.4);
    };
    public static final SpotlightPattern ABS_SINE_WAVE_06 = (startTime, currentTime, interval, offset) -> {
        long timeElapsed = currentTime - startTime;
        double progress = (double)(timeElapsed % interval) / (double)interval;
        return (float)(0.4 * Math.pow(Math.sin(Math.PI * progress + (double)offset), 2.0) + 0.6);
    };
    public static final SpotlightPattern ABS_SINE_WAVE_08 = (startTime, currentTime, interval, offset) -> {
        long timeElapsed = currentTime - startTime;
        double progress = (double)(timeElapsed % interval) / (double)interval;
        return (float)(0.2 * Math.pow(Math.sin(Math.PI * progress + (double)offset), 2.0) + 0.8);
    };

    public float factor(long var1, long var3, long var5, long var7);

    public static SpotlightPattern fromIndex(byte b) {
        return switch (b) {
            case 0 -> NONE;
            case 1 -> ABS_SINE_WAVE_0;
            case 2 -> ABS_SINE_WAVE_02;
            case 3 -> ABS_SINE_WAVE_04;
            case 4 -> ABS_SINE_WAVE_06;
            case 5 -> ABS_SINE_WAVE_08;
            default -> throw new IllegalArgumentException("Invalid index: " + b);
        };
    }

    public static byte toIndex(SpotlightPattern pattern) {
        if (pattern == NONE) {
            return 0;
        }
        if (pattern == ABS_SINE_WAVE_0) {
            return 1;
        }
        if (pattern == ABS_SINE_WAVE_02) {
            return 2;
        }
        if (pattern == ABS_SINE_WAVE_04) {
            return 3;
        }
        if (pattern == ABS_SINE_WAVE_06) {
            return 4;
        }
        if (pattern == ABS_SINE_WAVE_08) {
            return 5;
        }
        throw new IllegalArgumentException("Invalid pattern: " + String.valueOf(pattern));
    }
}

