/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.effect;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_11659;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.worldofwonders.unleashed.effect.Spotlight;
import net.worldofwonders.unleashed.effect.SpotlightRenderState;
import net.worldofwonders.unleashed.util.ColorARGB;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SpotlightRenderer
implements class_11659.class_11660 {
    private class_4587 poseStack;
    private class_4184 camera;
    private final Set<SpotlightRenderState> renderStateSet = new HashSet<SpotlightRenderState>();

    public void updateState(class_4587 poseStack, class_4184 camera) {
        this.poseStack = poseStack;
        this.camera = camera;
    }

    public void collectRenderStates() {
        this.renderStateSet.clear();
        for (Spotlight spotlight : Spotlight.INSTANCES.values()) {
            if (!spotlight.active()) continue;
            this.renderStateSet.add(spotlight.extractRenderState());
        }
    }

    public void render(class_4587.class_4665 pose, class_4588 vertexConsumer) {
        if (this.poseStack == null || this.camera == null) {
            return;
        }
        for (SpotlightRenderState renderState : this.renderStateSet) {
            SpotlightRenderer.renderSpotlight(this.camera, this.poseStack, vertexConsumer, renderState);
        }
    }

    private static void renderSpotlight(class_4184 camera, class_4587 poseStack, class_4588 vertexConsumer, SpotlightRenderState renderState) {
        poseStack.method_22903();
        poseStack.method_22904(renderState.posX - camera.method_19326().field_1352, renderState.posY - camera.method_19326().field_1351, renderState.posZ - camera.method_19326().field_1350);
        poseStack.method_22903();
        poseStack.method_22907((Quaternionfc)SpotlightRenderer.quaternionFromYawPitch(renderState.yaw, renderState.pitch));
        float reach = renderState.reach;
        float width = renderState.width;
        float originWidth = renderState.originWidth;
        int color = renderState.color;
        float intensity = class_3532.method_15363((float)renderState.intensity, (float)0.0f, (float)1.0f);
        int primaryColor = ColorARGB.withAlpha(color, Math.round(120.0f * intensity));
        int secondaryColor = ColorARGB.withAlpha(color, 0);
        class_4587.class_4665 entry = poseStack.method_23760();
        SpotlightRenderer.drawCone(entry, vertexConsumer, 7, reach, width, originWidth, primaryColor, secondaryColor);
        SpotlightRenderer.drawCone(entry, vertexConsumer, 7, reach * 0.85f, width * 0.75f, originWidth, primaryColor, secondaryColor);
        poseStack.method_22909();
        poseStack.method_22909();
    }

    private static void drawCone(class_4587.class_4665 entry, class_4588 vertexConsumer, int segments, float strength, float width, float originWidth, int primaryColor, int secondaryColor) {
        float angleStep = (float)(Math.PI * 2 / (double)segments);
        for (int i = 0; i < segments; ++i) {
            float angle1 = (float)i * angleStep;
            float angle2 = (float)(i + 1) * angleStep;
            float x1 = (float)Math.cos(angle1);
            float z1 = (float)Math.sin(angle1);
            float x2 = (float)Math.cos(angle2);
            float z2 = (float)Math.sin(angle2);
            float x1Top = x1 * originWidth / 2.0f;
            float z1Top = z1 * originWidth / 2.0f;
            float x2Top = x2 * originWidth / 2.0f;
            float z2Top = z2 * originWidth / 2.0f;
            float x1Bottom = x1 * width / 2.0f;
            float z1Bottom = z1 * width / 2.0f;
            float x2Bottom = x2 * width / 2.0f;
            float z2Bottom = z2 * width / 2.0f;
            vertexConsumer.method_22918(entry.method_23761(), x1Top, 0.0f, z1Top).method_39415(primaryColor).method_22913(0.0f, 0.0f).method_60796(0, 0).method_60803(0xF000F0);
            vertexConsumer.method_22918(entry.method_23761(), x1Bottom, strength, z1Bottom).method_39415(secondaryColor).method_22913(0.0f, 0.0f).method_60796(0, 0).method_60803(0xF000F0);
            vertexConsumer.method_22918(entry.method_23761(), x2Bottom, strength, z2Bottom).method_39415(secondaryColor).method_22913(0.0f, 0.0f).method_60796(0, 0).method_60803(0xF000F0);
            vertexConsumer.method_22918(entry.method_23761(), x1Top, 0.0f, z1Top).method_39415(primaryColor).method_22913(0.0f, 0.0f).method_60796(0, 0).method_60803(0xF000F0);
            vertexConsumer.method_22918(entry.method_23761(), x2Bottom, strength, z2Bottom).method_39415(secondaryColor).method_22913(0.0f, 0.0f).method_60796(0, 0).method_60803(0xF000F0);
            vertexConsumer.method_22918(entry.method_23761(), x2Top, 0.0f, z2Top).method_39415(primaryColor).method_22913(0.0f, 0.0f).method_60796(0, 0).method_60803(0xF000F0);
        }
    }

    private static Quaternionf quaternionFromYawPitch(float yaw, float pitch) {
        Quaternionf pitchQuat = new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), pitch);
        Quaternionf yawQuat = new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), yaw);
        return yawQuat.mul((Quaternionfc)pitchQuat);
    }
}

