/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.feature;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.worldofwonders.unleashed.feature.AbstractFeature;
import net.worldofwonders.unleashed.feature.FeatureRegistry;
import net.worldofwonders.unleashed.feature.particle.BetterBloomFeature;
import net.worldofwonders.unleashed.feature.renderer.BalloonCullFeature;
import net.worldofwonders.unleashed.feature.renderer.HideNameTagsFeature;
import net.worldofwonders.unleashed.feature.renderer.ItemAlphaFeature;
import org.jetbrains.annotations.Nullable;

public record Feature<T extends AbstractFeature>(byte protocolId, String nameSpace, Function<FeatureRegistry, T> function) {
    private static final Set<Feature<?>> REGISTERED_FEATURES = new HashSet();
    public static final Feature<BalloonCullFeature> BALLOON_CULL = Feature.register("balloon_cull", BalloonCullFeature::new);
    public static final Feature<ItemAlphaFeature> ITEM_ALPHA = Feature.register("item_alpha", ItemAlphaFeature::new);
    public static final Feature<BetterBloomFeature> BETTER_BLOOM = Feature.register("better_bloom", BetterBloomFeature::new);
    public static final Feature<HideNameTagsFeature> HIDE_NAME_TAGS = Feature.register("hide_name_tags", HideNameTagsFeature::new);

    private static <T extends AbstractFeature> Feature<T> register(String nameSpace, Function<FeatureRegistry, T> function) {
        byte nextId = (byte)REGISTERED_FEATURES.size();
        Feature<T> feature = new Feature<T>(nextId, nameSpace, function);
        REGISTERED_FEATURES.add(feature);
        return feature;
    }

    @Nullable
    public static <T extends AbstractFeature> Feature<T> byProtocolId(byte protocolId) {
        for (Feature<?> registeredFeature : REGISTERED_FEATURES) {
            if (registeredFeature.protocolId() != protocolId) continue;
            return registeredFeature;
        }
        return null;
    }

    static <T extends AbstractFeature> void applyToRegistry(FeatureRegistry featureRegistry, Map<Feature<T>, T> map) {
        for (Feature<?> registeredFeature : REGISTERED_FEATURES) {
            map.put(registeredFeature, (AbstractFeature)registeredFeature.function.apply(featureRegistry));
        }
    }
}

