/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.worldofwonders.unleashed.feature.AbstractFeature;
import net.worldofwonders.unleashed.feature.Feature;

public class FeatureRegistry {
    protected final Map<Feature<AbstractFeature>, AbstractFeature> featureMap = new HashMap<Feature<AbstractFeature>, AbstractFeature>();

    public FeatureRegistry() {
        Feature.applyToRegistry(this, this.featureMap);
    }

    public <T extends AbstractFeature> T feature(Feature<T> feature) {
        if (!this.featureMap.containsKey(feature)) {
            throw new NullPointerException("Feature " + feature.nameSpace() + " has not been registered!");
        }
        return (T)this.featureMap.get(feature);
    }

    public void enable() {
        this.featureMap.values().forEach(feature -> feature.enabled(true));
    }

    public void disable() {
        this.featureMap.values().forEach(feature -> feature.enabled(false));
    }

    public Set<Feature<?>> enabledFeatures() {
        return this.featureMap.entrySet().stream().filter(set -> ((AbstractFeature)set.getValue()).enabled()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

