/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.mixin.flashback;

import com.google.gson.JsonObject;
import com.moulberry.flashback.record.FlashbackMeta;
import net.worldofwonders.unleashed.WondersUnleashed;
import net.worldofwonders.unleashed.wrapper.FlashbackMetaWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlashbackMeta.class})
public class FlashbackMetaMixin
implements FlashbackMetaWrapper {
    @Unique
    private static final String KEY = "wonders_unleashed_server_start_time";
    @Unique
    private long serverStartTime;

    @Inject(method={"toJson()Lcom/google/gson/JsonObject;"}, at={@At(value="RETURN")}, remap=false)
    private void toExtraJson(CallbackInfoReturnable<JsonObject> cir) {
        if (!WondersUnleashed.instance().payloadRegistry().serverSupported()) {
            return;
        }
        JsonObject jsonObject = (JsonObject)cir.getReturnValue();
        jsonObject.addProperty(KEY, (Number)WondersUnleashed.instance().flashbackSupport().serverStartTime());
    }

    @Inject(method={"fromJson(Lcom/google/gson/JsonObject;)Lcom/moulberry/flashback/record/FlashbackMeta;"}, at={@At(value="RETURN")}, remap=false)
    private static void readExtraFromJson(JsonObject meta, CallbackInfoReturnable<FlashbackMeta> cir) {
        FlashbackMeta flashbackMeta = (FlashbackMeta)cir.getReturnValue();
        if (!meta.has(KEY)) {
            return;
        }
        if (!(flashbackMeta instanceof FlashbackMetaWrapper)) {
            return;
        }
        FlashbackMetaWrapper flashbackMetaWrapper = (FlashbackMetaWrapper)flashbackMeta;
        flashbackMetaWrapper.wonders_unleashed$serverStartTime(meta.get(KEY).getAsLong());
    }

    @Override
    public long wonders_unleashed$serverStartTime() {
        return this.serverStartTime;
    }

    @Override
    public void wonders_unleashed$serverStartTime(long time) {
        this.serverStartTime = time;
    }
}

