/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.mixin.flashback;

import com.moulberry.flashback.io.AsyncReplaySaver;
import com.moulberry.flashback.record.Recorder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.worldofwonders.unleashed.WondersUnleashed;
import net.worldofwonders.unleashed.effect.Spotlight;
import net.worldofwonders.unleashed.feature.Feature;
import net.worldofwonders.unleashed.network.server.HandshakeResponsePacketPayload;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Recorder.class})
public class RecorderMixin {
    @Shadow
    private class_9139<ByteBuf, class_2596<? super class_2602>> gamePacketCodec;
    @Shadow
    @Final
    private AsyncReplaySaver asyncReplaySaver;

    @Inject(method={"writeSnapshot(Z)V"}, at={@At(value="TAIL")}, remap=false)
    private void snapshot(boolean asActualSnapshot, CallbackInfo ci) {
        if (!WondersUnleashed.instance().payloadRegistry().serverSupported()) {
            return;
        }
        this.unleashedSnapshot();
    }

    @Unique
    private void unleashedSnapshot() {
        ArrayList<class_2658> gamePackets = new ArrayList<class_2658>();
        long serverTime = WondersUnleashed.instance().payloadRegistry().serverTime();
        byte[] features = RecorderMixin.enabledFeatures();
        gamePackets.add(new class_2658((class_8710)new HandshakeResponsePacketPayload(serverTime, features)));
        for (Spotlight spotlight : Spotlight.INSTANCES.values()) {
            gamePackets.add(new class_2658((class_8710)spotlight.spawnPacket()));
            gamePackets.add(new class_2658((class_8710)spotlight.propertyPacket()));
        }
        this.asyncReplaySaver.writeGamePackets(this.gamePacketCodec, gamePackets);
    }

    @Unique
    private static byte[] enabledFeatures() {
        List featureSet = WondersUnleashed.instance().featureRegistry().enabledFeatures().stream().toList();
        byte[] result = new byte[featureSet.size()];
        int i = 0;
        for (Feature feature : featureSet) {
            result[i++] = feature.protocolId();
        }
        return result;
    }
}

