/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.network;

import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2547;
import net.minecraft.class_2960;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.worldofwonders.unleashed.WondersUnleashed;
import net.worldofwonders.unleashed.flashback.FlashbackSupport;
import net.worldofwonders.unleashed.network.client.HandshakePacketPayload;
import net.worldofwonders.unleashed.network.client.ServerTimeRequestPacketPayload;
import net.worldofwonders.unleashed.network.server.ConfigStatusPayload;
import net.worldofwonders.unleashed.network.server.FeatureStatePacketPayload;
import net.worldofwonders.unleashed.network.server.HandshakeResponsePacketPayload;
import net.worldofwonders.unleashed.network.server.ServerTimeResponsePacketPayload;
import net.worldofwonders.unleashed.network.server.effect.RemoveSpotlightPacketPayload;
import net.worldofwonders.unleashed.network.server.effect.SpawnSpotlightPacketPayload;
import net.worldofwonders.unleashed.network.server.effect.SpotlightPropertyPacketPayload;

public class PayloadRegistry {
    public static final int PROTOCOL_VERSION = 1;
    private static final int SERVER_TIME_REQUEST_INTERVAL = 400;
    private boolean serverSupported = false;
    private final AtomicInteger pingId = new AtomicInteger(0);
    private long serverTimeTickCounter = 0L;
    private long serverTimeRequest = System.currentTimeMillis();
    private long serverTimeResponse = System.currentTimeMillis();
    private long serverTime = System.currentTimeMillis();

    public PayloadRegistry() {
        C2SPlayChannelEvents.REGISTER.register((handler, sender, client, channels) -> {
            if (channels.contains(HandshakePacketPayload.ID.comp_2242())) {
                this.serverTimeRequest = System.currentTimeMillis();
                ClientPlayNetworking.send((class_8710)new HandshakePacketPayload(1));
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> WondersUnleashed.instance().reset());
        this.registerClientboundPayload();
        this.registerServerboundPayload();
        this.registerPingTask();
        ClientPlayNetworking.registerGlobalReceiver(HandshakeResponsePacketPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new HandshakeResponsePacketPayload.Handler());
        ClientConfigurationNetworking.registerGlobalReceiver(ConfigStatusPayload.ID, (ClientConfigurationNetworking.ConfigurationPayloadHandler)new ConfigStatusPayload.Handler());
    }

    private void registerClientboundPayload() {
        PayloadTypeRegistry.playS2C().register(HandshakeResponsePacketPayload.ID, HandshakeResponsePacketPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(FeatureStatePacketPayload.ID, FeatureStatePacketPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SpawnSpotlightPacketPayload.ID, SpawnSpotlightPacketPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SpotlightPropertyPacketPayload.ID, SpotlightPropertyPacketPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(RemoveSpotlightPacketPayload.ID, RemoveSpotlightPacketPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ServerTimeResponsePacketPayload.ID, ServerTimeResponsePacketPayload.CODEC);
        PayloadTypeRegistry.configurationS2C().register(ConfigStatusPayload.ID, ConfigStatusPayload.CODEC);
    }

    private void registerServerboundPayload() {
        PayloadTypeRegistry.playC2S().register(HandshakePacketPayload.ID, HandshakePacketPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ServerTimeRequestPacketPayload.ID, ServerTimeRequestPacketPayload.CODEC);
    }

    public void registerReceivers() {
        ClientPlayNetworking.registerReceiver(FeatureStatePacketPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new FeatureStatePacketPayload.Handler());
        ClientPlayNetworking.registerReceiver(SpawnSpotlightPacketPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new SpawnSpotlightPacketPayload.Handler());
        ClientPlayNetworking.registerReceiver(SpotlightPropertyPacketPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new SpotlightPropertyPacketPayload.Handler());
        ClientPlayNetworking.registerReceiver(RemoveSpotlightPacketPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new RemoveSpotlightPacketPayload.Handler());
        ClientPlayNetworking.registerReceiver(ServerTimeResponsePacketPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new ServerTimeResponsePacketPayload.Handler());
    }

    public void unregisterReceivers() {
        ClientPlayNetworking.unregisterReceiver((class_2960)HandshakeResponsePacketPayload.ID.comp_2242());
        ClientPlayNetworking.unregisterReceiver((class_2960)FeatureStatePacketPayload.ID.comp_2242());
        ClientPlayNetworking.unregisterReceiver((class_2960)SpawnSpotlightPacketPayload.ID.comp_2242());
        ClientPlayNetworking.unregisterReceiver((class_2960)SpotlightPropertyPacketPayload.ID.comp_2242());
        ClientPlayNetworking.unregisterReceiver((class_2960)RemoveSpotlightPacketPayload.ID.comp_2242());
        ClientPlayNetworking.unregisterReceiver((class_2960)ServerTimeResponsePacketPayload.ID.comp_2242());
    }

    public boolean serverSupported() {
        return this.serverSupported;
    }

    public void serverSupported(boolean serverSupported) {
        this.serverSupported = serverSupported;
    }

    private void registerPingTask() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            class_634 clientPacketListener = client.method_1562();
            if (clientPacketListener == null) {
                return;
            }
            if (!clientPacketListener.method_48106()) {
                return;
            }
            class_2535 connection = clientPacketListener.method_48296();
            class_2547 packetListener = connection.method_10744();
            if (packetListener == null) {
                return;
            }
            if (packetListener.method_52280() != class_2539.field_20591) {
                return;
            }
            if (!this.serverSupported) {
                return;
            }
            if (this.serverTimeTickCounter++ % 400L == 0L) {
                this.requestServerTime();
            }
        });
    }

    public void requestServerTime() {
        this.serverTimeRequest = System.currentTimeMillis();
        int id = this.pingId.incrementAndGet();
        ClientPlayNetworking.send((class_8710)new ServerTimeRequestPacketPayload(id));
    }

    public int currentPingId() {
        return this.pingId.get();
    }

    public long lastPingResponse() {
        return this.serverTimeResponse;
    }

    public void serverTime(long time) {
        this.serverTimeResponse = System.currentTimeMillis();
        long ping = (this.serverTimeResponse - this.serverTimeRequest) / 2L;
        this.serverTime = time + ping;
    }

    public long serverTime() {
        FlashbackSupport flashbackSupport;
        long result = this.serverTime + (System.currentTimeMillis() - this.serverTimeResponse);
        if (WondersUnleashed.instance().flashbackSupported() && (flashbackSupport = WondersUnleashed.instance().flashbackSupport()).isInReplay()) {
            result = flashbackSupport.replayServerTime();
        }
        return result;
    }
}

