/*
 * Decompiled with CFR 0.152.
 */
package net.worldofwonders.unleashed.network.server.effect;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.worldofwonders.unleashed.WondersUnleashed;
import net.worldofwonders.unleashed.data.lerp.LerpedValue;
import net.worldofwonders.unleashed.effect.Spotlight;
import net.worldofwonders.unleashed.effect.SpotlightAnimation;
import net.worldofwonders.unleashed.util.Easing;
import org.jetbrains.annotations.NotNull;

public class SpotlightPropertyPacketPayload
implements class_8710 {
    public static final class_8710.class_9154<SpotlightPropertyPacketPayload> ID = new class_8710.class_9154(WondersUnleashed.modNameSpace("spotlight_property"));
    public static final class_9139<class_9129, SpotlightPropertyPacketPayload> CODEC = class_9139.method_56437(SpotlightPropertyPacketPayload::write, SpotlightPropertyPacketPayload::new);
    public static final Map<Byte, Function<Byte, Property<?>>> CONSTRUCTOR_MAP = new HashMap();
    public static final Map<Byte, BiConsumer<Spotlight, Property<?>>> CONSUMER_MAP = new HashMap();
    public final int id;
    public final Set<Property<?>> propertySet = new HashSet();

    private static <A> void register(int b, boolean hasEasing, class_9139<ByteBuf, A> codec, BiConsumer<Spotlight, Property<A>> consumer) {
        CONSTRUCTOR_MAP.put((byte)b, index -> new Property((byte)b, codec, hasEasing));
        BiConsumer<Spotlight, Property> wrappedConsumer = (spotlight, property) -> {
            Property typedProperty = property;
            consumer.accept((Spotlight)spotlight, typedProperty);
        };
        CONSUMER_MAP.put((byte)b, wrappedConsumer);
    }

    private static void write(class_9129 friendlyByteBuf, SpotlightPropertyPacketPayload spotlightPropertyPacketPayload) {
        friendlyByteBuf.method_53002(spotlightPropertyPacketPayload.id);
        Set<Property<?>> properties = spotlightPropertyPacketPayload.propertySet;
        friendlyByteBuf.method_52997(properties.size());
        for (Property<?> property : properties) {
            property.encode((class_2540)friendlyByteBuf);
        }
    }

    public SpotlightPropertyPacketPayload(Spotlight spotlight, Set<Property<?>> properties) {
        this.id = spotlight.id();
        this.propertySet.addAll(properties);
    }

    private SpotlightPropertyPacketPayload(class_9129 friendlyByteBuf) {
        this.id = friendlyByteBuf.readInt();
        int entries = friendlyByteBuf.readByte();
        for (int i = 0; i < entries; ++i) {
            byte index = friendlyByteBuf.readByte();
            Property<?> property = CONSTRUCTOR_MAP.get(index).apply(index);
            property.decode((class_2540)friendlyByteBuf);
            this.propertySet.add(property);
        }
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    static {
        SpotlightPropertyPacketPayload.register(0, false, class_9135.field_48547, (spotlight, property) -> spotlight.active((Boolean)property.startValue, property.startTime, (Boolean)property.targetValue, property.targetTime));
        SpotlightPropertyPacketPayload.register(1, true, class_9135.field_49675, (spotlight, property) -> spotlight.color((Integer)property.startValue, property.startTime, (Integer)property.targetValue, property.targetTime, property.easing));
        SpotlightPropertyPacketPayload.register(2, true, class_9135.field_48552, (spotlight, property) -> spotlight.intensity(((Float)property.startValue).floatValue(), property.startTime, ((Float)property.targetValue).floatValue(), property.targetTime, property.easing));
        SpotlightPropertyPacketPayload.register(3, true, class_9135.field_48552, (spotlight, property) -> spotlight.reach(((Float)property.startValue).floatValue(), property.startTime, ((Float)property.targetValue).floatValue(), property.targetTime, property.easing));
        SpotlightPropertyPacketPayload.register(4, true, class_9135.field_48552, (spotlight, property) -> spotlight.width(((Float)property.startValue).floatValue(), property.startTime, ((Float)property.targetValue).floatValue(), property.targetTime, property.easing));
        SpotlightPropertyPacketPayload.register(5, true, class_9135.field_48552, (spotlight, property) -> spotlight.yaw(((Float)property.startValue).floatValue(), property.startTime, ((Float)property.targetValue).floatValue(), property.targetTime, property.easing));
        SpotlightPropertyPacketPayload.register(6, true, class_9135.field_48552, (spotlight, property) -> spotlight.pitch(((Float)property.startValue).floatValue(), property.startTime, ((Float)property.targetValue).floatValue(), property.targetTime, property.easing));
        SpotlightPropertyPacketPayload.register(7, false, SpotlightAnimation.CODEC, (spotlight, property) -> spotlight.intensityAnimation((SpotlightAnimation)property.startValue, property.startTime, (SpotlightAnimation)property.targetValue, property.targetTime));
    }

    public static class Property<A> {
        private final byte index;
        protected A startValue;
        protected long startTime;
        protected A targetValue;
        protected long targetTime;
        protected boolean hasEasing;
        protected Easing easing;
        protected final class_9139<ByteBuf, A> codec;

        public Property(byte index, class_9139<ByteBuf, A> codec, boolean hasEasing) {
            this.index = index;
            this.codec = codec;
            this.hasEasing = hasEasing;
        }

        public Property(byte index, LerpedValue<A> lerpedValue) {
            this.index = index;
            this.startValue = lerpedValue.startValue();
            this.startTime = lerpedValue.startTime();
            this.targetValue = lerpedValue.targetValue();
            this.targetTime = lerpedValue.targetTime();
            this.hasEasing = lerpedValue.easing() != null;
            this.easing = lerpedValue.easing();
            this.codec = lerpedValue.codec();
        }

        public void encode(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997((int)this.index);
            this.codec.encode((Object)friendlyByteBuf, this.startValue);
            friendlyByteBuf.method_10791(this.startTime);
            this.codec.encode((Object)friendlyByteBuf, this.targetValue);
            friendlyByteBuf.method_10791(this.targetTime);
            if (this.hasEasing) {
                friendlyByteBuf.method_52997((int)Easing.toIndex(this.easing));
            }
        }

        public void decode(class_2540 friendlyByteBuf) {
            this.startValue = this.codec.decode((Object)friendlyByteBuf);
            this.startTime = friendlyByteBuf.method_10792();
            this.targetValue = this.codec.decode((Object)friendlyByteBuf);
            this.targetTime = friendlyByteBuf.method_10792();
            if (this.hasEasing) {
                this.easing = Easing.fromIndex(friendlyByteBuf.readByte());
            }
        }
    }

    public static class Handler
    implements ClientPlayNetworking.PlayPayloadHandler<SpotlightPropertyPacketPayload> {
        public void receive(SpotlightPropertyPacketPayload payload, ClientPlayNetworking.Context context) {
            Spotlight spotlight = Spotlight.INSTANCES.get(payload.id);
            if (spotlight == null) {
                return;
            }
            for (Property<?> property : payload.propertySet) {
                this.applyProperty(spotlight, property);
            }
        }

        private void applyProperty(Spotlight spotlight, Property<?> property) {
            CONSUMER_MAP.get(property.index).accept(spotlight, property);
        }
    }
}

