/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire.compat;

import de.cech12.unlitcampfire.Constants;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin,
IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)this, CampfireBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)this, CampfireBlock.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        CompoundTag serverData = accessor.getServerData();
        if (serverData.getBoolean("BurnsInfinite")) {
            tooltip.add((Component)Component.translatable((String)"hud.unlitcampfire.infinite"));
        } else if (serverData.contains("LitTime")) {
            tooltip.add((Component)Component.translatable((String)"hud.unlitcampfire.n_seconds", (Object[])new Object[]{this.getSecondsLeft(serverData)}));
        }
    }

    private int getSecondsLeft(CompoundTag serverData) {
        return (serverData.getInt("MaxLitTime") - serverData.getInt("LitTime")) / 20;
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        BlockState blockState = blockAccessor.getBlockState();
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof ICampfireBlockEntityMixin) {
            ICampfireBlockEntityMixin campfireBlockEntity = (ICampfireBlockEntityMixin)blockEntity;
            blockEntity = blockState.getBlock();
            if (blockEntity instanceof ICampfireBlockMixin) {
                ICampfireBlockMixin campfireBlock = (ICampfireBlockMixin)blockEntity;
                data.putBoolean("BurnsInfinite", campfireBlock.unlitCampfire$burnsInfinite(blockState));
                data.putInt("MaxLitTime", campfireBlock.unlitCampfire$getMaxLitTime(blockState));
                if (!campfireBlock.unlitCampfire$burnsInfinite(blockState)) {
                    data.putInt("LitTime", campfireBlockEntity.unlitCampfire$getLitTime());
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return Constants.id("campfireinfo");
    }
}

