/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire.client;

import de.cech12.unlitcampfire.Constants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.CampfireBlock;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeClientCompat
implements IWailaPlugin,
IBlockComponentProvider {
    public ResourceLocation getUid() {
        return Constants.id("campfireinfo");
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)this, CampfireBlock.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        CompoundTag serverData = accessor.getServerData();
        if (serverData.getBooleanOr("BurnsInfinite", false)) {
            tooltip.add((Component)Component.translatable((String)"hud.unlitcampfire.infinite"));
        } else if (serverData.contains("LitTime")) {
            tooltip.add((Component)Component.translatable((String)"hud.unlitcampfire.n_seconds", (Object[])new Object[]{this.getSecondsLeft(serverData)}));
        }
    }

    private int getSecondsLeft(CompoundTag serverData) {
        return (serverData.getIntOr("MaxLitTime", 0) - serverData.getIntOr("LitTime", 0)) / 20;
    }
}

