/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire.mixin;

import de.cech12.unlitcampfire.CommonLoader;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import de.cech12.unlitcampfire.platform.Services;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3920;
import net.minecraft.class_3922;
import net.minecraft.class_3924;
import net.minecraft.class_9696;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3924.class})
public abstract class CampfireBlockEntityMixin
extends class_2586
implements ICampfireBlockEntityMixin {
    @Unique
    private Boolean unlitCampfire$isSoulCampfire;
    @Unique
    private int unlitCampfire$litTime = 0;
    @Unique
    private int unlitCampfire$rainTime = 0;

    @Shadow
    protected abstract void method_17510();

    public CampfireBlockEntityMixin(class_2338 pos, class_2680 state) {
        super(class_2591.field_17380, pos, state);
        CommonLoader.addCampfire(this);
    }

    @Override
    public boolean unlitCampfire$isSoulCampfire() {
        if (this.unlitCampfire$isSoulCampfire == null) {
            if (this.field_11863 != null) {
                this.unlitCampfire$isSoulCampfire = this.field_11863.method_8320(this.field_11867).method_26204() == class_2246.field_23860;
                return this.unlitCampfire$isSoulCampfire;
            }
            return false;
        }
        return this.unlitCampfire$isSoulCampfire;
    }

    @Unique
    private int unlitCampfire$getMaxLitTime() {
        return ((ICampfireBlockMixin)this.method_11010().method_26204()).unlitCampfire$getMaxLitTime(this.method_11010());
    }

    @Unique
    private int unlitCampfire$getMaxLitTimeExtension() {
        return ((ICampfireBlockMixin)this.method_11010().method_26204()).unlitCampfire$getMaxLitTimeExtension(this.method_11010());
    }

    @Unique
    private int unlitCampfire$getRunsOutIndicator() {
        return ((ICampfireBlockMixin)this.method_11010().method_26204()).unlitCampfire$getRunsOutIndicatorTime(this.method_11010());
    }

    @Unique
    private boolean unlitCampfire$burnsInfinite() {
        return ((ICampfireBlockMixin)this.method_11010().method_26204()).unlitCampfire$burnsInfinite(this.method_11010());
    }

    @Unique
    private void unlitCampfire$playUnlitSound() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8444(null, 1009, this.method_11016(), 0);
        }
    }

    @Unique
    private void unlitCampfire$destroyCampfire() {
        if (this.field_11863 != null) {
            this.unlitCampfire$playUnlitSound();
            this.field_11863.method_8501(this.method_11016(), class_2246.field_10124.method_9564());
        }
    }

    @Unique
    private void unlitCampfire$unlitCampfire() {
        if (this.field_11863 != null) {
            this.unlitCampfire$playUnlitSound();
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false)));
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)ICampfireBlockMixin.RUNS_OUT, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public int unlitCampfire$getLitTime() {
        return this.unlitCampfire$litTime;
    }

    @Override
    public boolean unlitCampfire$addLitTime(int litTimeToAdd) {
        if (this.unlitCampfire$burnsInfinite()) {
            return false;
        }
        if (litTimeToAdd < 0) {
            return this.unlitCampfire$removeLitTime(-litTimeToAdd);
        }
        if (this.unlitCampfire$litTime <= -this.unlitCampfire$getMaxLitTimeExtension() || !((Boolean)this.method_11010().method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            return false;
        }
        this.unlitCampfire$litTime -= litTimeToAdd;
        this.method_17510();
        return true;
    }

    @Override
    public boolean unlitCampfire$removeLitTime(int litTimeToRemove) {
        if (this.unlitCampfire$burnsInfinite()) {
            return false;
        }
        if (litTimeToRemove < 0) {
            return this.unlitCampfire$addLitTime(-litTimeToRemove);
        }
        if (this.unlitCampfire$litTime >= this.unlitCampfire$getMaxLitTime() || !((Boolean)this.method_11010().method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            return false;
        }
        this.unlitCampfire$litTime += litTimeToRemove;
        this.method_17510();
        return true;
    }

    @Inject(at={@At(value="RETURN")}, method={"cookTick"})
    private static void cookTickProxy(class_3218 level, class_2338 pos, class_2680 state, class_3924 blockEntity, class_1863.class_7266<class_9696, class_3920> cachedRecipe, CallbackInfo info) {
        CampfireBlockEntityMixin mixinEntity = (CampfireBlockEntityMixin)blockEntity;
        if (level != null && mixinEntity != null && ((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            boolean shouldUnlitByRain;
            if (!mixinEntity.unlitCampfire$burnsInfinite()) {
                ++mixinEntity.unlitCampfire$litTime;
                if (mixinEntity.unlitCampfire$litTime >= mixinEntity.unlitCampfire$getMaxLitTime()) {
                    if (Services.CONFIG.isBreakingWhenUnlitByTime(mixinEntity.unlitCampfire$isSoulCampfire())) {
                        mixinEntity.unlitCampfire$destroyCampfire();
                    } else {
                        mixinEntity.unlitCampfire$unlitCampfire();
                    }
                    return;
                }
                boolean runOutIndicatorReached = mixinEntity.unlitCampfire$litTime >= mixinEntity.unlitCampfire$getMaxLitTime() - mixinEntity.unlitCampfire$getRunsOutIndicator();
                boolean isRunOutActive = (Boolean)state.method_11654((class_2769)ICampfireBlockMixin.RUNS_OUT);
                if (runOutIndicatorReached && !isRunOutActive || !runOutIndicatorReached && isRunOutActive) {
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)ICampfireBlockMixin.RUNS_OUT, (Comparable)Boolean.valueOf(!isRunOutActive)));
                }
                if (mixinEntity.unlitCampfire$litTime % 20 == 1 && Services.CONFIG.canAddBurnables(mixinEntity.unlitCampfire$isSoulCampfire())) {
                    mixinEntity.method_17510();
                }
            } else {
                mixinEntity.unlitCampfire$litTime = 0;
            }
            int rainUnlitTime = Services.CONFIG.getRainUnlitTime(mixinEntity.unlitCampfire$isSoulCampfire());
            boolean bl = shouldUnlitByRain = rainUnlitTime >= 0 && (!mixinEntity.unlitCampfire$burnsInfinite() || !Services.CONFIG.isInfiniteCampfireIgnoringRain(mixinEntity.unlitCampfire$isSoulCampfire()));
            if (shouldUnlitByRain && level.method_8520(pos.method_10084())) {
                ++mixinEntity.unlitCampfire$rainTime;
                if (mixinEntity.unlitCampfire$rainTime >= rainUnlitTime) {
                    mixinEntity.unlitCampfire$unlitCampfire();
                }
            } else {
                mixinEntity.unlitCampfire$rainTime = 0;
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"cooldownTick"})
    private static void cooldownTickProxy(class_1937 level, class_2338 pos, class_2680 state, class_3924 blockEntity, CallbackInfo info) {
        CampfireBlockEntityMixin mixinEntity = (CampfireBlockEntityMixin)blockEntity;
        if (level != null && mixinEntity != null && !((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            mixinEntity.unlitCampfire$litTime = 0;
            mixinEntity.unlitCampfire$rainTime = 0;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"particleTick"})
    private static void particleTickProxy(class_1937 level, class_2338 pos, class_2680 state, class_3924 blockEntity, CallbackInfo info) {
        CampfireBlockEntityMixin mixinEntity = (CampfireBlockEntityMixin)blockEntity;
        int particleFactor = Services.CONFIG.getRainParticleFactor(mixinEntity.unlitCampfire$isSoulCampfire());
        if (level != null && level.field_9236 && particleFactor > 1 && level.method_8520(pos.method_10084())) {
            for (int i = 0; i < particleFactor - 1; ++i) {
                class_3922.method_17455((class_1937)level, (class_2338)pos, (boolean)((Boolean)state.method_11654((class_2769)class_3922.field_17353)), (boolean)false);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"loadAdditional"})
    protected void loadAdditionalProxy(class_11368 valueInput, CallbackInfo info) {
        valueInput.method_71439("CampfireLitTime").ifPresent(value -> {
            this.unlitCampfire$litTime = value;
        });
    }

    @Inject(at={@At(value="RETURN")}, method={"saveAdditional"})
    protected void saveAdditionalProxy(class_11372 valueOutput, CallbackInfo info) {
        if (valueOutput != null) {
            valueOutput.method_71465("CampfireLitTime", this.unlitCampfire$litTime);
        }
        CommonLoader.addCampfire(this);
    }

    @Inject(at={@At(value="RETURN")}, method={"getUpdateTag"})
    protected void getUpdateTagProxy(CallbackInfoReturnable<class_2487> info) {
        class_2487 compound = (class_2487)info.getReturnValue();
        if (compound != null) {
            compound.method_10569("CampfireLitTime", this.unlitCampfire$litTime);
        }
    }
}

