/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire.platform;

import de.cech12.unlitcampfire.platform.services.IConfigHelper;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;

@Config(name="unlitcampfire")
public class FabricConfigHelper
implements ConfigData,
IConfigHelper {
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public Campfire CAMPFIRE = new Campfire();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public SoulCampfire SOUL_CAMPFIRE = new SoulCampfire();

    @Override
    public void init() {
        AutoConfig.register(FabricConfigHelper.class, Toml4jConfigSerializer::new);
    }

    private FabricConfigHelper getConfig() {
        return (FabricConfigHelper)AutoConfig.getConfigHolder(FabricConfigHelper.class).getConfig();
    }

    @Override
    public int getLitTime(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? Math.clamp((long)config.SOUL_CAMPFIRE.SOUL_CAMPFIRE_LIT_TIME, 0, 2000000) : Math.clamp((long)config.CAMPFIRE.CAMPFIRE_LIT_TIME, 0, 2000000);
    }

    @Override
    public int getRunOutIndicatorTime(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? Math.clamp((long)config.SOUL_CAMPFIRE.SOUL_CAMPFIRE_RUN_OUT_INDICATOR_TIME, 0, 2000000) : Math.clamp((long)config.CAMPFIRE.CAMPFIRE_RUN_OUT_INDICATOR_TIME, 0, 2000000);
    }

    @Override
    public int getRainUnlitTime(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? Math.clamp((long)config.SOUL_CAMPFIRE.SOUL_CAMPFIRE_RAIN_UNLIT_TIME, -1, 2000000) : Math.clamp((long)config.CAMPFIRE.CAMPFIRE_RAIN_UNLIT_TIME, -1, 2000000);
    }

    @Override
    public int getRainParticleFactor(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? Math.clamp((long)config.SOUL_CAMPFIRE.SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR, 1, 10) : Math.clamp((long)config.CAMPFIRE.CAMPFIRE_RAIN_PARTICLE_FACTOR, 1, 10);
    }

    @Override
    public boolean isBreakingWhenUnlitByTime(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? config.SOUL_CAMPFIRE.SOUL_CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME : config.CAMPFIRE.CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME;
    }

    @Override
    public boolean canAddBurnables(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? config.SOUL_CAMPFIRE.SOUL_CAMPFIRE_ADDING_BURNABLES : config.CAMPFIRE.CAMPFIRE_ADDING_BURNABLES;
    }

    @Override
    public int getMaxLitTimeExtension(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? Math.clamp((long)config.SOUL_CAMPFIRE.SOUL_CAMPFIRE_MAX_LIT_TIME, 1, 2000000) : Math.clamp((long)config.CAMPFIRE.CAMPFIRE_MAX_LIT_TIME, 1, 2000000);
    }

    @Override
    public boolean isAffectedBySleepTime(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? config.SOUL_CAMPFIRE.SOUL_CAMPFIRE_AFFECTED_BY_SLEEP_TIME : config.CAMPFIRE.CAMPFIRE_AFFECTED_BY_SLEEP_TIME;
    }

    @Override
    public boolean isGeneratedCampfireLitInfinitely(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? config.SOUL_CAMPFIRE.GENERATED_SOUL_CAMPFIRE_IS_LIT_INFINITELY : config.CAMPFIRE.GENERATED_CAMPFIRE_IS_LIT_INFINITELY;
    }

    @Override
    public boolean isInfiniteCampfireIgnoringRain(boolean isSoulCampfire) {
        FabricConfigHelper config = this.getConfig();
        return isSoulCampfire ? config.SOUL_CAMPFIRE.INFINITE_SOUL_CAMPFIRE_IGNORES_RAIN : config.CAMPFIRE.INFINITE_CAMPFIRE_IGNORES_RAIN;
    }

    public static final class Campfire
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=6)
        public int CAMPFIRE_LIT_TIME = 2000;
        @ConfigEntry.Gui.Tooltip(count=7)
        public int CAMPFIRE_RUN_OUT_INDICATOR_TIME = 600;
        @ConfigEntry.Gui.Tooltip(count=7)
        public int CAMPFIRE_RAIN_UNLIT_TIME = 160;
        @ConfigEntry.Gui.Tooltip(count=6)
        public int CAMPFIRE_RAIN_PARTICLE_FACTOR = 2;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME = false;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean CAMPFIRE_ADDING_BURNABLES = true;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int CAMPFIRE_MAX_LIT_TIME = 2000;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean CAMPFIRE_AFFECTED_BY_SLEEP_TIME = false;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean GENERATED_CAMPFIRE_IS_LIT_INFINITELY = true;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean INFINITE_CAMPFIRE_IGNORES_RAIN = true;

        private Campfire() {
        }
    }

    public static final class SoulCampfire
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=6)
        public int SOUL_CAMPFIRE_LIT_TIME = 2000;
        @ConfigEntry.Gui.Tooltip(count=7)
        public int SOUL_CAMPFIRE_RUN_OUT_INDICATOR_TIME = 600;
        @ConfigEntry.Gui.Tooltip(count=7)
        public int SOUL_CAMPFIRE_RAIN_UNLIT_TIME = -1;
        @ConfigEntry.Gui.Tooltip(count=6)
        public int SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR = 2;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean SOUL_CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME = false;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean SOUL_CAMPFIRE_ADDING_BURNABLES = true;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SOUL_CAMPFIRE_MAX_LIT_TIME = 2000;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean SOUL_CAMPFIRE_AFFECTED_BY_SLEEP_TIME = false;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean GENERATED_SOUL_CAMPFIRE_IS_LIT_INFINITELY = true;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean INFINITE_SOUL_CAMPFIRE_IGNORES_RAIN = true;

        private SoulCampfire() {
        }
    }
}

