/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire.mixin;

import de.cech12.unlitcampfire.ModTags;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import de.cech12.unlitcampfire.platform.Services;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CampfireBlock.class})
public abstract class CampfireBlockMixin
extends BaseEntityBlock
implements ICampfireBlockMixin {
    protected CampfireBlockMixin(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Override
    public int unlitCampfire$getMaxLitTimeExtension(BlockState state) {
        return Services.CONFIG.getMaxLitTimeExtension(state.getBlock() == Blocks.SOUL_CAMPFIRE);
    }

    @Override
    public int unlitCampfire$getMaxLitTime(BlockState state) {
        return Services.CONFIG.getLitTime(state.getBlock() == Blocks.SOUL_CAMPFIRE);
    }

    @Override
    public int unlitCampfire$getRunsOutIndicatorTime(BlockState state) {
        return Services.CONFIG.getRunOutIndicatorTime(state.getBlock() == Blocks.SOUL_CAMPFIRE);
    }

    @Override
    public boolean unlitCampfire$burnsInfinite(BlockState state) {
        return (Boolean)state.getValue((Property)ICampfireBlockMixin.INFINITE) != false || this.unlitCampfire$getMaxLitTime(state) < 1;
    }

    @Unique
    private boolean unlitCampfire$canAddBurnables(BlockState state) {
        return (Boolean)state.getValue((Property)ICampfireBlockMixin.INFINITE) == false && Services.CONFIG.canAddBurnables(state.getBlock() == Blocks.SOUL_CAMPFIRE);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>*"})
    protected void initProxy(boolean spawnParticles, int fireDamage, BlockBehaviour.Properties properties, CallbackInfo info) {
        BlockState defaultState = (BlockState)this.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
        if (defaultState.hasProperty((Property)ICampfireBlockMixin.INFINITE)) {
            defaultState.setValue((Property)ICampfireBlockMixin.INFINITE, (Comparable)Boolean.valueOf(false));
        }
        if (defaultState.hasProperty((Property)ICampfireBlockMixin.RUNS_OUT)) {
            defaultState.setValue((Property)ICampfireBlockMixin.RUNS_OUT, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(defaultState);
    }

    @Inject(at={@At(value="RETURN")}, method={"getStateForPlacement"}, cancellable=true)
    protected void getStateForPlacementProxy(BlockPlaceContext context, CallbackInfoReturnable<BlockState> cir) {
        if (cir.getReturnValue() != null) {
            cir.setReturnValue((Object)((BlockState)((BlockState)((BlockState)((BlockState)cir.getReturnValue()).setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)ICampfireBlockMixin.INFINITE, (Comparable)Boolean.valueOf(false))).setValue((Property)ICampfireBlockMixin.RUNS_OUT, (Comparable)Boolean.valueOf(false))));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"useItemOn"}, cancellable=true)
    protected void useProxy(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (((InteractionResult)cir.getReturnValue()).consumesAction()) {
            return;
        }
        if (!((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue() || this.unlitCampfire$burnsInfinite(state)) {
            return;
        }
        if (stack.is(ModTags.Items.MAKES_CAMPFIRE_INFINITE)) {
            if (level instanceof ServerLevel) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ICampfireBlockMixin.INFINITE, (Comparable)Boolean.valueOf(true)), 3);
                player.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                cir.setReturnValue((Object)InteractionResult.SUCCESS_SERVER);
            } else {
                cir.setReturnValue((Object)InteractionResult.CONSUME);
            }
            cir.cancel();
        } else {
            ICampfireBlockEntityMixin campfireBlockEntityMixin;
            if (!this.unlitCampfire$canAddBurnables(state)) {
                return;
            }
            if (stack.getItem() instanceof ShovelItem) {
                return;
            }
            int burnTime = Services.PLATFORM.getBurnTimeOf(level, stack);
            if (burnTime < 1) {
                return;
            }
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof ICampfireBlockEntityMixin && (campfireBlockEntityMixin = (ICampfireBlockEntityMixin)blockentity).unlitCampfire$addLitTime(burnTime)) {
                if (level instanceof ServerLevel) {
                    player.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    cir.setReturnValue((Object)InteractionResult.SUCCESS_SERVER);
                } else {
                    cir.setReturnValue((Object)InteractionResult.CONSUME);
                }
                cir.cancel();
            }
        }
        if (!player.getAbilities().instabuild && ((InteractionResult)cir.getReturnValue()).consumesAction()) {
            ItemStack remainingStack = Services.PLATFORM.getRemainingStackAfterUsage(stack);
            if (remainingStack != ItemStack.EMPTY) {
                player.setItemInHand(hand, remainingStack);
            } else {
                stack.shrink(1);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"createBlockStateDefinition"})
    protected void createBlockStateDefinitionProxy(StateDefinition.Builder<Block, BlockState> stateBuilder, CallbackInfo info) {
        stateBuilder.add(new Property[]{INFINITE, RUNS_OUT});
    }

    @Intrinsic(displace=true)
    public void id$animateTick(@Nonnull BlockState stateIn, Level worldIn, BlockPos pos, @Nonnull RandomSource rand) {
        int particleFactor = 1;
        if (worldIn.isRainingAt(pos.above())) {
            particleFactor = Services.CONFIG.getRainParticleFactor(worldIn.getBlockState(pos).getBlock() == Blocks.SOUL_CAMPFIRE);
        }
        for (int i = 0; i < particleFactor; ++i) {
            this.animateTick(stateIn, worldIn, pos, rand);
        }
    }
}

