/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire.compat;

import de.cech12.unlitcampfire.Constants;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin,
IServerDataProvider<BlockAccessor> {
    public ResourceLocation getUid() {
        return Constants.id("campfireinfo");
    }

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)this, CampfireBlockEntity.class);
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        BlockState blockState = blockAccessor.getBlockState();
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof ICampfireBlockEntityMixin) {
            ICampfireBlockEntityMixin campfireBlockEntity = (ICampfireBlockEntityMixin)blockEntity;
            blockEntity = blockState.getBlock();
            if (blockEntity instanceof ICampfireBlockMixin) {
                ICampfireBlockMixin campfireBlock = (ICampfireBlockMixin)blockEntity;
                data.putBoolean("BurnsInfinite", campfireBlock.unlitCampfire$burnsInfinite(blockState));
                data.putInt("MaxLitTime", campfireBlock.unlitCampfire$getMaxLitTime(blockState));
                if (!campfireBlock.unlitCampfire$burnsInfinite(blockState)) {
                    data.putInt("LitTime", campfireBlockEntity.unlitCampfire$getLitTime());
                }
            }
        }
    }
}

