/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire.mixin;

import de.cech12.unlitcampfire.CommonLoader;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import de.cech12.unlitcampfire.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CampfireBlockEntity.class})
public abstract class CampfireBlockEntityMixin
extends BlockEntity
implements ICampfireBlockEntityMixin {
    @Unique
    private Boolean unlitCampfire$isSoulCampfire;
    @Unique
    private int unlitCampfire$litTime = 0;
    @Unique
    private int unlitCampfire$rainTime = 0;

    @Shadow
    protected abstract void markUpdated();

    public CampfireBlockEntityMixin(BlockPos pos, BlockState state) {
        super(BlockEntityType.CAMPFIRE, pos, state);
        CommonLoader.addCampfire(this);
    }

    @Override
    public boolean unlitCampfire$isSoulCampfire() {
        if (this.unlitCampfire$isSoulCampfire == null) {
            if (this.level != null) {
                this.unlitCampfire$isSoulCampfire = this.level.getBlockState(this.worldPosition).getBlock() == Blocks.SOUL_CAMPFIRE;
                return this.unlitCampfire$isSoulCampfire;
            }
            return false;
        }
        return this.unlitCampfire$isSoulCampfire;
    }

    @Unique
    private int unlitCampfire$getMaxLitTime() {
        return ((ICampfireBlockMixin)this.getBlockState().getBlock()).unlitCampfire$getMaxLitTime(this.getBlockState());
    }

    @Unique
    private int unlitCampfire$getMaxLitTimeExtension() {
        return ((ICampfireBlockMixin)this.getBlockState().getBlock()).unlitCampfire$getMaxLitTimeExtension(this.getBlockState());
    }

    @Unique
    private int unlitCampfire$getRunsOutIndicator() {
        return ((ICampfireBlockMixin)this.getBlockState().getBlock()).unlitCampfire$getRunsOutIndicatorTime(this.getBlockState());
    }

    @Unique
    private boolean unlitCampfire$burnsInfinite() {
        return ((ICampfireBlockMixin)this.getBlockState().getBlock()).unlitCampfire$burnsInfinite(this.getBlockState());
    }

    @Unique
    private void unlitCampfire$playUnlitSound() {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.levelEvent(null, 1009, this.getBlockPos(), 0);
        }
    }

    @Unique
    private void unlitCampfire$destroyCampfire() {
        if (this.level != null) {
            this.unlitCampfire$playUnlitSound();
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
        }
    }

    @Unique
    private void unlitCampfire$unlitCampfire() {
        if (this.level != null) {
            this.unlitCampfire$playUnlitSound();
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ICampfireBlockMixin.RUNS_OUT, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public int unlitCampfire$getLitTime() {
        return this.unlitCampfire$litTime;
    }

    @Override
    public boolean unlitCampfire$addLitTime(int litTimeToAdd) {
        if (this.unlitCampfire$burnsInfinite()) {
            return false;
        }
        if (litTimeToAdd < 0) {
            return this.unlitCampfire$removeLitTime(-litTimeToAdd);
        }
        if (this.unlitCampfire$litTime <= -this.unlitCampfire$getMaxLitTimeExtension() || !((Boolean)this.getBlockState().getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            return false;
        }
        this.unlitCampfire$litTime -= litTimeToAdd;
        this.markUpdated();
        return true;
    }

    @Override
    public boolean unlitCampfire$removeLitTime(int litTimeToRemove) {
        if (this.unlitCampfire$burnsInfinite()) {
            return false;
        }
        if (litTimeToRemove < 0) {
            return this.unlitCampfire$addLitTime(-litTimeToRemove);
        }
        if (this.unlitCampfire$litTime >= this.unlitCampfire$getMaxLitTime() || !((Boolean)this.getBlockState().getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            return false;
        }
        this.unlitCampfire$litTime += litTimeToRemove;
        this.markUpdated();
        return true;
    }

    @Inject(at={@At(value="RETURN")}, method={"cookTick"})
    private static void cookTickProxy(ServerLevel level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> cachedRecipe, CallbackInfo info) {
        CampfireBlockEntityMixin mixinEntity = (CampfireBlockEntityMixin)blockEntity;
        if (level != null && mixinEntity != null && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            boolean shouldUnlitByRain;
            if (!mixinEntity.unlitCampfire$burnsInfinite()) {
                ++mixinEntity.unlitCampfire$litTime;
                if (mixinEntity.unlitCampfire$litTime >= mixinEntity.unlitCampfire$getMaxLitTime()) {
                    if (Services.CONFIG.isBreakingWhenUnlitByTime(mixinEntity.unlitCampfire$isSoulCampfire())) {
                        mixinEntity.unlitCampfire$destroyCampfire();
                    } else {
                        mixinEntity.unlitCampfire$unlitCampfire();
                    }
                    return;
                }
                boolean runOutIndicatorReached = mixinEntity.unlitCampfire$litTime >= mixinEntity.unlitCampfire$getMaxLitTime() - mixinEntity.unlitCampfire$getRunsOutIndicator();
                boolean isRunOutActive = (Boolean)state.getValue((Property)ICampfireBlockMixin.RUNS_OUT);
                if (runOutIndicatorReached && !isRunOutActive || !runOutIndicatorReached && isRunOutActive) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ICampfireBlockMixin.RUNS_OUT, (Comparable)Boolean.valueOf(!isRunOutActive)));
                }
                if (mixinEntity.unlitCampfire$litTime % 20 == 1 && Services.CONFIG.canAddBurnables(mixinEntity.unlitCampfire$isSoulCampfire())) {
                    mixinEntity.markUpdated();
                }
            } else {
                mixinEntity.unlitCampfire$litTime = 0;
            }
            int rainUnlitTime = Services.CONFIG.getRainUnlitTime(mixinEntity.unlitCampfire$isSoulCampfire());
            boolean bl = shouldUnlitByRain = rainUnlitTime >= 0 && (!mixinEntity.unlitCampfire$burnsInfinite() || !Services.CONFIG.isInfiniteCampfireIgnoringRain(mixinEntity.unlitCampfire$isSoulCampfire()));
            if (shouldUnlitByRain && level.isRainingAt(pos.above())) {
                ++mixinEntity.unlitCampfire$rainTime;
                if (mixinEntity.unlitCampfire$rainTime >= rainUnlitTime) {
                    mixinEntity.unlitCampfire$unlitCampfire();
                }
            } else {
                mixinEntity.unlitCampfire$rainTime = 0;
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"cooldownTick"})
    private static void cooldownTickProxy(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo info) {
        CampfireBlockEntityMixin mixinEntity = (CampfireBlockEntityMixin)blockEntity;
        if (level != null && mixinEntity != null && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            mixinEntity.unlitCampfire$litTime = 0;
            mixinEntity.unlitCampfire$rainTime = 0;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"particleTick"})
    private static void particleTickProxy(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo info) {
        CampfireBlockEntityMixin mixinEntity = (CampfireBlockEntityMixin)blockEntity;
        int particleFactor = Services.CONFIG.getRainParticleFactor(mixinEntity.unlitCampfire$isSoulCampfire());
        if (level != null && level.isClientSide() && particleFactor > 1 && level.isRainingAt(pos.above())) {
            for (int i = 0; i < particleFactor - 1; ++i) {
                CampfireBlock.makeParticles((Level)level, (BlockPos)pos, (boolean)((Boolean)state.getValue((Property)CampfireBlock.SIGNAL_FIRE)), (boolean)false);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"loadAdditional"})
    protected void loadAdditionalProxy(ValueInput valueInput, CallbackInfo info) {
        valueInput.getInt("CampfireLitTime").ifPresent(value -> {
            this.unlitCampfire$litTime = value;
        });
    }

    @Inject(at={@At(value="RETURN")}, method={"saveAdditional"})
    protected void saveAdditionalProxy(ValueOutput valueOutput, CallbackInfo info) {
        if (valueOutput != null) {
            valueOutput.putInt("CampfireLitTime", this.unlitCampfire$litTime);
        }
        CommonLoader.addCampfire(this);
    }

    @Inject(at={@At(value="RETURN")}, method={"getUpdateTag"})
    protected void getUpdateTagProxy(CallbackInfoReturnable<CompoundTag> info) {
        CompoundTag compound = (CompoundTag)info.getReturnValue();
        if (compound != null) {
            compound.putInt("CampfireLitTime", this.unlitCampfire$litTime);
        }
    }
}

