/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire.platform;

import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import de.cech12.unlitcampfire.platform.Services;
import de.cech12.unlitcampfire.platform.services.IConfigHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="unlitcampfire")
public class NeoForgeConfigHelper
implements IConfigHelper {
    private static final ModConfigSpec SERVER_CONFIG;
    public static final ModConfigSpec.IntValue CAMPFIRE_LIT_TIME;
    public static final ModConfigSpec.IntValue CAMPFIRE_RUN_OUT_INDICATOR_TIME;
    public static final ModConfigSpec.IntValue CAMPFIRE_RAIN_UNLIT_TIME;
    public static final ModConfigSpec.IntValue CAMPFIRE_RAIN_PARTICLE_FACTOR;
    public static final ModConfigSpec.BooleanValue CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME;
    public static final ModConfigSpec.BooleanValue CAMPFIRE_ADDING_BURNABLES;
    public static final ModConfigSpec.IntValue CAMPFIRE_MAX_LIT_TIME_EXTENSION;
    public static final ModConfigSpec.BooleanValue CAMPFIRE_AFFECTED_BY_SLEEP_TIME;
    public static final ModConfigSpec.BooleanValue GENERATED_CAMPFIRE_IS_LIT_INFINITELY;
    public static final ModConfigSpec.BooleanValue INFINITE_CAMPFIRE_IGNORES_RAIN;
    public static final ModConfigSpec.IntValue SOUL_CAMPFIRE_LIT_TIME;
    public static final ModConfigSpec.IntValue SOUL_CAMPFIRE_RUN_OUT_INDICATOR_TIME;
    public static final ModConfigSpec.IntValue SOUL_CAMPFIRE_RAIN_UNLIT_TIME;
    public static final ModConfigSpec.IntValue SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR;
    public static final ModConfigSpec.BooleanValue SOUL_CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME;
    public static final ModConfigSpec.BooleanValue SOUL_CAMPFIRE_ADDING_BURNABLES;
    public static final ModConfigSpec.IntValue SOUL_CAMPFIRE_MAX_LIT_TIME_EXTENSION;
    public static final ModConfigSpec.BooleanValue SOUL_CAMPFIRE_AFFECTED_BY_SLEEP_TIME;
    public static final ModConfigSpec.BooleanValue GENERATED_SOUL_CAMPFIRE_IS_LIT_INFINITELY;
    public static final ModConfigSpec.BooleanValue INFINITE_SOUL_CAMPFIRE_IGNORES_RAIN;

    @Override
    public void init() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    @Override
    public int getLitTime(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Integer)SOUL_CAMPFIRE_LIT_TIME.get() : (Integer)CAMPFIRE_LIT_TIME.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? 2000 : 2000;
        }
    }

    @Override
    public int getRunOutIndicatorTime(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Integer)SOUL_CAMPFIRE_RUN_OUT_INDICATOR_TIME.get() : (Integer)CAMPFIRE_RUN_OUT_INDICATOR_TIME.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? 600 : 600;
        }
    }

    @Override
    public int getRainUnlitTime(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Integer)SOUL_CAMPFIRE_RAIN_UNLIT_TIME.get() : (Integer)CAMPFIRE_RAIN_UNLIT_TIME.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? -1 : 160;
        }
    }

    @Override
    public int getRainParticleFactor(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Integer)SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR.get() : (Integer)CAMPFIRE_RAIN_PARTICLE_FACTOR.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? 2 : 2;
        }
    }

    @Override
    public boolean isBreakingWhenUnlitByTime(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Boolean)SOUL_CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME.get() : (Boolean)CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? false : false;
        }
    }

    @Override
    public boolean canAddBurnables(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Boolean)SOUL_CAMPFIRE_ADDING_BURNABLES.get() : (Boolean)CAMPFIRE_ADDING_BURNABLES.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? true : true;
        }
    }

    @Override
    public int getMaxLitTimeExtension(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Integer)SOUL_CAMPFIRE_MAX_LIT_TIME_EXTENSION.get() : (Integer)CAMPFIRE_MAX_LIT_TIME_EXTENSION.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? 2000 : 2000;
        }
    }

    @Override
    public boolean isAffectedBySleepTime(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Boolean)SOUL_CAMPFIRE_AFFECTED_BY_SLEEP_TIME.get() : (Boolean)CAMPFIRE_AFFECTED_BY_SLEEP_TIME.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? false : false;
        }
    }

    @Override
    public boolean isGeneratedCampfireLitInfinitely(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Boolean)GENERATED_SOUL_CAMPFIRE_IS_LIT_INFINITELY.get() : (Boolean)GENERATED_CAMPFIRE_IS_LIT_INFINITELY.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? true : true;
        }
    }

    @Override
    public boolean isInfiniteCampfireIgnoringRain(boolean isSoulCampfire) {
        try {
            return isSoulCampfire ? (Boolean)INFINITE_SOUL_CAMPFIRE_IGNORES_RAIN.get() : (Boolean)INFINITE_CAMPFIRE_IGNORES_RAIN.get();
        }
        catch (IllegalStateException ex) {
            return isSoulCampfire ? true : true;
        }
    }

    private static void setGeneratedCampfireIsLitInfinitely(Block block, boolean litInfinitely) {
        block.registerDefaultState((BlockState)((BlockState)block.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(litInfinitely))).setValue((Property)ICampfireBlockMixin.INFINITE, (Comparable)Boolean.valueOf(litInfinitely)));
    }

    private static void loadChangedConfigData(ModConfigEvent configEvent) {
        if (!configEvent.getConfig().getModId().equals("unlitcampfire")) {
            return;
        }
        NeoForgeConfigHelper.setGeneratedCampfireIsLitInfinitely(Blocks.CAMPFIRE, Services.CONFIG.isGeneratedCampfireLitInfinitely(false));
        NeoForgeConfigHelper.setGeneratedCampfireIsLitInfinitely(Blocks.SOUL_CAMPFIRE, Services.CONFIG.isGeneratedCampfireLitInfinitely(true));
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        NeoForgeConfigHelper.loadChangedConfigData((ModConfigEvent)configEvent);
    }

    @SubscribeEvent
    public static void onChange(ModConfigEvent.Reloading configEvent) {
        NeoForgeConfigHelper.loadChangedConfigData((ModConfigEvent)configEvent);
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("unlitcampfire");
        CAMPFIRE_LIT_TIME = builder.comment("The time (ticks) a campfire burns until it goes out by itself. (2000 ticks default; 0 means it burns forever)").defineInRange("campfireLitTime", 2000, 0, 2000000);
        CAMPFIRE_RUN_OUT_INDICATOR_TIME = builder.comment("The light level of a campfire decreases when the remaining time (ticks) is lower than this configured value. (600 ticks default; 0 deactivates this behaviour)").defineInRange("campfireRunOutIndicatorTime", 600, 0, 2000000);
        CAMPFIRE_RAIN_UNLIT_TIME = builder.comment("The time (ticks) a campfire burns until it goes out during rain. (160 ticks [default]; 0: it goes out immediately; -1: it burns during rain).").defineInRange("campfireRainUnlitTime", 160, -1, 2000000);
        CAMPFIRE_RAIN_PARTICLE_FACTOR = builder.comment("The Factor of particle count of a campfire during rain. (2: doubled particles count [default]; 1: same particle count)").defineInRange("campfireRainParticleFactor", 2, 1, 10);
        CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME = builder.comment("Whether a campfire should be destroyed when it goes out by itself.").define("campfireBreaksWhenUnlitByTime", false);
        CAMPFIRE_ADDING_BURNABLES = builder.comment("Whether the lit time of a campfire could be extended with combustible/burnable items.").define("campfireAddingBurnables", true);
        CAMPFIRE_MAX_LIT_TIME_EXTENSION = builder.comment("The time (ticks) a campfire can be filled up additionally until adding burnables is not possible. (is added to the configured lit time) (2000 ticks default)").defineInRange("campfireMaxLitTimeExtension", 2000, 1, 2000000);
        CAMPFIRE_AFFECTED_BY_SLEEP_TIME = builder.comment("Whether the lit time of a campfire should be affected by the sleep time.").define("campfireAffectedBySleepTime", false);
        GENERATED_CAMPFIRE_IS_LIT_INFINITELY = builder.comment("Whether generated campfires should be lit infinitely.").define("generatedCampfireIsLitInfinitely", true);
        INFINITE_CAMPFIRE_IGNORES_RAIN = builder.comment("Whether infinite campfires should stay lit in rain.").define("infiniteCampfireIgnoresRain", true);
        SOUL_CAMPFIRE_LIT_TIME = builder.comment("The time (ticks) a soul campfire burns until it goes out by itself. (2000 ticks default; 0 means it burns forever)").defineInRange("soulCampfireLitTime", 2000, 0, 2000000);
        SOUL_CAMPFIRE_RUN_OUT_INDICATOR_TIME = builder.comment("The light level of a soul campfire decreases when the remaining time (ticks) is lower than this configured value. (600 ticks default; 0 deactivates this behaviour)").defineInRange("soulCampfireRunOutIndicatorTime", 600, 0, 2000000);
        SOUL_CAMPFIRE_RAIN_UNLIT_TIME = builder.comment("The time (ticks) a soul campfire burns until it goes out during rain. (-1 ticks [default]; 0: it goes out immediately; -1: it burns during rain).").defineInRange("soulCampfireRainUnlitTime", -1, -1, 2000000);
        SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR = builder.comment("The Factor of particle count of a soul campfire during rain. (2: doubled particles count [default]; 1: same particle count)").defineInRange("soulCampfireRainParticleFactor", 2, 1, 10);
        SOUL_CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME = builder.comment("Whether a soul campfire should be destroyed when it goes out by itself.").define("soulCampfireBreaksWhenUnlitByTime", false);
        SOUL_CAMPFIRE_ADDING_BURNABLES = builder.comment("Whether the lit time of a soul campfire could be extended with combustible/burnable items.").define("soulCampfireAddingBurnables", true);
        SOUL_CAMPFIRE_MAX_LIT_TIME_EXTENSION = builder.comment("The time (ticks) a soul campfire can be filled up additionally until adding burnables is not possible. (is added to the configured lit time) (2000 ticks default)").defineInRange("soulCampfireMaxLitTimeExtension", 2000, 1, 2000000);
        SOUL_CAMPFIRE_AFFECTED_BY_SLEEP_TIME = builder.comment("Whether the lit time of a soul campfire should be affected by the sleep time.").define("soulCampfireAffectedBySleepTime", false);
        GENERATED_SOUL_CAMPFIRE_IS_LIT_INFINITELY = builder.comment("Whether generated soul campfires should be lit infinitely.").define("generatedSoulCampfireIsLitInfinitely", true);
        INFINITE_SOUL_CAMPFIRE_IGNORES_RAIN = builder.comment("Whether infinite soul campfires should stay lit in rain.").define("infiniteSoulCampfireIgnoresRain", true);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

