/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.unlitcampfire;

import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import de.cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import de.cech12.unlitcampfire.platform.Services;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class CommonLoader {
    private static final Set<BlockEntity> CAMPFIRES = new HashSet<BlockEntity>();

    public static void init() {
        Services.CONFIG.init();
    }

    private CommonLoader() {
    }

    public static void addCampfire(BlockEntity blockEntity) {
        if (blockEntity != null && blockEntity.getLevel() != null && !blockEntity.getLevel().isClientSide) {
            CAMPFIRES.add(blockEntity);
        }
    }

    public static void updateCampfiresAfterSleep(int sleepTime) {
        CAMPFIRES.removeIf(Objects::isNull);
        CAMPFIRES.removeIf(BlockEntity::isRemoved);
        CAMPFIRES.removeIf(campfire -> !(campfire instanceof ICampfireBlockEntityMixin));
        CAMPFIRES.stream().filter(campfire -> campfire.getBlockState().hasProperty((Property)CampfireBlock.LIT) && (Boolean)campfire.getBlockState().getValue((Property)CampfireBlock.LIT) != false).filter(campfire -> campfire.getBlockState().hasProperty((Property)ICampfireBlockMixin.INFINITE) && (Boolean)campfire.getBlockState().getValue((Property)ICampfireBlockMixin.INFINITE) == false).map(campfire -> (ICampfireBlockEntityMixin)campfire).filter(campfire -> Services.CONFIG.isAffectedBySleepTime(campfire.unlitCampfire$isSoulCampfire())).forEach(campfire -> campfire.unlitCampfire$removeLitTime(sleepTime));
    }
}

