/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.block.custom;

import com.mojang.serialization.MapCodec;
import dragomordor.simpletms.block.SimpleTMsBlockItems;
import dragomordor.simpletms.block.entity.TMMachineBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 @2\u00020\u0001:\u0001@B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\u000e\u001a\u00020\r2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J9\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ?\u0010$\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b$\u0010%J/\u0010(\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b(\u0010)J7\u0010.\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020,H\u0014\u00a2\u0006\u0004\b.\u0010/J!\u00101\u001a\u0004\u0018\u0001002\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b1\u00102J\u0017\u00104\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b4\u00105J7\u00109\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010'\u001a\u00020&2\u0006\u00107\u001a\u000206H\u0014\u00a2\u0006\u0004\b9\u0010:J/\u0010>\u001a\u00020=2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020;2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020<H\u0014\u00a2\u0006\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Ldragomordor/simpletms/block/custom/TMMachineBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "context", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "state", "Lnet/minecraft/world/entity/LivingEntity;", "placer", "Lnet/minecraft/world/item/ItemStack;", "stack", "setPlacedBy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/entity/player/Player;", "player", "playerWillDestroy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/level/block/state/BlockState;", "world", "newState", "", "moved", "onRemove", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "newBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lnet/minecraft/world/phys/BlockHitResult;", "hitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Companion", "common"})
public final class TMMachineBlock
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<TMMachineBlock> CODEC;
    @NotNull
    private static final EnumProperty<Direction> FACING;
    @NotNull
    private static final EnumProperty<DoubleBlockHalf> HALF;
    @NotNull
    private static final VoxelShape SHAPE_LOWER;
    @NotNull
    private static final VoxelShape SHAPE_UPPER;

    public TMMachineBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{FACING, HALF};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        level.setBlock(pos.above(), (BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)HALF);
        if (direction.getAxis() == Direction.Axis.Y) {
            boolean shouldCheckBelow;
            boolean isLower = half == DoubleBlockHalf.LOWER;
            boolean shouldCheckAbove = isLower && direction == Direction.UP;
            boolean bl = shouldCheckBelow = !isLower && direction == Direction.DOWN;
            if (!(!shouldCheckAbove && !shouldCheckBelow || neighborState.is((Block)this) && neighborState.getValue((Property)HALF) != half)) {
                BlockState blockState = Blocks.AIR.defaultBlockState();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
                return blockState;
            }
        }
        BlockState blockState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!level.isClientSide) {
            BlockPos otherPos;
            BlockState otherState;
            TMMachineBlockEntity be;
            DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)HALF);
            BlockPos lowerPos = half == DoubleBlockHalf.LOWER ? pos : pos.below();
            BlockEntity blockEntity = level.getBlockEntity(lowerPos);
            TMMachineBlockEntity tMMachineBlockEntity = be = blockEntity instanceof TMMachineBlockEntity ? (TMMachineBlockEntity)blockEntity : null;
            if (player.isCreative()) {
                TMMachineBlockEntity tMMachineBlockEntity2 = be;
                if (tMMachineBlockEntity2 != null) {
                    tMMachineBlockEntity2.markCreativeDestruction();
                }
            }
            if ((otherState = level.getBlockState(otherPos = half == DoubleBlockHalf.LOWER ? pos.above() : pos.below())).is((Block)this) && otherState.getValue((Property)HALF) != half) {
                level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(player, 2001, otherPos, BaseEntityBlock.getId((BlockState)otherState));
            }
        }
        BlockState blockState = super.playerWillDestroy(level, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moved) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock())) {
            if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
                TMMachineBlockEntity blockEntity;
                BlockEntity blockEntity2 = world.getBlockEntity(pos);
                TMMachineBlockEntity tMMachineBlockEntity = blockEntity = blockEntity2 instanceof TMMachineBlockEntity ? (TMMachineBlockEntity)blockEntity2 : null;
                if (blockEntity != null) {
                    blockEntity.dropContents(world, pos);
                    if (!blockEntity.wasCreativeDestruction()) {
                        ItemStack blockItem = ((BlockItem)SimpleTMsBlockItems.INSTANCE.getTM_MACHINE().get()).getDefaultInstance();
                        Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)blockItem);
                    }
                }
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? (BlockEntity)new TMMachineBlockEntity(pos, state) : null;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos lowerPos = state.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? pos : pos.below();
        BlockEntity blockEntity = level.getBlockEntity(lowerPos);
        if (blockEntity instanceof TMMachineBlockEntity && player instanceof ServerPlayer) {
            ((TMMachineBlockEntity)blockEntity).openMenu((ServerPlayer)player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER : SHAPE_UPPER;
    }

    static {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(TMMachineBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
        DirectionProperty directionProperty = HorizontalDirectionalBlock.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = (EnumProperty)directionProperty;
        EnumProperty enumProperty = BlockStateProperties.DOUBLE_BLOCK_HALF;
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"DOUBLE_BLOCK_HALF");
        HALF = enumProperty;
        VoxelShape voxelShape = Shapes.block();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"block(...)");
        SHAPE_LOWER = voxelShape;
        VoxelShape voxelShape2 = Shapes.block();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"block(...)");
        SHAPE_UPPER = voxelShape2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\n8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Ldragomordor/simpletms/block/custom/TMMachineBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Ldragomordor/simpletms/block/custom/TMMachineBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/core/Direction;", "FACING", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/level/block/state/properties/DoubleBlockHalf;", "HALF", "getHALF", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "SHAPE_LOWER", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "SHAPE_UPPER", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<TMMachineBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final EnumProperty<Direction> getFACING() {
            return FACING;
        }

        @NotNull
        public final EnumProperty<DoubleBlockHalf> getHALF() {
            return HALF;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

