/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.item.custom;

import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.api.pokemon.moves.LearnsetQuery;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import dev.architectury.registry.menu.MenuRegistry;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.api.MoveCaseHelper;
import dragomordor.simpletms.api.MoveCaseStorage;
import dragomordor.simpletms.config.SimpleTMsConfig;
import dragomordor.simpletms.item.SimpleTMsItem;
import dragomordor.simpletms.ui.MoveCaseMenu;
import dragomordor.simpletms.ui.PokemonFilterData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u00011B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ+\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0018\u00a2\u0006\u0004\b!\u0010\"J5\u0010*\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010-\u001a\u00020,H\u0002\u00a2\u0006\u0004\b-\u0010.R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010/\u001a\u0004\b\u0003\u00100\u00a8\u00062"}, d2={"Ldragomordor/simpletms/item/custom/MoveCaseItem;", "Ldragomordor/simpletms/item/SimpleTMsItem;", "", "isTR", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(ZLnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "usedHand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "stack", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lnet/minecraft/world/InteractionResult;", "interactLivingEntity", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/server/level/ServerPlayer;", "", "openPartySelect", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "isFreshSelection", "openMenu", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;Z)V", "openMenuWithFreshSelection", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Lnet/minecraft/world/item/Item$TooltipContext;", "context", "", "Lnet/minecraft/network/chat/Component;", "tooltipComponents", "Lnet/minecraft/world/item/TooltipFlag;", "tooltipFlag", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "", "getStoredCountForTooltip", "()I", "Z", "()Z", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nMoveCaseItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveCaseItem.kt\ndragomordor/simpletms/item/custom/MoveCaseItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,400:1\n774#2:401\n865#2,2:402\n2423#2,14:404\n*S KotlinDebug\n*F\n+ 1 MoveCaseItem.kt\ndragomordor/simpletms/item/custom/MoveCaseItem\n*L\n57#1:401\n57#1:402,2\n58#1:404,14\n*E\n"})
public final class MoveCaseItem
extends SimpleTMsItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isTR;

    public MoveCaseItem(boolean isTR, @NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.isTR = isTR;
    }

    public final boolean isTR() {
        return this.isTR;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack stack = player.getItemInHand(usedHand);
        if (level instanceof ServerLevel && player instanceof ServerPlayer) {
            PokemonEntity entity;
            Object v3;
            void $this$minByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Pair pair = PlayerExtensionsKt.getBattleState((ServerPlayer)((ServerPlayer)player));
            if (pair != null) {
                Pair it = pair;
                boolean bl = false;
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            List list = player.level().getEntities((Entity)player, AABB.ofSize((Vec3)player.position(), (double)16.0, (double)16.0, (double)16.0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
            Iterable it = list;
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entity it2 = (Entity)element$iv$iv;
                boolean bl = false;
                Entity entity2 = (Entity)player;
                Intrinsics.checkNotNull((Object)it2);
                if (!PlayerExtensionsKt.isLookingAt$default((Entity)entity2, (Entity)it2, (float)0.0f, (float)0.1f, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = minElem$iv;
                } else {
                    Entity it3 = (Entity)minElem$iv;
                    boolean bl = false;
                    float minValue$iv = it3.distanceTo((Entity)player);
                    do {
                        Object e$iv = iterator$iv.next();
                        Entity it4 = (Entity)e$iv;
                        $i$a$-minByOrNull-MoveCaseItem$use$entity$2 = false;
                        float v$iv = it4.distanceTo((Entity)player);
                        if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = minElem$iv;
                }
            }
            Object var6_23 = v3;
            PokemonEntity pokemonEntity = entity = var6_23 instanceof PokemonEntity ? (PokemonEntity)var6_23 : null;
            if (entity != null && Intrinsics.areEqual((Object)entity.getOwnerUUID(), (Object)((ServerPlayer)player).getUUID())) {
                MoveCaseItem.openMenu$default(this, (ServerPlayer)player, entity.getPokemon(), false, 4, null);
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
                return interactionResultHolder;
            }
            if (((ServerPlayer)player).isShiftKeyDown()) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Intrinsics.checkNotNull((Object)stack);
                this.openPartySelect(serverPlayer, stack);
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
                return interactionResultHolder;
            }
            MoveCaseItem.openMenu$default(this, (ServerPlayer)player, null, false, 4, null);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (entity instanceof PokemonEntity && player instanceof ServerPlayer) {
            Pair pair = PlayerExtensionsKt.getBattleState((ServerPlayer)((ServerPlayer)player));
            if (pair != null) {
                Pair it = pair;
                boolean bl = false;
                return InteractionResult.FAIL;
            }
            if (Intrinsics.areEqual((Object)((PokemonEntity)entity).getOwnerUUID(), (Object)((ServerPlayer)player).getUUID())) {
                MoveCaseItem.openMenu$default(this, (ServerPlayer)player, ((PokemonEntity)entity).getPokemon(), false, 4, null);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private final void openPartySelect(ServerPlayer player, ItemStack stack) {
        List party = CollectionsKt.toList((Iterable)((Iterable)PlayerExtensionsKt.party((ServerPlayer)player)));
        if (party.isEmpty()) {
            MoveCaseItem.openMenu$default(this, player, null, false, 4, null);
            return;
        }
        PartySelectCallbacks.createFromPokemon$default((PartySelectCallbacks)PartySelectCallbacks.INSTANCE, (ServerPlayer)player, null, (List)party, MoveCaseItem::openPartySelect$lambda$4, null, arg_0 -> MoveCaseItem.openPartySelect$lambda$5(this, player, arg_0), (int)18, null);
    }

    private final void openMenu(ServerPlayer player, Pokemon pokemon, boolean isFreshSelection) {
        MoveCaseStorage storage = MoveCaseStorage.Companion.get(player);
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        Map<String, Integer> storedMoves = storage.getStoredQuantities(uUID, this.isTR);
        Pokemon filterPokemon = pokemon;
        MoveCaseStorage.SelectedPokemonInfo savedPokemonInfo = null;
        if (pokemon != null) {
            Set<String> learnableMoves = Companion.getLearnableMoves(pokemon, this.isTR);
            String string = pokemon.getSpecies().getResourceIdentifier().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = pokemon.getForm().getName();
            String string3 = pokemon.getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            MoveCaseStorage.SelectedPokemonInfo newInfo = new MoveCaseStorage.SelectedPokemonInfo(string, string2, string3, learnableMoves);
            UUID uUID2 = player.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            storage.setSelectedPokemon(uUID2, this.isTR, newInfo);
            savedPokemonInfo = newInfo;
        } else {
            UUID uUID3 = player.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
            savedPokemonInfo = storage.getSelectedPokemon(uUID3, this.isTR);
        }
        MenuProvider menuProvider2 = new MenuProvider(this, storedMoves, filterPokemon, savedPokemonInfo){
            final /* synthetic */ MoveCaseItem this$0;
            final /* synthetic */ Map<String, Integer> $storedMoves;
            final /* synthetic */ Pokemon $filterPokemon;
            final /* synthetic */ MoveCaseStorage.SelectedPokemonInfo $savedPokemonInfo;
            {
                this.this$0 = $receiver;
                this.$storedMoves = $storedMoves;
                this.$filterPokemon = $filterPokemon;
                this.$savedPokemonInfo = $savedPokemonInfo;
            }

            public Component getDisplayName() {
                Component component;
                if (this.this$0.isTR()) {
                    MutableComponent mutableComponent = Component.translatable((String)"container.simpletms.tr_case");
                    Intrinsics.checkNotNull((Object)mutableComponent);
                    component = (Component)mutableComponent;
                } else {
                    MutableComponent mutableComponent = Component.translatable((String)"container.simpletms.tm_case");
                    Intrinsics.checkNotNull((Object)mutableComponent);
                    component = (Component)mutableComponent;
                }
                return component;
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return new MoveCaseMenu(containerId, playerInventory, this.this$0.isTR(), this.$storedMoves, this.$filterPokemon, this.$filterPokemon == null && this.$savedPokemonInfo != null ? new PokemonFilterData(this.$savedPokemonInfo.getSpeciesId(), this.$savedPokemonInfo.getFormName(), this.$savedPokemonInfo.getDisplayName(), this.$savedPokemonInfo.getLearnableMoves()) : null, false, 64, null);
            }
        };
        MenuRegistry.openExtendedMenu((ServerPlayer)player, (MenuProvider)menuProvider2, arg_0 -> MoveCaseItem.openMenu$lambda$6(this, storedMoves, filterPokemon, savedPokemonInfo, isFreshSelection, arg_0));
    }

    static /* synthetic */ void openMenu$default(MoveCaseItem moveCaseItem, ServerPlayer serverPlayer, Pokemon pokemon, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        moveCaseItem.openMenu(serverPlayer, pokemon, bl);
    }

    public final void openMenuWithFreshSelection(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.openMenu(player, null, true);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int totalMoves = MoveCaseHelper.INSTANCE.getSlotCount(this.isTR);
        int storedCount = this.getStoredCountForTooltip();
        if (storedCount >= 0) {
            int percentage = totalMoves > 0 ? storedCount * 100 / totalMoves : 0;
            ChatFormatting color = percentage >= 100 ? ChatFormatting.GOLD : (percentage >= 75 ? ChatFormatting.GREEN : (percentage >= 50 ? ChatFormatting.YELLOW : (percentage >= 25 ? ChatFormatting.RED : ChatFormatting.DARK_RED)));
            Object[] objectArray = new Object[]{storedCount, totalMoves, percentage};
            MutableComponent mutableComponent = Component.translatable((String)"tooltip.simpletms.case.storage", (Object[])objectArray).withStyle(color);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            tooltipComponents.add((Component)mutableComponent);
            if (percentage >= 100) {
                objectArray = new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC};
                MutableComponent mutableComponent2 = Component.translatable((String)"tooltip.simpletms.case.complete").withStyle((ChatFormatting[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
                tooltipComponents.add((Component)mutableComponent2);
            }
        } else {
            Object[] objectArray = new Object[]{totalMoves};
            MutableComponent mutableComponent = Component.translatable((String)"tooltip.simpletms.case.capacity", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            tooltipComponents.add((Component)mutableComponent);
        }
    }

    private final int getStoredCountForTooltip() {
        try {
            ServerPlayer serverPlayer;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer localPlayer = minecraft.player;
            if (localPlayer == null) {
                return -1;
            }
            LocalPlayer player = localPlayer;
            IntegratedServer server = minecraft.getSingleplayerServer();
            if (server != null && (serverPlayer = server.getPlayerList().getPlayer(player.getUUID())) != null) {
                MoveCaseStorage storage = MoveCaseStorage.Companion.get(serverPlayer);
                UUID uUID = player.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                return storage.getStoredMoves(uUID, this.isTR).size();
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static final boolean openPartySelect$lambda$4(Pokemon it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Unit openPartySelect$lambda$5(MoveCaseItem this$0, ServerPlayer $player, Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        MoveCaseItem.openMenu$default(this$0, $player, pokemon, false, 4, null);
        return Unit.INSTANCE;
    }

    private static final void openMenu$lambda$6(MoveCaseItem this$0, Map $storedMoves, Pokemon $filterPokemon, MoveCaseStorage.SelectedPokemonInfo $savedPokemonInfo, boolean $isFreshSelection, FriendlyByteBuf buf) {
        buf.writeBoolean(this$0.isTR);
        buf.writeVarInt($storedMoves.size());
        for (Map.Entry object : $storedMoves.entrySet()) {
            String string = (String)object.getKey();
            int quantity = ((Number)object.getValue()).intValue();
            buf.writeUtf(string);
            buf.writeVarInt(quantity);
        }
        boolean hasFilterData = $filterPokemon != null || $savedPokemonInfo != null;
        buf.writeBoolean(hasFilterData);
        if (hasFilterData) {
            if ($filterPokemon != null) {
                buf.writeUtf($filterPokemon.getSpecies().getResourceIdentifier().toString());
                buf.writeUtf($filterPokemon.getForm().getName());
                buf.writeUtf($filterPokemon.getSpecies().getTranslatedName().getString());
                Set<String> set = Companion.getLearnableMoves($filterPokemon, this$0.isTR);
                buf.writeVarInt(set.size());
                for (String moveName : set) {
                    buf.writeUtf(moveName);
                }
            } else if ($savedPokemonInfo != null) {
                buf.writeUtf($savedPokemonInfo.getSpeciesId());
                buf.writeUtf($savedPokemonInfo.getFormName());
                buf.writeUtf($savedPokemonInfo.getDisplayName());
                buf.writeVarInt($savedPokemonInfo.getLearnableMoves().size());
                for (String string : $savedPokemonInfo.getLearnableMoves()) {
                    buf.writeUtf(string);
                }
            }
            buf.writeBoolean($filterPokemon != null || $isFreshSelection);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldragomordor/simpletms/item/custom/MoveCaseItem$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "isTR", "", "", "getLearnableMoves", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Z)Ljava/util/Set;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getLearnableMoves(@NotNull Pokemon pokemon, boolean isTR) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            SimpleTMsConfig cfg = SimpleTMs.INSTANCE.getConfig();
            Set learnableMoves = new LinkedHashSet();
            if (cfg.getAnyMovesLearnableTMs() && !isTR || cfg.getAnyMovesLearnableTRs() && isTR) {
                return CollectionsKt.toSet((Iterable)MoveCaseHelper.INSTANCE.getSortedMoveNames(isTR));
            }
            List<String> excludedMoves = SimpleTMsItems.INSTANCE.getALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING();
            dragomordor.simpletms.item.custom.MoveCaseItem$Companion.getLearnableMoves$addFromLearnset(isTR, excludedMoves, learnableMoves, cfg, pokemon.getForm().getMoves());
            for (FormData form : pokemon.getSpecies().getForms()) {
                if (Intrinsics.areEqual((Object)form, (Object)pokemon.getForm())) continue;
                dragomordor.simpletms.item.custom.MoveCaseItem$Companion.getLearnableMoves$addFromLearnset(isTR, excludedMoves, learnableMoves, cfg, form.getMoves());
            }
            if (cfg.getPrimaryTypeMovesLearnable() || cfg.getSecondaryTypeMovesLearnable()) {
                ElementalType primary = pokemon.getPrimaryType();
                ElementalType secondary = pokemon.getSecondaryType();
                for (String moveName : MoveCaseHelper.INSTANCE.getSortedMoveNames(isTR)) {
                    MoveTemplate move;
                    if (excludedMoves.contains(moveName) || learnableMoves.contains(moveName) || Moves.getByName((String)moveName) == null) continue;
                    if (cfg.getPrimaryTypeMovesLearnable() && Intrinsics.areEqual((Object)move.getElementalType(), (Object)primary)) {
                        learnableMoves.add(moveName);
                    }
                    if (!cfg.getSecondaryTypeMovesLearnable() || !Intrinsics.areEqual((Object)move.getElementalType(), (Object)secondary)) continue;
                    learnableMoves.add(moveName);
                }
            }
            return learnableMoves;
        }

        private static final void getLearnableMoves$addFromLearnset(boolean $isTR, List<String> excludedMoves, Set<String> learnableMoves, SimpleTMsConfig cfg, Learnset learnset) {
            for (String moveName : MoveCaseHelper.INSTANCE.getSortedMoveNames($isTR)) {
                MoveTemplate move;
                if (excludedMoves.contains(moveName) || learnableMoves.contains(moveName) || Moves.getByName((String)moveName) == null) continue;
                if (cfg.getTmMovesLearnable() && LearnsetQuery.Companion.getTM_MOVE().canLearn(move, learnset)) {
                    learnableMoves.add(moveName);
                    continue;
                }
                if (cfg.getTutorMovesLearnable() && LearnsetQuery.Companion.getTUTOR_MOVES().canLearn(move, learnset)) {
                    learnableMoves.add(moveName);
                    continue;
                }
                if (cfg.getEggMovesLearnable() && LearnsetQuery.Companion.getEGG_MOVE().canLearn(move, learnset)) {
                    learnableMoves.add(moveName);
                    continue;
                }
                if (cfg.getLevelMovesLearnable() && LearnsetQuery.Companion.getANY_LEVEL().canLearn(move, learnset)) {
                    learnableMoves.add(moveName);
                    continue;
                }
                if (cfg.getLegacyMovesLearnable() && LearnsetQuery.Companion.getLEGACY_MOVES().canLearn(move, learnset)) {
                    learnableMoves.add(moveName);
                    continue;
                }
                if (!cfg.getSpecialMovesLearnable() || !LearnsetQuery.Companion.getSPECIAL_MOVES().canLearn(move, learnset)) continue;
                learnableMoves.add(moveName);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

